/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.updatesite.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.ui.views.IServiceAccessHandler;
import org.eclipse.ecf.internal.examples.updatesite.client.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.NamedModelObject;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.ui.UpdateManagerUI;

public class UpdateSiteServiceAccessHandler
implements IServiceAccessHandler {
    static final String SERVICE = Messages.UpdateSiteServiceAccessHandler_UPDATESITE_SERVICE;
    static final String PATH = "path";
    static final String NAME = "name";
    static final String BROWSER_PATH_SUFFIX = Messages.UpdateSiteServiceAccessHandler_UPDATESITE_INDEX_HTML;
    static final IContributionItem[] EMPTY_CONTRIBUTION = new IContributionItem[0];

    public IContributionItem[] getContributionsForService(IServiceInfo serviceInfo) {
        IServiceID serviceID = serviceInfo.getServiceID();
        List<String> serviceTypes = Arrays.asList(serviceID.getServiceTypeID().getServices());
        String protocol = null;
        if (serviceTypes.contains(SERVICE)) {
            protocol = "http";
        }
        if (protocol == null) {
            return EMPTY_CONTRIBUTION;
        }
        URI location = serviceInfo.getLocation();
        StringBuffer buf = new StringBuffer(protocol);
        buf.append("://").append(location.getHost());
        if (location.getPort() != -1) {
            buf.append(":").append(location.getPort());
        }
        String path = serviceInfo.getServiceProperties().getPropertyString(PATH);
        final String name = serviceInfo.getServiceProperties().getPropertyString(NAME);
        if (path != null) {
            buf.append(path);
        }
        final String urlString = buf.toString();
        Action openUpdateSiteAction = new Action(){

            public void run() {
                UpdateSiteServiceAccessHandler.this.addURLToUpdateSite(name, urlString);
            }
        };
        openUpdateSiteAction.setText(Messages.UpdateSiteServiceAccessHandler_OPEN_INSTALLER_MENU_TEXT);
        Action browserAction = new Action(){

            public void run() {
                UpdateSiteServiceAccessHandler.this.openBrowser(String.valueOf(urlString) + BROWSER_PATH_SUFFIX);
            }
        };
        browserAction.setText(Messages.UpdateSiteServiceAccessHandler_OPEN_BROWSER_MENU_TEXT);
        return new IContributionItem[]{new ActionContributionItem((IAction)openUpdateSiteAction), new ActionContributionItem((IAction)browserAction)};
    }

    private void addURLToUpdateSite(String name, String urlString) {
        try {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            SiteBookmark bookmark = new SiteBookmark(name, new URL(urlString), false);
            bookmark.setSelected(true);
            model.addBookmark((NamedModelObject)bookmark);
            model.saveBookmarks();
            UpdateManagerUI.openInstaller((Shell)Display.getDefault().getActiveShell());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected void openBrowser(String urlString) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            support.createBrowser(null).openURL(new URL(urlString));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

