/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.msn;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.ecf.protocol.msn.Group;
import org.eclipse.ecf.protocol.msn.Status;
import org.eclipse.ecf.protocol.msn.events.IContactListener;
import org.eclipse.ecf.protocol.msn.internal.encode.StringUtils;

public final class Contact {
    private final ArrayList listeners;
    private final ArrayList groups;
    private final String email;
    private final String guid;
    private String name;
    private String personalMessage;
    private Status status;

    Contact(String email, String name) {
        this(email, name, null);
    }

    Contact(String email, String name, String guid) {
        this.name = URLDecoder.decode(name);
        this.email = email;
        this.guid = guid;
        this.status = Status.OFFLINE;
        this.listeners = new ArrayList();
        this.groups = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatusChanged(Status status) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListener)this.listeners.get(i)).statusChanged(status);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNameChanged(String name) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListener)this.listeners.get(i)).nameChanged(name);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePersonalMessageChanged(String message) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IContactListener)this.listeners.get(i)).personalMessageChanged(message);
                ++i;
            }
        }
    }

    void add(Group group) {
        this.groups.add(group);
    }

    void remove() {
        int i = 0;
        while (i < this.groups.size()) {
            ((Group)this.groups.get(i)).remove(this);
            ++i;
        }
        this.groups.clear();
    }

    public Collection getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    void setStatus(Status status) {
        if (this.status != status) {
            this.status = status;
            this.fireStatusChanged(status);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    void setDisplayName(String newName) {
        if (!(newName = URLDecoder.decode(newName)).equals(this.name)) {
            this.name = newName;
            this.fireNameChanged(newName);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    void setPersonalMessage(String message) {
        if (!(message = StringUtils.xmlDecode(message)).equals(this.personalMessage)) {
            this.personalMessage = message;
            this.firePersonalMessageChanged(message);
        }
    }

    public String getPersonalMessage() {
        return this.personalMessage;
    }

    public String getEmail() {
        return this.email;
    }

    String getGuid() {
        return this.guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactListener(IContactListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactListener(IContactListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(listener);
            }
        }
    }

    public String toString() {
        return this.email;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Contact) {
            return this.email.equals(((Contact)obj).email);
        }
        return false;
    }

    public int hashCode() {
        return -31 + this.email.hashCode();
    }
}

