/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.bittorrent;

import java.io.IOException;
import org.eclipse.bittorrent.IPieceProgressListener;
import org.eclipse.bittorrent.ITorrentStateListener;
import org.eclipse.bittorrent.Torrent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IFileTransferRateControl;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;

final class TorrentFileTransfer
implements IFileTransferPausable,
IFileTransferRateControl,
IIncomingFileTransfer,
IOutgoingFileTransfer {
    private final ID id;
    private final IFileTransferListener listener;
    private final Torrent torrent;
    private final IPieceProgressListener pieceListener;
    private final ITorrentStateListener stateListener;
    private final double total;
    private Exception exception;
    private boolean paused = false;

    TorrentFileTransfer(ID id, IFileTransferListener listener, Torrent torrent) {
        this.id = id;
        this.listener = listener;
        this.torrent = torrent;
        this.total = torrent.getTorrentFile().getTotalLength();
        this.pieceListener = new IPieceProgressListener(){

            public void blockDownloaded(int piece, int index, int blockLength) {
                TorrentFileTransfer.this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveDataEvent(this){
                    private static final long serialVersionUID = -7666111308704272599L;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IIncomingFileTransfer getSource() {
                        return 1.access$0(this.this$1);
                    }
                });
            }

            static /* synthetic */ TorrentFileTransfer access$0(1 var0) {
                return var0.TorrentFileTransfer.this;
            }
        };
        this.stateListener = new ITorrentStateListener(){

            public void stateChanged(int state) {
                if (state == 3) {
                    TorrentFileTransfer.this.notifyCompletion(null);
                }
            }
        };
        torrent.addPieceProgressListener(this.pieceListener);
        torrent.addTorrentStateListener(this.stateListener);
        try {
            torrent.start();
        }
        catch (IOException e) {
            this.notifyCompletion(e);
        }
    }

    private void notifyCompletion(Exception exception) {
        this.exception = exception;
        this.torrent.removePieceProgressListener(this.pieceListener);
        this.torrent.removeTorrentStateListener(this.stateListener);
        this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveDoneEvent(){
            private static final long serialVersionUID = -6685158329789351560L;

            public Exception getException() {
                return TorrentFileTransfer.this.exception;
            }

            public IIncomingFileTransfer getSource() {
                return TorrentFileTransfer.this;
            }
        });
    }

    public void cancel() {
        try {
            this.torrent.stop();
            this.notifyCompletion((Exception)new UserCancelledException());
        }
        catch (IOException e) {
            this.notifyCompletion(e);
        }
    }

    public long getBytesSent() {
        return this.torrent.getUploaded();
    }

    public Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        return (this.total - (double)this.torrent.getRemaining()) / this.total;
    }

    public Object getAdapter(Class adapter) {
        return adapter.isInstance(this) ? this : null;
    }

    public ID getID() {
        return this.id;
    }

    public long getBytesReceived() {
        return this.torrent.getDownloaded();
    }

    public boolean isDone() {
        return this.exception != null || this.getPercentComplete() == 1.0;
    }

    public boolean pause() {
        if (this.paused || this.isDone()) {
            return false;
        }
        try {
            this.torrent.stop();
            this.paused = true;
            return true;
        }
        catch (IOException e) {
            this.notifyCompletion(e);
            return false;
        }
    }

    public boolean resume() {
        if (!this.paused || this.isDone()) {
            return false;
        }
        try {
            this.torrent.start();
            this.paused = false;
            return true;
        }
        catch (IOException e) {
            this.notifyCompletion(e);
            return false;
        }
    }

    public void setMaxDownloadSpeed(long maxDownloadSpeed) {
        this.torrent.setMaxDownloadSpeed(maxDownloadSpeed);
    }

    public void setMaxUploadSpeed(long maxUploadSpeed) {
        this.torrent.setMaxUploadSpeed(maxUploadSpeed);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public IFileTransferListener getListener() {
        return this.listener;
    }

    public IFileRangeSpecification getFileRangeSpecification() {
        return null;
    }

    public long getFileLength() {
        return this.torrent.getTorrentFile().getTotalLength();
    }

    public String getRemoteFileName() {
        if (this.torrent == null) {
            return null;
        }
        if (!this.torrent.getTorrentFile().isMultiFile()) {
            return this.torrent.getTorrentFile().getFilenames()[0];
        }
        return null;
    }
}

