/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui.wizards;

import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.irc.ui.IRCUI;
import org.eclipse.ecf.internal.irc.ui.wizards.IRCConnectWizardPage;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.actions.AsynchContainerConnectAction;
import org.eclipse.ecf.ui.dialogs.IDCreateErrorDialog;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public final class IRCConnectWizard
extends Wizard
implements IConnectWizard {
    public static final String DEFAULT_GUEST_USER = "guest";
    private IRCConnectWizardPage page;
    private IContainer container;
    private ID targetID;
    private IConnectContext connectContext;
    private String authorityAndPath = null;
    static /* synthetic */ Class class$0;

    public IRCConnectWizard() {
    }

    public IRCConnectWizard(String authorityAndPart) {
        this.authorityAndPath = authorityAndPart;
    }

    public void addPages() {
        this.page = new IRCConnectWizardPage(this.authorityAndPath);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.container = container;
    }

    public boolean performFinish() {
        final String connectID = this.page.getConnectID();
        final String password = this.page.getPassword();
        this.connectContext = ConnectContextFactory.createPasswordConnectContext((String)password);
        this.page.saveComboText();
        try {
            this.targetID = IDFactory.getDefault().createID(this.container.getConnectNamespace(), connectID);
        }
        catch (IDCreateException e) {
            new IDCreateErrorDialog(null, connectID, e).open();
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.presence.chatroom.IChatRoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IChatRoomManager manager = (IChatRoomManager)this.container.getAdapter((Class)clazz);
        IRCUI ui = new IRCUI(this.container, manager, null);
        ui.showForTarget(this.targetID);
        if (!ui.isContainerConnected()) {
            this.page.saveComboItems();
            new AsynchContainerConnectAction(this.container, this.targetID, this.connectContext, null, new Runnable(){

                public void run() {
                    IRCConnectWizard.this.cachePassword(IRCConnectWizard.this.page.getPasswordKeyFromUserName(connectID), password);
                }
            }).run();
        }
        return true;
    }

    protected void cachePassword(String connectID, String password) {
        if (password != null && !password.equals("")) {
            PasswordCacheHelper pwStorage = new PasswordCacheHelper(connectID);
            pwStorage.savePassword(password);
        }
    }
}

