/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.provider.remoteservice.Messages;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteCallImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceReferenceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistryImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;

public class RemoteServiceRegistrationImpl
implements IRemoteServiceRegistration,
Serializable {
    private static final long serialVersionUID = -3206899332723536545L;
    transient Object service;
    protected String[] clazzes;
    protected long serviceid;
    protected Properties properties;
    protected int serviceranking;
    protected transient Object registrationLock = new Object();
    protected int state = 0;
    protected ID containerID = null;
    public static final int REGISTERED = 0;
    public static final int UNREGISTERING = 1;
    public static final int UNREGISTERED = 2;
    protected transient RemoteServiceReferenceImpl reference = null;
    protected transient RegistrySharedObject sharedObject = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(RegistrySharedObject sharedObject1, RemoteServiceRegistryImpl registry, Object svc, String[] clzzes, Dictionary props) {
        this.sharedObject = sharedObject1;
        this.service = svc;
        this.clazzes = clzzes;
        this.containerID = registry.getContainerID();
        this.reference = new RemoteServiceReferenceImpl(this);
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = registry;
        synchronized (remoteServiceRegistryImpl) {
            this.serviceid = registry.getNextServiceId();
            this.properties = this.createProperties(props);
            registry.publishService(this);
        }
    }

    public Object getService() {
        return this.service;
    }

    public ID getContainerID() {
        return this.containerID;
    }

    protected String[] getClasses() {
        return this.clazzes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference getReference() {
        if (this.reference == null) {
            RemoteServiceRegistrationImpl remoteServiceRegistrationImpl = this;
            synchronized (remoteServiceRegistrationImpl) {
                this.reference = new RemoteServiceReferenceImpl(this);
            }
        }
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary properties) {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException(Messages.RemoteServiceRegistrationImpl_EXCEPTION_SERVICE_ALREADY_REGISTERED);
            }
            this.properties = this.createProperties(properties);
        }
    }

    public void unregister() {
        if (this.sharedObject != null) {
            this.sharedObject.sendUnregister(this);
        }
    }

    protected Properties createProperties(Dictionary props) {
        Properties resultProps = new Properties(props);
        resultProps.setProperty("remote.objectClass", this.clazzes);
        resultProps.setProperty("remote.service.id", new Long(this.serviceid));
        Object ranking = resultProps.getProperty("remote.service.ranking");
        this.serviceranking = ranking instanceof Integer ? (Integer)ranking : 0;
        return resultProps;
    }

    public Object getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String[] getPropertyKeys() {
        return this.properties.getPropertyKeys();
    }

    public long getServiceId() {
        return this.serviceid;
    }

    public Object callService(RemoteCallImpl call) throws Exception {
        return call.invoke(this.service);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RemoteServiceRegistrationImpl[");
        buf.append("containerID=").append(this.containerID).append(";");
        buf.append("serviceid=").append(this.serviceid).append(";");
        buf.append("serviceranking=").append(this.serviceranking).append(";");
        buf.append("classes=").append(Arrays.asList(this.clazzes)).append(";");
        buf.append("state=").append(this.state).append(";");
        buf.append("properties=").append(this.properties).append("]");
        return buf.toString();
    }

    static class Properties
    extends Hashtable {
        private static final long serialVersionUID = -3684607010228779249L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties(int size, Dictionary props) {
            super((size << 1) + 1);
            if (props != null) {
                Dictionary dictionary = props;
                synchronized (dictionary) {
                    Enumeration keysEnum = props.keys();
                    while (keysEnum.hasMoreElements()) {
                        Object key = keysEnum.nextElement();
                        if (!(key instanceof String)) continue;
                        String header = (String)key;
                        this.setProperty(header, props.get(header));
                    }
                }
            }
        }

        protected Properties(Dictionary props) {
            this(props == null ? 2 : Math.max(2, props.size()), props);
        }

        protected Object getProperty(String key) {
            return Properties.cloneValue(this.get(key));
        }

        protected synchronized String[] getPropertyKeys() {
            int size = this.size();
            String[] keynames = new String[size];
            Enumeration keysEnum = this.keys();
            int i = 0;
            while (i < size) {
                keynames[i] = (String)keysEnum.nextElement();
                ++i;
            }
            return keynames;
        }

        protected synchronized Object setProperty(String key, Object value) {
            return this.put(key, Properties.cloneValue(value));
        }

        protected static Object cloneValue(Object value) {
            block7: {
                if (value == null) {
                    return null;
                }
                if (value instanceof String) {
                    return value;
                }
                Class<?> clazz = value.getClass();
                if (clazz.isArray()) {
                    Class<?> type = clazz.getComponentType();
                    int len = Array.getLength(value);
                    Object clonedArray = Array.newInstance(type, len);
                    System.arraycopy(value, 0, clonedArray, 0, len);
                    return clonedArray;
                }
                try {
                    return clazz.getMethod("clone", null).invoke(value, null);
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    if (value instanceof Vector) {
                        return ((Vector)value).clone();
                    }
                    if (!(value instanceof Hashtable)) break block7;
                    return ((Hashtable)value).clone();
                }
            }
            return value;
        }

        public synchronized String toString() {
            String[] keys = this.getPropertyKeys();
            int size = keys.length;
            StringBuffer sb = new StringBuffer(20 * size);
            sb.append('{');
            int n = 0;
            int i = 0;
            while (i < size) {
                String key = keys[i];
                if (!key.equals("remote.objectClass")) {
                    if (n > 0) {
                        sb.append(", ");
                    }
                    sb.append(key);
                    sb.append('=');
                    Object value = this.get(key);
                    if (value.getClass().isArray()) {
                        sb.append('[');
                        int length = Array.getLength(value);
                        int j = 0;
                        while (j < length) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(Array.get(value, j));
                            ++j;
                        }
                        sb.append(']');
                    } else {
                        sb.append(value);
                    }
                    ++n;
                }
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

