/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ecf.internal.provider.xmpp.ui.Activator;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XMPPConnectWizardPage
extends WizardPage {
    Combo connectText;
    Text passwordText;
    String usernameAtHost;
    static Pattern emailPattern = Pattern.compile(".+@.+.[a-z]+(:[0-9]+)?");
    private static final String PAGE_SETTINGS;
    private static final int MAX_COMBO_VALUES = 40;
    private static final String COMBO_TEXT_KEY = "connectTextValue";
    private static final String COMBO_BOX_ITEMS_KEY = "comboValues";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_SETTINGS = clazz.getName();
    }

    XMPPConnectWizardPage() {
        super("");
        this.setTitle(Messages.XMPPConnectWizardPage_WIZARD_TITLE);
        this.setDescription(Messages.XMPPConnectWizardPage_WIZARD_DESCRIPTION);
        this.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_CHAT_WIZARD"));
    }

    XMPPConnectWizardPage(String usernameAtHost) {
        this();
        this.usernameAtHost = usernameAtHost;
    }

    private void verify() {
        String text = this.connectText.getText();
        if (text.equals("")) {
            this.updateStatus(Messages.XMPPConnectWizardPage_WIZARD_STATUS);
        } else {
            Matcher matcher = emailPattern.matcher(text);
            if (!matcher.matches()) {
                this.updateStatus(Messages.XMPPConnectWizardPage_WIZARD_STATUS_INCOMPLETE);
            } else {
                this.restorePassword(text);
                this.updateStatus(null);
            }
        }
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        GridData fillData = new GridData(4, 0x1000000, true, false);
        GridData endData = new GridData(4, 0x1000000, true, false, 2, 1);
        Label label = new Label(parent, 16384);
        label.setText(Messages.XMPPConnectWizardPage_LABEL_USERID);
        this.connectText = new Combo(parent, 2052);
        this.connectText.setLayoutData((Object)fillData);
        this.connectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMPPConnectWizardPage.this.verify();
            }
        });
        this.connectText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XMPPConnectWizardPage.this.verify();
            }

            public void widgetSelected(SelectionEvent e) {
                XMPPConnectWizardPage.this.verify();
            }
        });
        label = new Label(parent, 131072);
        label.setText(Messages.XMPPConnectWizardPage_USERID_TEMPLATE);
        label.setLayoutData((Object)endData);
        label = new Label(parent, 16384);
        label.setText(Messages.XMPPConnectWizardPage_WIZARD_PASSWORD);
        this.passwordText = new Text(parent, 0x400804);
        this.passwordText.setLayoutData((Object)fillData);
        this.restoreCombo();
        if (this.usernameAtHost != null) {
            this.connectText.setText(this.usernameAtHost);
            this.restorePassword(this.usernameAtHost);
            this.passwordText.setFocus();
        }
        if (this.connectText.getText().equals("")) {
            this.updateStatus(null);
            this.setPageComplete(false);
        } else if (this.isPageComplete()) {
            this.passwordText.setFocus();
        }
        this.setControl((Control)parent);
    }

    protected void restorePassword(String username) {
        PasswordCacheHelper pwStorage = new PasswordCacheHelper(username);
        String pw = pwStorage.retrievePassword();
        if (pw != null) {
            this.passwordText.setText(pw);
            this.passwordText.setSelection(0, pw.length());
        }
    }

    String getConnectID() {
        return this.connectText.getText();
    }

    String getPassword() {
        return this.passwordText.getText();
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected void saveComboText() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(COMBO_TEXT_KEY, this.connectText.getText());
        }
    }

    protected void saveComboItems() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            String connectTextValue = this.connectText.getText();
            List<String> rawItems = Arrays.asList(this.connectText.getItems());
            ArrayList<String> items = new ArrayList<String>();
            if (!rawItems.contains(connectTextValue)) {
                items.add(connectTextValue);
            }
            items.addAll(rawItems);
            int itemsToSaveLength = items.size();
            if (itemsToSaveLength > 40) {
                itemsToSaveLength = 40;
            }
            String[] itemsToSave = new String[itemsToSaveLength];
            System.arraycopy(items.toArray(new String[0]), 0, itemsToSave, 0, itemsToSaveLength);
            pageSettings.put(COMBO_BOX_ITEMS_KEY, itemsToSave);
        }
    }

    public IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    private IDialogSettings getPageSettings() {
        IDialogSettings pageSettings = null;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            pageSettings = dialogSettings.getSection(PAGE_SETTINGS);
            if (pageSettings == null) {
                pageSettings = dialogSettings.addNewSection(PAGE_SETTINGS);
            }
            return pageSettings;
        }
        return null;
    }

    protected void restoreCombo() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            String text;
            String[] items = pageSettings.getArray(COMBO_BOX_ITEMS_KEY);
            if (items != null) {
                this.connectText.setItems(items);
            }
            if ((text = pageSettings.get(COMBO_TEXT_KEY)) != null) {
                this.connectText.setText(text);
            }
        }
    }
}

