/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bittorrent.Torrent;

public class TorrentServer {
    private static final Map activeTorrents = new HashMap();
    private static TorrentServer peerListener;
    private static int port;
    private final ByteBuffer buffer = ByteBuffer.allocate(68);
    private final byte[] bufferArray = this.buffer.array();
    private final byte[] handshake = new byte[20];
    private ServerSocketChannel channel = ServerSocketChannel.open();
    private ServerSocket serverSocket = this.channel.socket();
    private Thread listeningThread;

    static {
        port = -1;
        try {
            peerListener = new TorrentServer(null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static void setPort(int port) throws IOException {
        if (port < 0) {
            throw new IllegalArgumentException("Cannot listen for incoming connections on a negative port: " + port);
        }
        if (peerListener == null || TorrentServer.port != port) {
            try {
                TorrentServer.peerListener.channel.close();
            }
            catch (IOException iOException) {}
            peerListener = new TorrentServer(port);
            peerListener.listen();
        }
    }

    public static int getPort() {
        return port;
    }

    static void addTorrent(String hash, Torrent torrent) {
        if (!activeTorrents.containsKey(hash)) {
            activeTorrents.put(hash, torrent);
            if (activeTorrents.size() == 1) {
                peerListener.listen();
            }
        }
    }

    static Torrent get(String hash) {
        return (Torrent)activeTorrents.get(hash);
    }

    static Torrent remove(String hash) {
        Torrent host = (Torrent)activeTorrents.remove(hash);
        if (activeTorrents.isEmpty()) {
            try {
                TorrentServer.peerListener.channel.close();
            }
            catch (IOException iOException) {}
            TorrentServer.peerListener.listeningThread = null;
        }
        return host;
    }

    private TorrentServer(InetSocketAddress address) throws IOException {
        this.serverSocket.bind(address);
        port = this.serverSocket.getLocalPort();
    }

    private TorrentServer(int port) throws IOException {
        this(new InetSocketAddress("localhost", port));
    }

    private void listen() {
        if (this.listeningThread == null) {
            this.listeningThread = new ListeningThread();
            this.listeningThread.start();
        }
    }

    private class ListeningThread
    extends Thread {
        public ListeningThread() {
            super("Listening Thread");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int read = 0;
            int ret = 0;
            try {
                while (true) {
                    SocketChannel socketChannel;
                    if ((ret = (socketChannel = TorrentServer.this.channel.accept()).read(TorrentServer.this.buffer)) == -1) {
                        try {
                            socketChannel.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    read += ret;
                    while (read < 68) {
                        ret = socketChannel.read(TorrentServer.this.buffer);
                        if (ret == -1) {
                            try {
                                socketChannel.close();
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                        read += ret;
                    }
                    if (ret == -1) continue;
                    System.arraycopy(TorrentServer.this.bufferArray, 28, TorrentServer.this.handshake, 0, 20);
                    Torrent torrent = (Torrent)activeTorrents.get(new String(TorrentServer.this.handshake, "ISO-8859-1"));
                    if (torrent != null) {
                        torrent.connectTo(socketChannel);
                    } else {
                        try {
                            socketChannel.close();
                        }
                        catch (IOException iOException) {}
                    }
                    TorrentServer.this.buffer.clear();
                }
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
                return;
            }
            catch (ClosedChannelException closedChannelException) {
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

