/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.ui.views.IServiceAccessHandler;
import org.eclipse.ecf.internal.discovery.ui.Activator;
import org.eclipse.ecf.internal.discovery.ui.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class HttpServiceAccessHandler
implements IServiceAccessHandler {
    private static final String RFC2782_PATH = "path";
    static final IContributionItem[] EMPTY_CONTRIBUTION = new IContributionItem[0];

    public IContributionItem[] getContributionsForService(IServiceInfo serviceInfo) {
        IServiceProperties svcProps;
        String path;
        IServiceID serviceID = serviceInfo.getServiceID();
        List<String> serviceTypes = Arrays.asList(serviceID.getServiceTypeID().getServices());
        String protocol = null;
        if (serviceTypes.size() == 1 && serviceTypes.contains("http")) {
            protocol = "http";
        } else if (serviceTypes.size() == 1 && serviceTypes.contains("https")) {
            protocol = "https";
        }
        if (protocol == null) {
            return EMPTY_CONTRIBUTION;
        }
        URI location = serviceInfo.getLocation();
        StringBuffer buf = new StringBuffer(protocol);
        buf.append("://").append(location.getHost());
        if (location.getPort() != -1) {
            buf.append(":").append(location.getPort());
        }
        if ((path = (svcProps = serviceInfo.getServiceProperties()).getPropertyString(RFC2782_PATH)) != null) {
            buf.append(path);
        }
        final String urlString = buf.toString();
        Action action = new Action(){

            public void run() {
                HttpServiceAccessHandler.this.openBrowser(urlString);
            }
        };
        action.setText(NLS.bind((String)Messages.HttpServiceAccessHandler_MENU_TEXT, (Object)urlString));
        return new IContributionItem[]{new ActionContributionItem((IAction)action)};
    }

    protected void openBrowser(String urlString) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            support.createBrowser(null).openURL(new URL(urlString));
        }
        catch (Exception e) {
            this.logError(Messages.HttpServiceAccessHandler_EXCEPTION_CREATEBROWSER, e);
        }
    }

    protected void logError(String exceptionString, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.discovery.ui", 4, exceptionString, e));
    }
}

