/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.example.collab.editor.message.SharedEditorSessionList;
import org.eclipse.ecf.example.collab.editor.model.SessionInstance;
import org.eclipse.ecf.example.collab.editor.preferences.ClientPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private static boolean listenerActive;
    private List sessionNames;
    private IChannelListener presenceChannelListener = null;
    private IChannel presenceChannel;
    private IContainer presenceContainer = null;
    public static final String PLUGIN_ID = "org.eclipse.ecf.example.collab.editor";
    static /* synthetic */ Class class$0;

    static {
        listenerActive = true;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ClientPreferencePage p = new ClientPreferencePage();
        p.initializeDefaults();
        this.sessionNames = new ArrayList();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public boolean isListenerActive() {
        return listenerActive;
    }

    public synchronized void setListenerActive(boolean active) {
        listenerActive = active;
    }

    public void addSession(String channelID, String sessionName) {
        this.sessionNames.add(new SessionInstance(channelID, sessionName, this.getPreferenceStore().getString("LOCAL_NAME"), Calendar.getInstance().getTime()));
        if (this.presenceChannel != null) {
            try {
                this.presenceChannel.sendMessage(new SharedEditorSessionList(this.sessionNames).toByteArray());
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public IChannelListener getPresenceChannelListener() {
        return this.presenceChannelListener;
    }

    public IChannel intializePresenceSession(IChannelListener clistener) throws ECFException {
        this.presenceContainer = ContainerFactory.getDefault().createContainer(Activator.getDefault().getPreferenceStore().getString("CONTAINER_TYPE"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IChannelContainerAdapter channelContainer = (IChannelContainerAdapter)this.presenceContainer.getAdapter((Class)clazz);
        ID channelID = IDFactory.getDefault().createID(channelContainer.getChannelNamespace(), String.valueOf(Activator.getDefault().getPreferenceStore().getString("CHANNEL_ID")) + ".presence");
        this.presenceChannel = channelContainer.createChannel(channelID, clistener, new HashMap());
        this.presenceChannelListener = clistener;
        this.presenceContainer.connect(IDFactory.getDefault().createID(this.presenceContainer.getConnectNamespace(), Activator.getDefault().getPreferenceStore().getString("TARGET_SERVER")), null);
        return this.presenceChannel;
    }

    public IChannel getPresenceChannel() {
        return this.presenceChannel;
    }

    public List getSessionNames() {
        return this.sessionNames;
    }
}

