/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.example.collab.share.SharedObjectEventListener;
import org.eclipse.ecf.example.collab.share.User;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SharedObjectContainerUI {
    public static final String JOIN_TIME_FORMAT = "hh:mm:ss a z";
    public static final String FILE_DIRECTORY = "received_files";
    public static final String ECFDIRECTORY = "ECF_received_files/";
    public static final String COLLAB_SHARED_OBJECT_ID = "chat";
    ISharedObjectContainer soc = null;
    CollabClient collabclient = null;

    public SharedObjectContainerUI(CollabClient client, ISharedObjectContainer soc) {
        this.collabclient = client;
        this.soc = soc;
    }

    protected String getSharedFileDirectoryForProject(IResource proj) {
        String eclipseDir = Platform.getLocation().lastSegment();
        if (proj == null) {
            return String.valueOf(eclipseDir) + "/" + ECFDIRECTORY;
        }
        return FILE_DIRECTORY;
    }

    protected User getUserData(String containerType, ID clientID, String usernick, IResource project) {
        Vector<String> topElements = new Vector<String>();
        topElements.add(String.valueOf(Messages.SharedObjectContainerUI_PROJECT_LABEL) + CollabClient.getNameForResource(project));
        SimpleDateFormat sdf = new SimpleDateFormat(JOIN_TIME_FORMAT);
        topElements.add(String.valueOf(Messages.SharedObjectContainerUI_TIME_LABEL) + sdf.format(new Date()));
        try {
            topElements.add(String.valueOf(Messages.SharedObjectContainerUI_LANGUAGE_LABEL) + System.getProperty("user.language"));
        }
        catch (Exception exception) {}
        try {
            topElements.add(String.valueOf(Messages.SharedObjectContainerUI_TIME_ZONE_LABEL) + System.getProperty("user.timezone"));
        }
        catch (Exception exception) {}
        try {
            topElements.add(String.valueOf(Messages.SharedObjectContainerUI_OSGI_VERSION_LABEL) + System.getProperty("org.osgi.framework.version"));
        }
        catch (Exception exception) {}
        try {
            topElements.add(String.valueOf(Messages.SharedObjectContainerUI_JAVA_VERSION_LABEL) + System.getProperty("java.version"));
        }
        catch (Exception exception) {}
        try {
            topElements.add(String.valueOf(Messages.SharedObjectContainerUI_OS_LABEL) + Platform.getOS());
        }
        catch (Exception exception) {}
        return new User(clientID, usernick, topElements);
    }

    void addObjectToClient(ISharedObjectContainer soContainer, ClientEntry client, String username, IResource proj) throws Exception {
        IResource project = proj == null ? CollabClient.getWorkspace() : proj;
        User user = this.getUserData(client.getClass().getName(), client.getContainer().getID(), username, proj);
        this.createAndAddSharedObject(soContainer, client, project, user, this.getSharedFileDirectoryForProject(project));
    }

    public void setup(ISharedObjectContainer soContainer, final ClientEntry newClientEntry, final IResource resource, String username) throws Exception {
        this.addObjectToClient(soContainer, newClientEntry, username, resource);
        this.soc.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent evt) {
                if (evt instanceof IContainerDisconnectedEvent) {
                    IContainerDisconnectedEvent cd = (IContainerDisconnectedEvent)evt;
                    ID departedContainerID = cd.getTargetID();
                    ID connectedID = newClientEntry.getContainer().getConnectedID();
                    if ((connectedID == null || connectedID.equals((Object)departedContainerID)) && !newClientEntry.isDisposed()) {
                        SharedObjectContainerUI.this.collabclient.disposeClient(resource, newClientEntry);
                    }
                } else if (evt instanceof IContainerEjectedEvent) {
                    IContainerEjectedEvent ce = (IContainerEjectedEvent)evt;
                    ID departedContainerID = ce.getTargetID();
                    ID connectedID = newClientEntry.getContainer().getConnectedID();
                    if ((connectedID == null || connectedID.equals((Object)departedContainerID)) && !newClientEntry.isDisposed()) {
                        SharedObjectContainerUI.this.collabclient.disposeClient(resource, newClientEntry);
                    }
                }
            }
        });
    }

    protected void createAndAddSharedObject(ISharedObjectContainer soContainer, final ClientEntry client, final IResource proj, User user, String fileDir) throws Exception {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        EclipseCollabSharedObject sharedObject = new EclipseCollabSharedObject(proj, ww, user, fileDir);
        sharedObject.setListener(new SharedObjectEventListener(){

            public void memberRemoved(ID member) {
                ID groupID = client.getContainer().getConnectedID();
                if (member.equals((Object)groupID) && !client.isDisposed()) {
                    SharedObjectContainerUI.this.collabclient.disposeClient(proj, client);
                }
            }

            public void memberAdded(ID member) {
            }

            public void otherActivated(ID other) {
            }

            public void otherDeactivated(ID other) {
            }

            public void windowClosing() {
                ID groupID = client.getContainer().getConnectedID();
                CollabClient.removeClientForResource(proj, groupID);
            }
        });
        ID newID = IDFactory.getDefault().createStringID(COLLAB_SHARED_OBJECT_ID);
        soContainer.getSharedObjectManager().addSharedObject(newID, (ISharedObject)sharedObject, new HashMap());
        client.setSharedObject(sharedObject);
    }
}

