/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.ui.dialogs;

import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.ui.MultiRosterAccount;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddContactDialog
extends Dialog {
    private ComboViewer accountsViewer;
    private Text accountText;
    private Text aliasText;
    private Button okBtn;
    private IPresenceContainerAdapter selection;
    private String accountID;
    private String alias;
    private Object input;

    public AddContactDialog(Shell parentShell) {
        super(parentShell);
    }

    private void addListeners() {
        this.accountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddContactDialog.this.okBtn.setEnabled(AddContactDialog.this.selection != null && !AddContactDialog.this.accountText.getText().equals(""));
            }
        });
        this.accountsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection iss = (IStructuredSelection)e.getSelection();
                AddContactDialog.this.selection = ((MultiRosterAccount)iss.getFirstElement()).getPresenceContainerAdapter();
                AddContactDialog.this.okBtn.setEnabled(!AddContactDialog.this.accountText.getText().equals(""));
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddContactDialog_DialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okBtn = this.getButton(0);
        this.okBtn.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 4, true, true);
        new Label(parent, 1).setText(Messages.AddContactDialog_UserID);
        this.accountText = new Text(parent, 2052);
        this.accountText.setLayoutData((Object)data);
        new Label(parent, 1).setText(Messages.AddContactDialog_Alias);
        this.aliasText = new Text(parent, 2052);
        this.aliasText.setLayoutData((Object)data);
        new Label(parent, 1).setText(Messages.AddContactDialog_Account);
        this.accountsViewer = new ComboViewer(parent, 2056);
        this.accountsViewer.getControl().setLayoutData((Object)data);
        this.accountsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.accountsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                MultiRosterAccount account = (MultiRosterAccount)element;
                return account.getContainer().getConnectedID().getName();
            }
        });
        this.accountsViewer.setInput(this.input);
        this.addListeners();
        return parent;
    }

    protected void okPressed() {
        this.accountID = this.accountText.getText();
        this.alias = this.accountText.getText();
        super.okPressed();
    }

    public IPresenceContainerAdapter getSelection() {
        return this.selection;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setInput(Object input) {
        this.input = input;
    }
}

