/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.ui.MultiRosterAccount;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChatRoomSelectionDialog
extends TitleAreaDialog {
    MultiRosterAccount[] accounts = null;
    private Room selectedRoom = null;

    public ChatRoomSelectionDialog(Shell parentShell, MultiRosterAccount[] accounts) {
        super(parentShell);
        this.accounts = accounts;
        this.setTitleImage(SharedImages.getImage((String)"IMG_CHAT_WIZARD"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = new TableViewer(main, 68352);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_ROOM_NAME_COLUMN);
        tc.pack();
        int width = tc.getWidth();
        tc.setWidth(width + width / 4);
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_SUBJECT_COLUMN);
        tc.pack();
        width = tc.getWidth();
        tc.setWidth(width + width / 4);
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_DESCRIPTION_COLUMN);
        tc.pack();
        width = tc.getWidth();
        tc.setWidth(width + width / 3);
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_MEMBERS_COLUMN);
        tc.pack();
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_MODERATED_COLUMN);
        tc.pack();
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_PERSISTENT_COLUMN);
        tc.pack();
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_ACCOUNT_COLUMN);
        tc.pack();
        width = tc.getWidth();
        tc.setWidth(width * 3);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ChatRoomSelectionDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        viewer.setContentProvider((IContentProvider)new ChatRoomContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ChatRoomLabelProvider());
        ArrayList<Room> all = new ArrayList<Room>();
        int i = 0;
        while (i < this.accounts.length) {
            IChatRoomInfo[] infos;
            IChatRoomManager chatRoomManager = this.accounts[i].getPresenceContainerAdapter().getChatRoomManager();
            if (chatRoomManager != null && (infos = chatRoomManager.getChatRoomInfos()) != null) {
                int j = 0;
                while (j < infos.length) {
                    if (infos[j] != null && this.accounts[i] != null) {
                        all.add(new Room(infos[j], this.accounts[i]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        viewer.setInput((Object)all.toArray());
        this.setTitle(Messages.ChatRoomSelectionDialog_TITLE);
        this.setMessage(Messages.ChatRoomSelectionDialog_MESSAGE);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection s = (IStructuredSelection)e.getSelection();
                Object o = s.getFirstElement();
                if (o instanceof Room) {
                    ChatRoomSelectionDialog.this.selectedRoom = (Room)o;
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ChatRoomSelectionDialog.this.selectedRoom != null) {
                    ChatRoomSelectionDialog.this.okPressed();
                }
            }
        });
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setText(Messages.ChatRoomSelectionDialog_ENTER_CHAT_BUTTON_TEXT);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    public Room getSelectedRoom() {
        return this.selectedRoom;
    }

    private class ChatRoomContentProvider
    implements IStructuredContentProvider {
        private ChatRoomContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ChatRoomLabelProvider
    implements ITableLabelProvider {
        private ChatRoomLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Room room = (Room)element;
            IChatRoomInfo info = room.getRoomInfo();
            switch (columnIndex) {
                case 0: {
                    return info.getName();
                }
                case 1: {
                    return info.getSubject();
                }
                case 2: {
                    return info.getDescription();
                }
                case 3: {
                    return String.valueOf(info.getParticipantsCount());
                }
                case 4: {
                    return String.valueOf(info.isModerated());
                }
                case 5: {
                    return String.valueOf(info.isPersistent());
                }
                case 6: {
                    return room.getAccount().getContainer().getConnectedID().getName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class Room {
        IChatRoomInfo info;
        MultiRosterAccount account;

        public Room(IChatRoomInfo info, MultiRosterAccount man) {
            this.info = info;
            this.account = man;
        }

        public IChatRoomInfo getRoomInfo() {
            return this.info;
        }

        public MultiRosterAccount getAccount() {
            return this.account;
        }
    }
}

