/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.bittorrent.ui;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class BitTorrentConnectWizardPage
extends WizardPage {
    private Text torrentText;
    private Text targetText;
    private Button browseTorrentBtn;
    private Button browseTargetBtn;
    private String torrentFile;

    BitTorrentConnectWizardPage() {
        super("");
        this.setTitle("BitTorrent File Sharing");
        this.setPageComplete(false);
    }

    BitTorrentConnectWizardPage(String torrentFile) {
        this();
        this.torrentFile = torrentFile;
    }

    private void addListeners() {
        this.torrentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String file = BitTorrentConnectWizardPage.this.torrentText.getText().trim();
                if (file.equals("")) {
                    BitTorrentConnectWizardPage.this.setErrorMessage("A torrent file must be entered.");
                } else {
                    File torrent = new File(file);
                    if (torrent.isDirectory()) {
                        BitTorrentConnectWizardPage.this.setErrorMessage("The path is mapped to a directory.");
                    } else if (!torrent.canRead()) {
                        BitTorrentConnectWizardPage.this.setErrorMessage("The file cannot be read.");
                    } else {
                        BitTorrentConnectWizardPage.this.setErrorMessage(null);
                    }
                }
            }
        });
        this.targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String target = BitTorrentConnectWizardPage.this.torrentText.getText().trim();
                if (target.equals("")) {
                    BitTorrentConnectWizardPage.this.setErrorMessage("A destination must be set.");
                } else {
                    BitTorrentConnectWizardPage.this.setErrorMessage(null);
                }
            }
        });
        this.browseTorrentBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String torrent;
                FileDialog dialog = new FileDialog(BitTorrentConnectWizardPage.this.browseTorrentBtn.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.torrent"});
                if (BitTorrentConnectWizardPage.this.torrentFile != null) {
                    int lastIndex = BitTorrentConnectWizardPage.this.torrentFile.lastIndexOf(47);
                    if (lastIndex == -1) {
                        lastIndex = BitTorrentConnectWizardPage.this.torrentFile.lastIndexOf(92);
                    }
                    if (lastIndex != -1) {
                        dialog.setFilterPath(BitTorrentConnectWizardPage.this.torrentFile.substring(0, lastIndex));
                    }
                }
                if ((torrent = dialog.open()) != null) {
                    BitTorrentConnectWizardPage.this.torrentText.setText(torrent);
                }
            }
        });
        this.browseTargetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(BitTorrentConnectWizardPage.this.browseTorrentBtn.getShell(), 4096);
                String target = dialog.open();
                if (target != null) {
                    BitTorrentConnectWizardPage.this.targetText.setText(target);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(4, 0x1000000, true, false);
        Label label = new Label(parent, 16384);
        label.setText("Torrent:");
        this.torrentText = new Text(parent, 2052);
        this.torrentText.setLayoutData((Object)data);
        this.browseTorrentBtn = new Button(parent, 8);
        this.browseTorrentBtn.setText("&Browse");
        label = new Label(parent, 16384);
        label.setText("Target Path:");
        this.targetText = new Text(parent, 2052);
        this.targetText.setLayoutData((Object)data);
        this.browseTargetBtn = new Button(parent, 8);
        this.browseTargetBtn.setText("B&rowse");
        if (this.torrentFile != null) {
            this.torrentText.setText(this.torrentFile);
            this.targetText.setFocus();
        }
        this.addListeners();
        this.setControl((Control)parent);
    }

    String getTorrentName() {
        return this.torrentText.getText();
    }

    String getTargetName() {
        return this.targetText.getText();
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

