/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.retrieve;

import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.InvalidFileRangeSpecificationException;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.retrieve.HttpHelper;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public class UrlConnectionRetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    private static final String USERNAME_PREFIX = Messages.UrlConnectionRetrieveFileTransfer_USERNAME_PROMPT;
    private static final int HTTP_RANGE_RESPONSE = 206;
    private static final int OK_RESPONSE_CODE = 200;
    private static final String JRE_CONNECT_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String DEFAULT_CONNECT_TIMEOUT = "30000";
    private static final String JRE_READ_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String DEFAULT_READ_TIMEOUT = "30000";
    protected URLConnection urlConnection;
    protected long lastModifiedTime = 0L;
    protected int httpVersion = 1;
    protected int responseCode = -1;
    private String remoteFileName;
    protected String responseMessage = null;
    private JREProxyHelper proxyHelper = new JREProxyHelper();
    protected String username = null;
    protected String password = null;
    static /* synthetic */ Class class$0;

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    protected void connect() throws IOException {
        this.setupTimeouts();
        this.urlConnection = this.getRemoteFileURL().openConnection();
    }

    protected boolean isConnected() {
        return this.urlConnection != null;
    }

    protected void setResumeRequestHeaderValues() throws IOException {
        if (this.bytesReceived <= 0L || this.fileLength <= this.bytesReceived) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_RESUME_START_ERROR);
        }
        this.setRangeHeader("bytes=" + this.bytesReceived + "-");
    }

    protected void setRequestHeaderValues() throws InvalidFileRangeSpecificationException {
        IFileRangeSpecification rangeSpec = this.getFileRangeSpecification();
        if (rangeSpec != null && this.isHTTP()) {
            long startPosition = rangeSpec.getStartPosition();
            long endPosition = rangeSpec.getEndPosition();
            if (startPosition < 0L) {
                throw new InvalidFileRangeSpecificationException(Messages.UrlConnectionRetrieveFileTransfer_RESUME_START_POSITION_LESS_THAN_ZERO, rangeSpec);
            }
            if (endPosition != -1L && endPosition <= startPosition) {
                throw new InvalidFileRangeSpecificationException(Messages.UrlConnectionRetrieveFileTransfer_RESUME_ERROR_END_POSITION_LESS_THAN_START, rangeSpec);
            }
            this.setRangeHeader("bytes=" + startPosition + "-" + (endPosition == -1L ? "" : "" + endPosition));
        }
    }

    private void setRangeHeader(String value) {
        this.urlConnection.setRequestProperty("Range", value);
    }

    public int getResponseCode() {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        if (this.isHTTP()) {
            int last;
            String response = this.urlConnection.getHeaderField(0);
            if (response == null) {
                this.responseCode = -1;
                this.httpVersion = 1;
                return this.responseCode;
            }
            if (!response.startsWith("HTTP/")) {
                return -1;
            }
            int mark = (response = response.trim()).indexOf(" ") + 1;
            if (mark == 0) {
                return -1;
            }
            if (response.charAt(mark - 2) != '1') {
                this.httpVersion = 0;
            }
            if ((last = mark + 3) > response.length()) {
                last = response.length();
            }
            this.responseCode = Integer.parseInt(response.substring(mark, last));
            if (last + 1 <= response.length()) {
                this.responseMessage = response.substring(last + 1);
            }
        } else {
            this.responseCode = 200;
            this.responseMessage = "OK";
        }
        return this.responseCode;
    }

    private boolean isHTTP() {
        String protocol = this.getRemoteFileURL().getProtocol();
        return protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https");
    }

    private boolean isHTTP11() {
        return this.isHTTP() && this.httpVersion >= 1;
    }

    protected void getResponseHeaderValues() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectException(Messages.UrlConnectionRetrieveFileTransfer_CONNECT_EXCEPTION_NOT_CONNECTED);
        }
        if (this.getResponseCode() == -1) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_INVALID_SERVER_RESPONSE);
        }
        this.lastModifiedTime = this.urlConnection.getLastModified();
        this.setFileLength(this.urlConnection.getContentLength());
        String contentDispositionValue = this.urlConnection.getHeaderField("Content-Disposition");
        if (contentDispositionValue != null) {
            this.remoteFileName = HttpHelper.getRemoteFileNameFromContentDispositionHeader(contentDispositionValue);
        }
        if (this.remoteFileName == null) {
            this.remoteFileName = super.getRemoteFileName();
        }
    }

    protected void getResumeResponseHeaderValues() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectException(Messages.UrlConnectionRetrieveFileTransfer_CONNECT_EXCEPTION_NOT_CONNECTED);
        }
        if (this.getResponseCode() != 206) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_INVALID_SERVER_RESPONSE_TO_PARTIAL_RANGE_REQUEST);
        }
        if (this.lastModifiedTime != this.urlConnection.getLastModified()) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_FILE_MODIFIED_SINCE_LAST_ACCESS);
        }
    }

    protected void setupProxy(Proxy proxy2) {
        this.proxyHelper.setupProxy(proxy2);
    }

    protected void setupAuthentication() throws IOException, UnsupportedCallbackException {
        if (this.connectContext == null) {
            return;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        Object o = passwordCallback.getObject();
        if (!(o instanceof String)) {
            throw new UnsupportedCallbackException((Callback)passwordCallback, Messages.UrlConnectionRetrieveFileTransfer_UnsupportedCallbackException);
        }
        this.password = (String)passwordCallback.getObject();
        Authenticator.setDefault(new UrlConnectionAuthenticator());
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        super.setConnectContextForAuthentication(connectContext);
        this.username = null;
        this.password = null;
    }

    protected void openStreams() throws IncomingFileTransferException {
        try {
            this.setupAuthentication();
            this.connect();
            this.setRequestHeaderValues();
            this.setInputStream(this.urlConnection.getInputStream());
            this.getResponseHeaderValues();
            this.fireReceiveStartEvent();
        }
        catch (Exception e) {
            throw new IncomingFileTransferException(NLS.bind((String)Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)this.getRemoteFileURL().toString()), (Throwable)e);
        }
    }

    protected void hardClose() {
        super.hardClose();
        this.urlConnection = null;
        this.responseCode = -1;
        if (this.proxyHelper != null) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }

    protected boolean doPause() {
        if (this.isPaused() || !this.isConnected() || this.isDone()) {
            return false;
        }
        this.paused = true;
        return this.paused;
    }

    protected boolean doResume() {
        if (!this.isPaused() || this.isConnected()) {
            return false;
        }
        return this.openStreamsForResume();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.IFileTransferPausable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz) && this.isHTTP11()) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private void setupTimeouts() {
        String existingTimeout = System.getProperty("sun.net.client.defaultConnectTimeout");
        if (existingTimeout == null) {
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        }
        if ((existingTimeout = System.getProperty("sun.net.client.defaultConnectTimeout")) == null) {
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        }
    }

    private boolean openStreamsForResume() {
        URL theURL = this.getRemoteFileURL();
        try {
            this.remoteFileURL = new URL(theURL.toString());
            this.setupAuthentication();
            this.connect();
            this.setResumeRequestHeaderValues();
            this.setInputStream(this.urlConnection.getInputStream());
            this.getResumeResponseHeaderValues();
            this.paused = false;
            this.fireReceiveResumedEvent();
            return true;
        }
        catch (Exception e) {
            this.exception = e;
            this.done = true;
            this.hardClose();
            this.fireTransferReceiveDoneEvent();
            return false;
        }
    }

    class UrlConnectionAuthenticator
    extends Authenticator {
        UrlConnectionAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(UrlConnectionRetrieveFileTransfer.this.username, UrlConnectionRetrieveFileTransfer.this.password.toCharArray());
        }
    }
}

