/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.msn.ui;

import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.provider.msn.ui.MSNConnectWizardPage;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageEvent;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.presence.ui.MultiRosterView;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.actions.AsynchContainerConnectAction;
import org.eclipse.ecf.ui.dialogs.IDCreateErrorDialog;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class MSNConnectWizard
extends Wizard
implements IConnectWizard {
    private IWorkbench workbench;
    private MSNConnectWizardPage page;
    private IContainer container;
    private IChatMessageSender icms;
    private ITypingMessageSender itms;
    private ID targetID;
    private IConnectContext connectContext;
    private String username;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MSNConnectWizard() {
    }

    public MSNConnectWizard(String username) {
        this();
        this.username = username;
    }

    public void addPages() {
        this.page = new MSNConnectWizardPage(this.username);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.workbench = workbench;
        this.container = container;
    }

    private void openView() {
        block6: {
            try {
                MultiRosterView view = (MultiRosterView)this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MultiRosterView");
                if (view == null) {
                    view = (MultiRosterView)this.workbench.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ecf.presence.ui.MultiRosterView", null, 3);
                }
                view.addContainer(this.container);
                IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
                if (page.isPartVisible((IWorkbenchPart)view)) break block6;
                IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                service.warnOfContentChange();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private void displayMessage(IChatMessageEvent e) {
        final IChatMessage message = e.getChatMessage();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessagesView view = (MessagesView)MSNConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MessagesView");
                if (view != null) {
                    IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                    view.openTab(MSNConnectWizard.this.icms, MSNConnectWizard.this.itms, MSNConnectWizard.this.targetID, message.getFromID());
                    view.showMessage(message);
                    service.warnOfContentChange();
                } else {
                    try {
                        IWorkbenchPage page = MSNConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage();
                        view = (MessagesView)page.showView("org.eclipse.ecf.presence.ui.MessagesView", null, 3);
                        if (!page.isPartVisible((IWorkbenchPart)view)) {
                            IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                            service.warnOfContentChange();
                        }
                        view.openTab(MSNConnectWizard.this.icms, MSNConnectWizard.this.itms, MSNConnectWizard.this.targetID, message.getFromID());
                        view.showMessage(message);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void displayTypingNotification(final ITypingMessageEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessagesView view = (MessagesView)MSNConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MessagesView");
                if (view != null) {
                    view.displayTypingNotification(e);
                }
            }
        });
    }

    public boolean performFinish() {
        final String connectID = this.page.getEmail();
        final String password = this.page.getPassword();
        this.page.saveComboText();
        this.connectContext = ConnectContextFactory.createPasswordConnectContext((String)password);
        try {
            this.targetID = this.container.getConnectNamespace().createInstance(new Object[]{connectID});
        }
        catch (IDCreateException e) {
            new IDCreateErrorDialog(null, connectID, e).open();
            return false;
        }
        this.page.saveComboItems();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPresenceContainerAdapter adapter = (IPresenceContainerAdapter)this.container.getAdapter((Class)clazz);
        this.container.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent event) {
                if (event instanceof IContainerConnectedEvent) {
                    Display.getDefault().asyncExec(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            MSNConnectWizard.access$4(3.access$0(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ MSNConnectWizard access$0(3 var0) {
                return var0.MSNConnectWizard.this;
            }
        });
        IChatManager icm = adapter.getChatManager();
        this.icms = icm.getChatMessageSender();
        this.itms = icm.getTypingMessageSender();
        icm.addMessageListener(new IIMMessageListener(){

            public void handleMessageEvent(IIMMessageEvent e) {
                if (e instanceof IChatMessageEvent) {
                    MSNConnectWizard.this.displayMessage((IChatMessageEvent)e);
                } else if (e instanceof ITypingMessageEvent) {
                    MSNConnectWizard.this.displayTypingNotification((ITypingMessageEvent)e);
                }
            }
        });
        new AsynchContainerConnectAction(this.container, this.targetID, this.connectContext, null, new Runnable(){

            public void run() {
                MSNConnectWizard.this.cachePassword(connectID, password);
            }
        }).run();
        return true;
    }

    private void cachePassword(String connectID, String password) {
        if (password != null && !password.equals("")) {
            PasswordCacheHelper pwStorage = new PasswordCacheHelper(connectID);
            pwStorage.savePassword(password);
        }
    }

    static /* synthetic */ void access$4(MSNConnectWizard mSNConnectWizard) {
        mSNConnectWizard.openView();
    }
}

