/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.internal.provider.xmpp.events.ChatMembershipEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.MessageEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.PresenceEvent;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.chatroom.ChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.ChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPRoomID;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;

public class XMPPChatRoomContainerHelper
implements ISharedObject {
    ISharedObjectConfig config = null;
    private final List messageListeners = new ArrayList();
    private Namespace usernamespace = null;
    private XMPPConnection connection = null;
    private final List participantListeners = new ArrayList();
    private ID roomID = null;
    private final List chatRoomContainerParticipants = Collections.synchronizedList(new ArrayList());
    protected Message.Type[] ALLOWED_MESSAGES = new Message.Type[]{Message.Type.GROUP_CHAT};

    protected void trace(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChatParticipantListener(IChatRoomParticipantListener listener) {
        List list = this.participantListeners;
        synchronized (list) {
            this.participantListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChatParticipantListener(IChatRoomParticipantListener listener) {
        List list = this.participantListeners;
        synchronized (list) {
            this.participantListeners.remove(listener);
        }
    }

    public XMPPChatRoomContainerHelper(Namespace usernamespace, XMPPConnection conn) {
        this.usernamespace = usernamespace;
        this.connection = conn;
    }

    protected ISharedObjectContext getContext() {
        return this.config.getContext();
    }

    public void init(ISharedObjectConfig initData) throws SharedObjectInitException {
        this.config = initData;
    }

    protected ID createUserIDFromName(String name) {
        XMPPID result = null;
        try {
            result = new XMPPID(this.usernamespace, name);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Message filterMessageType(Message msg) {
        int i = 0;
        while (i < this.ALLOWED_MESSAGES.length) {
            if (this.ALLOWED_MESSAGES[i].equals(msg.getType())) {
                return msg;
            }
            ++i;
        }
        return null;
    }

    protected String canonicalizeRoomFrom(String from) {
        if (from == null) {
            return null;
        }
        int atIndex = from.indexOf(64);
        String hostname = null;
        String username = null;
        int index = from.indexOf("/");
        if (atIndex > 0 && index > 0) {
            hostname = from.substring(atIndex + 1, index);
            username = from.substring(index + 1);
            return String.valueOf(username) + "@" + hostname;
        }
        return from;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageListeners(ID from, String body) {
        ArrayList toNotify = null;
        List list = this.messageListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.messageListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IIMMessageListener l = (IIMMessageListener)i.next();
            l.handleMessageEvent((IIMMessageEvent)new ChatRoomMessageEvent(from, (IChatRoomMessage)new ChatRoomMessage(from, this.roomID, body)));
        }
    }

    protected String canonicalizeRoomTo(String to) {
        if (to == null) {
            return null;
        }
        int index = to.indexOf("/");
        if (index > 0) {
            return to.substring(0, index);
        }
        return to;
    }

    protected ID createRoomIDFromName(String from) {
        try {
            return new XMPPRoomID(this.usernamespace, this.connection, from);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected void handleMessageEvent(MessageEvent evt) {
        Message msg = this.filterMessageType(evt.getMessage());
        if (msg != null) {
            this.fireMessageListeners(this.createUserIDFromName(this.canonicalizeRoomFrom(msg.getFrom())), msg.getBody());
        }
    }

    protected IPresence.Type createIPresenceType(Presence xmppPresence) {
        if (xmppPresence == null) {
            return IPresence.Type.AVAILABLE;
        }
        Presence.Type type = xmppPresence.getType();
        if (type == Presence.Type.AVAILABLE) {
            return IPresence.Type.AVAILABLE;
        }
        if (type == Presence.Type.ERROR) {
            return IPresence.Type.ERROR;
        }
        if (type == Presence.Type.SUBSCRIBE) {
            return IPresence.Type.SUBSCRIBE;
        }
        if (type == Presence.Type.SUBSCRIBED) {
            return IPresence.Type.SUBSCRIBED;
        }
        if (type == Presence.Type.UNSUBSCRIBE) {
            return IPresence.Type.UNSUBSCRIBE;
        }
        if (type == Presence.Type.UNSUBSCRIBED) {
            return IPresence.Type.UNSUBSCRIBED;
        }
        if (type == Presence.Type.UNAVAILABLE) {
            return IPresence.Type.UNAVAILABLE;
        }
        return IPresence.Type.AVAILABLE;
    }

    protected IPresence.Mode createIPresenceMode(Presence xmppPresence) {
        if (xmppPresence == null) {
            return IPresence.Mode.AVAILABLE;
        }
        Presence.Mode mode = xmppPresence.getMode();
        if (mode == Presence.Mode.AVAILABLE) {
            return IPresence.Mode.AVAILABLE;
        }
        if (mode == Presence.Mode.AWAY) {
            return IPresence.Mode.AWAY;
        }
        if (mode == Presence.Mode.CHAT) {
            return IPresence.Mode.CHAT;
        }
        if (mode == Presence.Mode.DO_NOT_DISTURB) {
            return IPresence.Mode.DND;
        }
        if (mode == Presence.Mode.EXTENDED_AWAY) {
            return IPresence.Mode.EXTENDED_AWAY;
        }
        if (mode == Presence.Mode.INVISIBLE) {
            return IPresence.Mode.INVISIBLE;
        }
        return IPresence.Mode.AVAILABLE;
    }

    protected IPresence createIPresence(Presence xmppPresence) {
        String status = xmppPresence.getStatus();
        org.eclipse.ecf.presence.Presence newPresence = new org.eclipse.ecf.presence.Presence(this.createIPresenceType(xmppPresence), status, this.createIPresenceMode(xmppPresence));
        return newPresence;
    }

    protected void disconnect() {
        this.chatRoomContainerParticipants.clear();
        this.setRoomID(null);
    }

    protected void handlePresenceEvent(PresenceEvent evt) {
        Presence xmppPresence = evt.getPresence();
        String from = this.canonicalizeRoomFrom(xmppPresence.getFrom());
        IPresence newPresence = this.createIPresence(xmppPresence);
        ID fromID = this.createUserIDFromName(from);
        if (newPresence.getType().equals((Object)IPresence.Type.AVAILABLE)) {
            if (!this.chatRoomContainerParticipants.contains(fromID)) {
                this.chatRoomContainerParticipants.add(fromID);
            }
        } else {
            this.chatRoomContainerParticipants.remove(fromID);
        }
        this.fireParticipant(fromID, newPresence);
    }

    protected void handleChatMembershipEvent(ChatMembershipEvent evt) {
        String from = this.canonicalizeRoomFrom(evt.getFrom());
        ID fromID = this.createUserIDFromName(from);
        this.fireChatParticipant(fromID, evt.isAdd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParticipant(ID fromID, IPresence presence) {
        ArrayList toNotify = null;
        List list = this.participantListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.participantListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IChatRoomParticipantListener l = (IChatRoomParticipantListener)i.next();
            l.handlePresenceUpdated(fromID, presence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChatParticipant(ID fromID, boolean join) {
        ArrayList toNotify = null;
        List list = this.participantListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.participantListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IChatRoomParticipantListener l = (IChatRoomParticipantListener)i.next();
            if (join) {
                l.handleArrived((IUser)new User(fromID));
                continue;
            }
            l.handleDeparted((IUser)new User(fromID));
        }
    }

    public void handleEvent(Event event) {
        this.trace("handleEvent(" + event + ")");
        if (event instanceof MessageEvent) {
            this.handleMessageEvent((MessageEvent)event);
        } else if (event instanceof PresenceEvent) {
            this.handlePresenceEvent((PresenceEvent)event);
        } else if (event instanceof ChatMembershipEvent) {
            this.handleChatMembershipEvent((ChatMembershipEvent)event);
        } else {
            this.trace("unrecognized event " + event);
        }
    }

    public void handleEvents(Event[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleEvent(events[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(ID containerID) {
        List list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.clear();
        }
        list = this.participantListeners;
        synchronized (list) {
            this.participantListeners.clear();
        }
        list = this.chatRoomContainerParticipants;
        synchronized (list) {
            this.chatRoomContainerParticipants.clear();
        }
        this.config = null;
        this.connection = null;
        this.usernamespace = null;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChatRoomMessageListener(IIMMessageListener msgListener) {
        List list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.add(msgListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatRoomMessageListener(IIMMessageListener msgListener) {
        List list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.remove(msgListener);
        }
    }

    protected void setRoomID(ID roomID) {
        this.roomID = roomID;
    }

    public ID[] getChatRoomParticipants() {
        return this.chatRoomContainerParticipants.toArray(new ID[0]);
    }
}

