/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.smack;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.ContainerAuthenticationException;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnectionObjectPacketEvent;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnectionPacketEvent;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IAsynchEventHandler;
import org.eclipse.ecf.provider.comm.IConnectionListener;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPRoomID;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class ECFConnection
implements ISynchAsynchConnection {
    private static final String GOOGLE_TALK_HOST = "talk.google.com";
    public static final String CLIENT_TYPE = "ECF_XMPP";
    public static final boolean DEBUG = Boolean.getBoolean(System.getProperty("smack.debug", "false"));
    protected static final String STRING_ENCODING = "UTF-8";
    public static final String OBJECT_PROPERTY_NAME;
    protected static final int XMPP_DEFAULT_PORT = 5222;
    protected static final int XMPPS_DEFAULT_PORT = 5223;
    private XMPPConnection connection = null;
    private IAsynchEventHandler handler = null;
    private boolean isStarted = false;
    private String serverName;
    private int serverPort = -1;
    private final Map properties = null;
    private boolean isConnected = false;
    private Namespace namespace = null;
    private boolean google = false;
    private boolean secure = false;
    private boolean disconnecting = false;
    private final PacketListener packetListener = new PacketListener(){

        public void processPacket(Packet arg0) {
            ECFConnection.this.handlePacket(arg0);
        }
    };
    private final ConnectionListener connectionListener = new ConnectionListener(){

        public void connectionClosed() {
            ECFConnection.this.handleConnectionClosed(null);
        }

        public void connectionClosedOnError(Exception e) {
            ECFConnection.this.handleConnectionClosed(e);
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OBJECT_PROPERTY_NAME = String.valueOf(clazz.getName()) + ".object";
    }

    protected void logException(String msg, Throwable t) {
        XmppPlugin.log(msg, t);
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public XMPPConnection getXMPPConnection() {
        return this.connection;
    }

    public ECFConnection(boolean google, Namespace ns, IAsynchEventHandler h, boolean secure) {
        this.handler = h;
        this.namespace = ns;
        this.google = google;
        this.secure = secure;
    }

    public ECFConnection(boolean google, Namespace ns, IAsynchEventHandler h) {
        this(google, ns, h, false);
    }

    protected String getPasswordForObject(Object data) {
        String password = null;
        try {
            password = (String)data;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return password;
    }

    private XMPPID getXMPPID(ID remote) throws ECFException {
        XMPPID jabberID = null;
        try {
            jabberID = (XMPPID)remote;
        }
        catch (ClassCastException e) {
            throw new ECFException((Throwable)e);
        }
        return jabberID;
    }

    public synchronized Object connect(ID remote, Object data, int timeout) throws ECFException {
        if (this.connection != null) {
            throw new ECFException("already connected");
        }
        if (timeout > 0) {
            SmackConfiguration.setPacketReplyTimeout((int)timeout);
        }
        Roster.setDefaultSubscriptionMode((int)2);
        XMPPID jabberURI = this.getXMPPID(remote);
        String username = jabberURI.getUsername();
        this.serverName = jabberURI.getHostname();
        this.serverPort = jabberURI.getPort();
        try {
            this.connection = this.google ? (this.secure ? new SSLXMPPConnection(GOOGLE_TALK_HOST, 5223, jabberURI.getHostname()) : new XMPPConnection(GOOGLE_TALK_HOST, 5222, jabberURI.getHostname())) : (this.serverPort == -1 ? (this.secure ? new SSLXMPPConnection(this.serverName) : new XMPPConnection(this.serverName)) : (this.secure ? new SSLXMPPConnection(this.serverName, this.serverPort) : new XMPPConnection(this.serverName, this.serverPort)));
            this.connection.addPacketListener(this.packetListener, null);
            this.connection.addConnectionListener(this.connectionListener);
            this.connection.login(username, (String)data, CLIENT_TYPE);
            this.isConnected = true;
        }
        catch (XMPPException e) {
            if (e.getMessage().equals("(401)")) {
                throw new ContainerAuthenticationException("Password incorrect", (Throwable)e);
            }
            throw new ContainerConnectException(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public void sendPacket(Packet packet) throws XMPPException {
        if (this.connection != null) {
            this.connection.sendPacket(packet);
        }
    }

    public synchronized void disconnect() {
        this.disconnecting = true;
        if (this.isStarted()) {
            this.stop();
        }
        if (this.connection != null) {
            this.connection.removePacketListener(this.packetListener);
            this.connection.removeConnectionListener(this.connectionListener);
            this.connection.close();
            this.isConnected = false;
            this.connection = null;
        }
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public synchronized ID getLocalID() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return IDFactory.getDefault().createID(this.namespace.getName(), new Object[]{this.connection.getConnectionID()});
        }
        catch (Exception e) {
            this.logException("Exception in getLocalID", e);
            return null;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public synchronized void stop() {
        this.isStarted = false;
    }

    protected void handleConnectionClosed(Exception e) {
        if (!this.disconnecting) {
            this.disconnecting = true;
            this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, (Throwable)e, null));
        }
    }

    protected void handlePacket(Packet arg0) {
        try {
            Object val = arg0.getProperty(OBJECT_PROPERTY_NAME);
            if (val != null) {
                this.handler.handleAsynchEvent((AsynchEvent)new ECFConnectionObjectPacketEvent((IAsynchConnection)this, arg0, val));
            } else {
                this.handler.handleAsynchEvent((AsynchEvent)new ECFConnectionPacketEvent((IAsynchConnection)this, arg0));
            }
        }
        catch (IOException e) {
            this.logException("Exception in handleAsynchEvent", e);
            try {
                this.disconnect();
            }
            catch (Exception e1) {
                this.logException("Exception in disconnect()", e1);
            }
        }
    }

    public synchronized void sendAsynch(ID receiver, byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("no data");
        }
        Message aMsg = new Message();
        aMsg.setProperty(OBJECT_PROPERTY_NAME, (Object)data);
        this.sendMessage(receiver, aMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ID receiver, Message aMsg) throws IOException {
        ECFConnection eCFConnection = this;
        synchronized (eCFConnection) {
            block9: {
                if (!this.isConnected()) {
                    throw new IOException("not connected");
                }
                try {
                    if (receiver == null) {
                        throw new IOException("receiver cannot be null for xmpp instant messaging");
                    }
                    if (receiver instanceof XMPPID) {
                        XMPPID rcvr = (XMPPID)receiver;
                        aMsg.setType(Message.Type.CHAT);
                        String userAtHost = rcvr.getUsernameAtHost();
                        Chat localChat = this.connection.createChat(userAtHost);
                        localChat.sendMessage(aMsg);
                        break block9;
                    }
                    if (receiver instanceof XMPPRoomID) {
                        XMPPRoomID roomID = (XMPPRoomID)receiver;
                        aMsg.setType(Message.Type.GROUP_CHAT);
                        String to = roomID.getMucString();
                        aMsg.setTo(to);
                        this.connection.sendPacket((Packet)aMsg);
                        break block9;
                    }
                    throw new IOException("receiver must be of type XMPPID or XMPPRoomID");
                }
                catch (XMPPException e) {
                    IOException result = new IOException("XMPPException in sendMessage: " + e.getMessage());
                    result.setStackTrace(e.getStackTrace());
                    throw result;
                }
            }
        }
    }

    public synchronized Object sendSynch(ID receiver, byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("data cannot be null");
        }
        return null;
    }

    public void addListener(IConnectionListener listener) {
    }

    public void removeListener(IConnectionListener listener) {
    }

    public void sendMessage(ID target, String message) throws IOException {
        if (target == null) {
            throw new IOException("target cannot be null");
        }
        if (message == null) {
            throw new IOException("message cannot be null");
        }
        Message aMsg = new Message();
        aMsg.setBody(message);
        this.sendMessage(target, aMsg);
    }

    public static Map getPropertiesFromPacket(Packet packet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator i = packet.getPropertyNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            result.put(name, packet.getProperty(name));
        }
        return result;
    }

    public static Packet setPropertiesInPacket(Packet input, Map properties) {
        if (properties != null) {
            Iterator i = properties.keySet().iterator();
            while (i.hasNext()) {
                String key;
                Object keyo = i.next();
                Object val = properties.get(keyo);
                String string = key = keyo instanceof String ? (String)keyo : keyo.toString();
                if (val instanceof Boolean) {
                    input.setProperty(key, ((Boolean)val).booleanValue());
                    continue;
                }
                if (val instanceof Double) {
                    input.setProperty(key, ((Double)val).doubleValue());
                    continue;
                }
                if (val instanceof Float) {
                    input.setProperty(key, ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Integer) {
                    input.setProperty(key, ((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Long) {
                    input.setProperty(key, ((Long)val).floatValue());
                    continue;
                }
                if (!(val instanceof Object)) continue;
                input.setProperty(key, val);
            }
        }
        return input;
    }

    public void sendMessage(ID target, ID thread, Message.Type type, String subject, String body, Map properties2) throws IOException {
        if (target == null) {
            throw new IOException("XMPP target for message cannot be null");
        }
        if (body == null) {
            body = "";
        }
        Message aMsg = new Message();
        aMsg.setBody(body);
        if (thread != null) {
            aMsg.setThread(thread.getName());
        }
        if (type != null) {
            aMsg.setType(type);
        }
        if (subject != null) {
            aMsg.setSubject(subject);
        }
        ECFConnection.setPropertiesInPacket((Packet)aMsg, properties2);
        this.sendMessage(target, aMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPresenceUpdate(ID target, Presence presence) throws IOException {
        if (presence == null) {
            throw new IOException("presence cannot be null");
        }
        presence.setFrom(this.connection.getUser());
        if (target != null) {
            presence.setTo(target.getName());
        }
        ECFConnection eCFConnection = this;
        synchronized (eCFConnection) {
            if (!this.isConnected()) {
                throw new IOException("not connected");
            }
            this.connection.sendPacket((Packet)presence);
        }
    }

    public void sendRosterAdd(String user, String name, String[] groups) throws IOException, XMPPException {
        Roster r = this.getRoster();
        r.createEntry(user, name, groups);
    }

    public void sendRosterRemove(String user) throws XMPPException, IOException {
        Roster r = this.getRoster();
        RosterEntry re = r.getEntry(user);
        r.removeEntry(re);
    }

    public Roster getRoster() throws IOException {
        if (this.connection == null || !this.connection.isConnected()) {
            return null;
        }
        return this.connection.getRoster();
    }
}

