/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConnector;
import org.eclipse.ecf.core.sharedobject.ISharedObjectManager;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.core.sharedobject.SharedObjectConnectException;
import org.eclipse.ecf.core.sharedobject.SharedObjectCreateException;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectDisconnectException;
import org.eclipse.ecf.core.sharedobject.SharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectManagerAddEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectManagerConnectEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectManagerCreateEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectManagerDisconnectEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectManagerRemoveEvent;
import org.eclipse.ecf.core.sharedobject.security.ISharedObjectPolicy;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.QueueEnqueueImpl;
import org.eclipse.ecf.core.util.AbstractFactory;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.Messages;
import org.eclipse.ecf.provider.generic.SOConnector;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOWrapper;

public class SOManager
implements ISharedObjectManager {
    private static final int GUID_SIZE = 20;
    SOContainer container = null;
    Vector connectors = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SOManager(SOContainer cont) {
        this.container = cont;
        this.connectors = new Vector();
    }

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug", (String)(String.valueOf(msg) + ":" + this.container.getID()));
    }

    protected void traceStack(String msg, Throwable e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.SOManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", clazz, (String)(this.container.getID() + ":" + msg), (Throwable)e);
    }

    protected void addConnector(ISharedObjectConnector conn) {
        this.connectors.add(conn);
    }

    protected boolean removeConnector(ISharedObjectConnector conn) {
        return this.connectors.remove(conn);
    }

    protected List getConnectors() {
        return this.connectors;
    }

    protected Class[] getArgTypes(String[] argTypes, Object[] args, ClassLoader cl) throws ClassNotFoundException {
        return AbstractFactory.getClassesForTypes((String[])argTypes, (Object[])args, (ClassLoader)cl);
    }

    protected ISharedObject createSharedObjectInstance(final Class newClass, final Class[] argTypes, final Object[] args) throws Exception {
        Object newObject = null;
        try {
            newObject = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor aConstructor = newClass.getConstructor(argTypes);
                    aConstructor.setAccessible(true);
                    return aConstructor.newInstance(args);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return this.verifySharedObject(newObject);
    }

    protected ISharedObject verifySharedObject(Object newSharedObject) {
        if (newSharedObject instanceof ISharedObject) {
            return (ISharedObject)newSharedObject;
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(Messages.SOManager_Object)).append(newSharedObject.toString()).append(Messages.SOManager_Does_Not_Implement);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.core.sharedobject.ISharedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        throw new ClassCastException(stringBuffer.append(clazz.getName()).toString());
    }

    protected ISharedObject loadSharedObject(SharedObjectDescription sd) throws Exception {
        Assert.isNotNull((Object)sd, (String)Messages.SOManager_Exception_Shared_Object_Description_Not_Null);
        Object[] args = this.container.getArgsFromProperties(sd);
        String[] types = this.container.getArgTypesFromProperties(sd);
        ISharedObject res = null;
        SharedObjectTypeDescription typeDesc = sd.getTypeDescription();
        String descName = typeDesc.getName();
        if (descName == null) {
            ClassLoader cl = this.container.getClassLoaderForSharedObject(sd);
            Class<?> newClass = Class.forName(typeDesc.getClassName(), true, cl);
            Class[] argTypes = this.getArgTypes(types, args, cl);
            res = this.createSharedObjectInstance(newClass, argTypes, args);
        } else {
            res = SharedObjectFactory.getDefault().createSharedObject(typeDesc, args);
        }
        return res;
    }

    public ID[] getSharedObjectIDs() {
        return this.container.getSharedObjectIDs();
    }

    public ID createSharedObject(SharedObjectDescription sd) throws SharedObjectCreateException {
        this.debug("createSharedObject(" + sd + ")");
        if (sd == null) {
            throw new SharedObjectCreateException(Messages.SOManager_Exception_Shared_Object_Description_Not_Null);
        }
        ISharedObject newObject = null;
        ID result = null;
        try {
            newObject = this.loadSharedObject(sd);
            ID newID = this.createNewSharedObjectID(sd, newObject);
            this.container.fireDelegateContainerEvent((IContainerEvent)new SharedObjectManagerCreateEvent(this.container.getID(), newID));
            result = this.addSharedObject(newID, newObject, sd.getProperties());
        }
        catch (Exception e) {
            this.traceStack("Exception in createSharedObject", e);
            SharedObjectCreateException newExcept = new SharedObjectCreateException(String.valueOf(Messages.SOManager_Container) + this.container.getID() + Messages.SOManager_Exception_Creating_Shared_Object + sd.getID() + ": " + e.getClass().getName() + ": " + e.getMessage());
            newExcept.setStackTrace(e.getStackTrace());
            throw newExcept;
        }
        return result;
    }

    protected ID createNewSharedObjectID(SharedObjectDescription sd, ISharedObject newObject) throws IDCreateException {
        ID descID = sd.getID();
        if (descID == null) {
            return IDFactory.getDefault().createGUID(20);
        }
        return descID;
    }

    public ID addSharedObject(ID sharedObjectID, ISharedObject sharedObject, Map properties) throws SharedObjectAddException {
        this.debug("addSharedObject(" + sharedObjectID + "," + sharedObject + "," + properties + ")");
        this.container.fireDelegateContainerEvent((IContainerEvent)new SharedObjectManagerAddEvent(this.container.getID(), sharedObjectID));
        ID result = sharedObjectID;
        try {
            ISharedObject so = sharedObject;
            this.container.addSharedObjectAndWait(sharedObjectID, so, properties);
        }
        catch (Exception e) {
            this.traceStack("Exception in addSharedObject", e);
            SharedObjectAddException newExcept = new SharedObjectAddException(String.valueOf(Messages.SOManager_Container) + this.container.getID() + Messages.SOManager_Exception_Adding_Shared_Object + sharedObjectID + ": " + e.getClass().getName() + ": " + e.getMessage());
            newExcept.setStackTrace(e.getStackTrace());
            throw newExcept;
        }
        return result;
    }

    public ISharedObject getSharedObject(ID sharedObjectID) {
        return this.container.getSharedObject(sharedObjectID);
    }

    public ISharedObject removeSharedObject(ID sharedObjectID) {
        this.debug("removeSharedObject(" + sharedObjectID + ")");
        this.container.fireDelegateContainerEvent((IContainerEvent)new SharedObjectManagerRemoveEvent(this.container.getID(), sharedObjectID));
        return this.container.removeSharedObject(sharedObjectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISharedObjectConnector connectSharedObjects(ID sharedObjectFrom, ID[] sharedObjectsTo) throws SharedObjectConnectException {
        this.debug("connectSharedObjects(" + sharedObjectFrom + "," + sharedObjectsTo + ")");
        if (sharedObjectFrom == null) {
            throw new SharedObjectConnectException(Messages.SOManager_Exception_Sender_Not_Null);
        }
        if (sharedObjectsTo == null) {
            throw new SharedObjectConnectException(Messages.SOManager_Exception_Receivers_Not_Null);
        }
        SOConnector result = null;
        Object object = this.container.getGroupMembershipLock();
        synchronized (object) {
            SOWrapper wrap = this.container.getSharedObjectWrapper(sharedObjectFrom);
            if (wrap == null) {
                throw new SharedObjectConnectException(String.valueOf(Messages.SOManager_Sender_Object) + sharedObjectFrom.getName() + Messages.SOManager_Not_Found);
            }
            IQueueEnqueue[] queues = new IQueueEnqueue[sharedObjectsTo.length];
            int i = 0;
            while (i < sharedObjectsTo.length) {
                SOWrapper w = this.container.getSharedObjectWrapper(sharedObjectsTo[i]);
                if (w == null) {
                    throw new SharedObjectConnectException(String.valueOf(Messages.SOManager_Receiver_Object) + sharedObjectsTo[i].getName() + Messages.SOManager_Not_Found);
                }
                queues[i] = new QueueEnqueueImpl(w.getQueue());
                ++i;
            }
            result = new SOConnector(sharedObjectFrom, sharedObjectsTo, queues);
            this.addConnector(result);
            this.container.fireDelegateContainerEvent((IContainerEvent)new SharedObjectManagerConnectEvent(this.container.getID(), (ISharedObjectConnector)result));
        }
        return result;
    }

    public void disconnectSharedObjects(ISharedObjectConnector connector) throws SharedObjectDisconnectException {
        if (connector == null) {
            throw new SharedObjectDisconnectException(Messages.SOManager_Exception_Connector_Not_Null);
        }
        this.debug("disconnectSharedObjects(" + connector.getSenderID() + ")");
        if (!this.removeConnector(connector)) {
            throw new SharedObjectDisconnectException(String.valueOf(Messages.SOManager_Connector) + connector + Messages.SOManager_Not_Found);
        }
        connector.dispose();
        this.container.fireDelegateContainerEvent((IContainerEvent)new SharedObjectManagerDisconnectEvent(this.container.getID(), connector));
    }

    protected void dispose() {
        this.debug("dispose()");
        Enumeration e = this.connectors.elements();
        while (e.hasMoreElements()) {
            ISharedObjectConnector conn = (ISharedObjectConnector)e.nextElement();
            conn.dispose();
        }
        this.connectors.clear();
    }

    public List getSharedObjectConnectors(ID sharedObjectFrom) {
        this.debug("getSharedObjectConnectors(" + sharedObjectFrom + ")");
        ArrayList<ISharedObjectConnector> results = new ArrayList<ISharedObjectConnector>();
        Enumeration e = this.connectors.elements();
        while (e.hasMoreElements()) {
            ISharedObjectConnector conn = (ISharedObjectConnector)e.nextElement();
            if (!sharedObjectFrom.equals((Object)conn.getSenderID())) continue;
            results.add(conn);
        }
        return results;
    }

    public static Class[] getClassesForTypes(String[] argTypes, Object[] args, ClassLoader cl) throws ClassNotFoundException {
        Class[] clazzes = null;
        if (args == null || args.length == 0) {
            clazzes = new Class[]{};
        } else if (argTypes != null) {
            clazzes = new Class[argTypes.length];
            int i = 0;
            while (i < argTypes.length) {
                clazzes[i] = Class.forName(argTypes[i], true, cl);
                ++i;
            }
        } else {
            clazzes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                clazzes[i] = args[i] == null ? null : args[i].getClass();
                ++i;
            }
        }
        return clazzes;
    }

    public void setRemoteAddPolicy(ISharedObjectPolicy policy) {
        this.container.setRemoteAddPolicy(policy);
    }
}

