/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatLine;
import org.eclipse.ecf.internal.ui.deprecated.views.IChatRoomViewCloseListener;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ChatRoomManagerView
extends ViewPart
implements IChatRoomInvitationListener {
    public static final String VIEW_ID = "org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView";
    private static final String COMMAND_PREFIX = "/";
    private static final String COMMAND_DELIM = " ";
    private static final String USERNAME_HOST_DELIMETER = "@";
    private static final int RATIO_WRITE_PANE = 1;
    private static final int RATIO_READ_PANE = 7;
    private static final int RATIO_READ_WRITE_PANE = 85;
    private static final int RATIO_PRESENCE_PANE = 15;
    protected static final String DEFAULT_ME_COLOR = "0,255,0";
    protected static final String DEFAULT_OTHER_COLOR = "0,0,0";
    protected static final String DEFAULT_SYSTEM_COLOR = "0,0,255";
    protected static final String DEFAULT_HIGHLIGHT_COLOR = "255,0,0";
    protected static final String DEFAULT_DATE_COLOR = "0,0,0";
    protected static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    protected static final int DEFAULT_INPUT_HEIGHT = 25;
    protected static final int DEFAULT_INPUT_SEPARATOR = 5;
    private CTabFolder rootTabFolder = null;
    private ChatRoomTab rootChannelTab = null;
    private IChatRoomViewCloseListener rootCloseListener = null;
    private IChatRoomMessageSender rootMessageSender = null;
    private IChatRoomManager rootChatRoomManager = null;
    private Color otherColor = null;
    private Color systemColor = null;
    private Color dateColor = null;
    private Color highlightColor = null;
    Action outputClear = null;
    Action outputCopy = null;
    Action outputPaste = null;
    Action outputSelectAll = null;
    boolean rootDisposed = false;
    private ID rootTargetID;
    private String userName = "<user>";
    private String hostName = "<host>";
    private boolean rootEnabled = false;
    private Hashtable chatRooms = new Hashtable();
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        this.otherColor = this.colorFromRGBString("0,0,0");
        this.systemColor = this.colorFromRGBString(DEFAULT_SYSTEM_COLOR);
        this.highlightColor = this.colorFromRGBString(DEFAULT_HIGHLIGHT_COLOR);
        this.dateColor = this.colorFromRGBString("0,0,0");
        Composite rootComposite = new Composite(parent, 0);
        rootComposite.setLayout((Layout)new FillLayout());
        boolean useTraditionalTabFolder = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        this.rootTabFolder = new CTabFolder(rootComposite, 64);
        this.rootTabFolder.setUnselectedCloseVisible(false);
        this.rootTabFolder.setSimple(useTraditionalTabFolder);
        PlatformUI.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("SHOW_TRADITIONAL_STYLE_TABS") && !ChatRoomManagerView.this.rootTabFolder.isDisposed()) {
                    ChatRoomManagerView.this.rootTabFolder.setSimple(((Boolean)event.getNewValue()).booleanValue());
                    ChatRoomManagerView.this.rootTabFolder.redraw();
                }
            }
        });
        this.rootTabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void close(CTabFolderEvent event) {
                event.doit = ChatRoomManagerView.this.closeTabItem((CTabItem)event.item);
            }

            public void maximize(CTabFolderEvent event) {
            }

            public void minimize(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
            }

            public void showList(CTabFolderEvent event) {
            }
        });
        this.rootChannelTab = new ChatRoomTab(false, this.rootTabFolder, this.hostName, new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                ChatRoomManagerView.this.handleKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                ChatRoomManagerView.this.handleKeyReleased(evt);
            }
        });
        this.setEnabled(false);
        this.makeActions();
        this.hookContextMenu();
    }

    private boolean closeTabItem(CTabItem tabItem) {
        ChatRoom chatRoom = this.findChatRoomForTabItem(tabItem);
        if (chatRoom == null) {
            return false;
        }
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Close Chat Room", (String)NLS.bind((String)"Close {0}?", (Object)tabItem.getText()))) {
            chatRoom.disconnect();
            return true;
        }
        return false;
    }

    private ChatRoom findChatRoomForTabItem(CTabItem tabItem) {
        Iterator i = this.chatRooms.values().iterator();
        while (i.hasNext()) {
            ChatRoom cr = (ChatRoom)i.next();
            if (tabItem != cr.chatRoomTab.tabItem) continue;
            return cr;
        }
        return null;
    }

    private Text getRootTextInput() {
        return this.rootChannelTab.getInputText();
    }

    private StyledText getRootTextOutput() {
        return this.rootChannelTab.getOutputText();
    }

    public void initialize(IChatRoomViewCloseListener parent, IChatRoomContainer chatRoomContainer, IChatRoomManager chatRoomManager, ID targetID) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)chatRoomContainer);
        Assert.isNotNull((Object)chatRoomManager);
        Assert.isNotNull((Object)targetID);
        this.rootChatRoomManager = chatRoomManager;
        this.rootCloseListener = parent;
        this.rootTargetID = targetID;
        this.rootMessageSender = chatRoomContainer.getChatRoomMessageSender();
        this.setUsernameAndHost(this.rootTargetID);
        this.setPartName(String.valueOf(this.userName) + USERNAME_HOST_DELIMETER + this.hostName);
        this.setTitleToolTip("Host: " + this.hostName);
        this.rootChannelTab.tabItem.setText(this.hostName);
        if (chatRoomContainer.getConnectedID() == null) {
            this.initializeControls(targetID);
        }
        this.setEnabled(false);
    }

    private void initializeControls(ID targetID) {
        StyledText outputText = this.getRootTextOutput();
        if (!outputText.isDisposed()) {
            outputText.setText(String.valueOf(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new Date())) + "\nConnecting to " + targetID.getName() + "\n\n");
        }
    }

    public void setEnabled(boolean enabled) {
        this.rootEnabled = enabled;
        Text inputText = this.getRootTextInput();
        if (!inputText.isDisposed()) {
            inputText.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.rootEnabled;
    }

    protected void clearInput() {
        this.getRootTextInput().setText("");
    }

    protected void handleCommands(String line, String[] tokens) {
        String command = tokens[0];
        while (command.startsWith(COMMAND_PREFIX)) {
            command = command.substring(1);
        }
        String[] args = new String[tokens.length - 1];
        System.arraycopy(tokens, 1, args, 0, tokens.length - 1);
        if (command.equalsIgnoreCase("QUIT")) {
            this.cleanUp();
        } else if (command.equalsIgnoreCase("JOIN")) {
            String arg1 = args[0];
            String arg2 = "";
            if (args.length > 1) {
                arg2 = args[1];
            }
            this.doJoinRoom(arg1, arg2);
        } else {
            this.sendMessageLine(line);
        }
    }

    protected void sendMessageLine(String line) {
        try {
            this.rootMessageSender.sendMessage(line);
        }
        catch (ECFException eCFException) {
            this.removeLocalUser();
        }
    }

    public void disconnected() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ChatRoomManagerView.this.rootDisposed) {
                    return;
                }
                ChatRoomManagerView.this.setEnabled(false);
                ChatRoomManagerView.this.setPartName("(" + ChatRoomManagerView.this.getPartName() + ")");
            }
        });
    }

    protected CTabItem getTabItem(String targetName) {
        CTabItem[] items = this.rootTabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(targetName)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    protected void doJoinRoom(final String target, final String key) {
        ChatRoom room = (ChatRoom)this.chatRooms.get(target);
        if (room != null && room.isConnected()) {
            room.setSelected();
            return;
        }
        IChatRoomInfo roomInfo = this.rootChatRoomManager.getChatRoomInfo(target);
        if (roomInfo == null) {
            return;
        }
        try {
            final IChatRoomContainer chatRoomContainer = roomInfo.createChatRoomContainer();
            final ChatRoom chatroom = new ChatRoom(chatRoomContainer, new ChatRoomTab(this.rootTabFolder, target));
            chatRoomContainer.addMessageListener(new IIMMessageListener(){

                public void handleMessageEvent(IIMMessageEvent messageEvent) {
                    if (messageEvent instanceof IChatRoomMessageEvent) {
                        IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
                        chatroom.handleMessage(m.getFromID(), m.getMessage());
                    }
                }
            });
            chatRoomContainer.addChatRoomParticipantListener(new IChatRoomParticipantListener(){

                public void handlePresenceUpdated(ID fromID, IPresence presence) {
                    chatroom.handlePresence(fromID, presence);
                }

                public void handleArrived(IUser participant) {
                }

                public void handleUpdated(IUser updatedParticipant) {
                }

                public void handleDeparted(IUser participant) {
                }
            });
            chatRoomContainer.addListener(new IContainerListener(){

                public void handleEvent(IContainerEvent evt) {
                    if (evt instanceof IContainerDisconnectedEvent) {
                        chatroom.disconnected();
                    }
                }
            });
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        chatRoomContainer.connect(IDFactory.getDefault().createID(chatRoomContainer.getConnectNamespace(), target), ConnectContextFactory.createPasswordConnectContext((String)key));
                        ChatRoomManagerView.this.chatRooms.put(target, chatroom);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)ChatRoomManagerView.this.getSite().getShell(), (String)"Connect Error", (String)NLS.bind((String)"Could connect to {0}.\n\nError is {1}.", (Object)target, (Object)e.getLocalizedMessage()));
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Container Create Error", (String)NLS.bind((String)"Could not create chatRoomContainer for {0}.\n\nError is {1}.", (Object)target, (Object)e.getLocalizedMessage()));
        }
    }

    protected void handleInputLine(String line) {
        if (line != null && line.startsWith(COMMAND_PREFIX)) {
            StringTokenizer st = new StringTokenizer(line, COMMAND_DELIM);
            int countTokens = st.countTokens();
            String[] toks = new String[countTokens];
            int i = 0;
            while (i < countTokens) {
                toks[i] = st.nextToken();
                ++i;
            }
            String[] tokens = toks;
            this.handleCommands(line, tokens);
        } else {
            this.sendMessageLine(line);
        }
    }

    protected void handleTextInput(String text) {
        if (this.rootMessageSender == null) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Not connect", (String)"Not connected to chat room");
            return;
        }
        this.handleInputLine(text);
    }

    protected void handleEnter() {
        Text inputText = this.getRootTextInput();
        if (inputText.getText().trim().length() > 0) {
            this.handleTextInput(inputText.getText());
        }
        this.clearInput();
    }

    protected void handleKeyPressed(KeyEvent evt) {
        if (evt.character == '\r') {
            this.handleEnter();
            evt.doit = false;
        }
    }

    protected void handleKeyReleased(KeyEvent evt) {
    }

    public void setFocus() {
        this.getRootTextInput().setFocus();
    }

    protected void setUsernameAndHost(ID chatHostID) {
        URI uri = null;
        try {
            uri = new URI(chatHostID.getName());
            String tmp = uri.getUserInfo();
            if (tmp != null) {
                this.userName = tmp;
            }
            if ((tmp = uri.getHost()) != null) {
                this.hostName = tmp;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    public void joinRoom(final String room) {
        if (room != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (ChatRoomManagerView.this.rootDisposed) {
                        return;
                    }
                    ChatRoomManagerView.this.doJoinRoom(room, null);
                }
            });
        }
    }

    public void dispose() {
        this.rootDisposed = true;
        this.cleanUp();
        super.dispose();
    }

    protected String getMessageString(ID fromID, String text) {
        return String.valueOf(fromID.getName()) + ": " + text + "\n";
    }

    public void handleMessage(final ID fromID, final String messageBody) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ChatRoomManagerView.this.rootDisposed) {
                    return;
                }
                ChatRoomManagerView.this.appendText(ChatRoomManagerView.this.getRootTextOutput(), new ChatLine(messageBody, new ChatRoomParticipant(fromID)));
            }
        });
    }

    private String trimUserID(ID userID) {
        try {
            URI uri = new URI(userID.getName());
            String user = uri.getUserInfo();
            return user == null ? userID.getName() : user;
        }
        catch (URISyntaxException uRISyntaxException) {
            String userAtHost = userID.getName();
            int atIndex = userAtHost.lastIndexOf(USERNAME_HOST_DELIMETER);
            if (atIndex != -1) {
                userAtHost = userAtHost.substring(0, atIndex);
            }
            return userAtHost;
        }
    }

    protected String getCurrentDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String res = sdf.format(new Date());
        return res;
    }

    protected String getDateTime() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getCurrentDate(DEFAULT_DATE_FORMAT)).append(COMMAND_DELIM).append(this.getCurrentDate(DEFAULT_TIME_FORMAT));
        return buf.toString();
    }

    protected void cleanUp() {
        if (this.rootCloseListener != null) {
            if (this.rootTargetID == null) {
                this.rootCloseListener.chatRoomViewClosing(null);
            } else {
                this.rootCloseListener.chatRoomViewClosing(this.rootTargetID.getName());
            }
            this.rootCloseListener = null;
            this.rootMessageSender = null;
        }
    }

    protected void removeLocalUser() {
        String title = this.getPartName();
        this.setPartName("(" + title + ")");
        this.cleanUp();
        this.setEnabled(false);
    }

    public void handleInvitationReceived(ID roomID, ID from, String subject, String body) {
        System.out.println("invitation room=" + roomID + ",from=" + from + ",subject=" + subject + ",body=" + body);
    }

    private boolean intelligentAppend(StyledText st, ChatLine text) {
        String t;
        StyleRange sr;
        boolean nickContained;
        String line = text.getText();
        int startRange = st.getText().length();
        StringBuffer sb = new StringBuffer();
        boolean bl = nickContained = text.getText().indexOf(this.userName) != -1;
        if (text.getOriginator() != null) {
            nickContained = !text.getOriginator().getName().equals(this.userName) && nickContained;
            sb.append('(').append(this.getCurrentDate(DEFAULT_TIME_FORMAT)).append(") ");
            StyleRange dateStyle = new StyleRange();
            dateStyle.start = startRange;
            dateStyle.length = sb.length();
            dateStyle.foreground = this.dateColor;
            dateStyle.fontStyle = 0;
            st.append(sb.toString());
            st.setStyleRange(dateStyle);
            sb = new StringBuffer();
            sb.append(text.getOriginator().getName()).append(": ");
            sr = new StyleRange();
            sr.start = startRange + dateStyle.length;
            sr.length = sb.length();
            sr.fontStyle = 1;
            sr.foreground = nickContained ? this.highlightColor : this.otherColor;
            st.append(sb.toString());
            st.setStyleRange(sr);
        }
        if (line != null && !line.equals("")) {
            int beforeMessageIndex = st.getText().length();
            st.append(line);
            if (text.getOriginator() == null) {
                sr = new StyleRange();
                sr.start = beforeMessageIndex;
                sr.length = line.length();
                sr.foreground = this.systemColor;
                sr.fontStyle = 1;
                st.setStyleRange(sr);
            } else if (nickContained) {
                sr = new StyleRange();
                sr.start = beforeMessageIndex;
                sr.length = line.length();
                sr.foreground = this.highlightColor;
                st.setStyleRange(sr);
            }
        }
        if (!text.isNoCRLF()) {
            st.append("\n");
        }
        if ((t = st.getText()) == null) {
            return true;
        }
        st.setSelection(t.length());
        return true;
    }

    protected void appendText(StyledText readText, ChatLine text) {
        String t;
        StyleRange sr;
        boolean nickContained;
        if (readText == null || text == null) {
            return;
        }
        StyledText st = readText;
        if (st == null || this.intelligentAppend(st, text)) {
            return;
        }
        int startRange = st.getText().length();
        StringBuffer sb = new StringBuffer();
        boolean bl = nickContained = text.getText().indexOf(this.userName) != -1;
        if (text.getOriginator() != null) {
            nickContained = !text.getOriginator().getName().equals(this.userName) && nickContained;
            sb.append("(").append(this.getCurrentDate(DEFAULT_TIME_FORMAT)).append(") ");
            StyleRange dateStyle = new StyleRange();
            dateStyle.start = startRange;
            dateStyle.length = sb.length();
            dateStyle.foreground = this.dateColor;
            dateStyle.fontStyle = 0;
            st.append(sb.toString());
            st.setStyleRange(dateStyle);
            sb = new StringBuffer();
            sb.append(text.getOriginator().getName()).append(": ");
            sr = new StyleRange();
            sr.start = startRange + dateStyle.length;
            sr.length = sb.length();
            sr.fontStyle = 1;
            sr.foreground = nickContained ? this.highlightColor : this.otherColor;
            st.append(sb.toString());
            st.setStyleRange(sr);
        }
        int beforeMessageIndex = st.getText().length();
        st.append(text.getText());
        if (text.getOriginator() == null) {
            sr = new StyleRange();
            sr.start = beforeMessageIndex;
            sr.length = text.getText().length();
            sr.foreground = this.systemColor;
            sr.fontStyle = 1;
            st.setStyleRange(sr);
        } else if (nickContained) {
            sr = new StyleRange();
            sr.start = beforeMessageIndex;
            sr.length = text.getText().length();
            sr.foreground = this.highlightColor;
            st.setStyleRange(sr);
        }
        if (!text.isNoCRLF()) {
            st.append("\n");
        }
        if ((t = st.getText()) == null) {
            return;
        }
        st.setSelection(t.length());
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchSiteProgressService pservice = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
        pservice.warnOfContentChange();
    }

    protected void outputClear() {
        if (MessageDialog.openConfirm(null, (String)"Confirm Clear Text Output", (String)"Are you sure you want to clear output?")) {
            this.getRootTextOutput().setText("");
        }
    }

    protected void outputCopy() {
        StyledText outputText = this.getRootTextOutput();
        String t = outputText.getSelectionText();
        if (t == null || t.length() == 0) {
            outputText.selectAll();
        }
        outputText.copy();
        outputText.setSelection(outputText.getText().length());
    }

    protected void outputSelectAll() {
        this.getRootTextOutput().selectAll();
    }

    protected void makeActions() {
        this.outputSelectAll = new Action(){

            public void run() {
                ChatRoomManagerView.this.outputSelectAll();
            }
        };
        this.outputSelectAll.setText("Select All");
        this.outputSelectAll.setToolTipText("Select All");
        this.outputSelectAll.setAccelerator(262209);
        this.outputCopy = new Action(){

            public void run() {
                ChatRoomManagerView.this.outputCopy();
            }
        };
        this.outputCopy.setText("Copy");
        this.outputCopy.setToolTipText("Copy Selected");
        this.outputCopy.setAccelerator(262211);
        this.outputCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.outputClear = new Action(){

            public void run() {
                ChatRoomManagerView.this.outputClear();
            }
        };
        this.outputClear.setText("Clear");
        this.outputClear.setToolTipText("Clear output window");
        this.outputPaste = new Action(){

            public void run() {
                ChatRoomManagerView.this.getRootTextInput().paste();
            }
        };
        this.outputPaste.setText("Paste");
        this.outputPaste.setToolTipText("Paste");
        this.outputPaste.setAccelerator(262230);
        this.outputPaste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.outputCopy);
        manager.add((IAction)this.outputPaste);
        manager.add((IAction)this.outputClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.outputSelectAll);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChatRoomManagerView.this.fillContextMenu(manager);
            }
        });
        StyledText outputText = this.getRootTextOutput();
        Menu menu = menuMgr.createContextMenu((Control)outputText);
        outputText.setMenu(menu);
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                StyledText outputText = ChatRoomManagerView.this.getRootTextOutput();
                TextSelection selection = new TextSelection(outputText.getSelectionRange().x, outputText.getSelectionRange().y);
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                StyledText outputText = ChatRoomManagerView.this.getRootTextOutput();
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    outputText.setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                }
            }
        };
        this.getSite().registerContextMenu(menuMgr, selectionProvider);
    }

    private Color colorFromRGBString(String rgb) {
        Color color = null;
        if (rgb == null || rgb.equals("")) {
            color = new Color((Device)this.getViewSite().getShell().getDisplay(), 0, 0, 0);
            return color;
        }
        if (color != null) {
            color.dispose();
        }
        StringTokenizer st = new StringTokenizer(rgb, ",");
        String[] vals = new String[3];
        int i = 0;
        while (i < 3) {
            vals[i] = st.nextToken();
            ++i;
        }
        color = new Color((Device)this.getViewSite().getShell().getDisplay(), Integer.parseInt(vals[0]), Integer.parseInt(vals[1]), Integer.parseInt(vals[2]));
        return color;
    }

    class ChatRoom
    implements IChatRoomInvitationListener,
    KeyListener {
        private IChatRoomContainer chatRoomContainer;
        private ChatRoomTab chatRoomTab;
        private IChatRoomMessageSender chatRoomMessageSender;
        private IUser localUser;
        private ListViewer chatRoomParticipantViewer = null;
        private ArrayList options;
        private int maximumCyclingOptions = 5;
        private int prefixLength;
        private int choice = 0;
        private int nickRemainder;
        private int caret;
        private char nickCompletionSuffix = (char)58;
        private boolean isCycling = false;
        private boolean isAtStart = false;
        private CTabItem itemSelected = null;

        private Text getInputText() {
            return this.chatRoomTab.getInputText();
        }

        private StyledText getOutputText() {
            return this.chatRoomTab.getOutputText();
        }

        ChatRoom(IChatRoomContainer container, ChatRoomTab tabItem) {
            Assert.isNotNull((Object)container);
            Assert.isNotNull((Object)tabItem);
            this.chatRoomContainer = container;
            this.chatRoomMessageSender = container.getChatRoomMessageSender();
            this.chatRoomTab = tabItem;
            this.chatRoomParticipantViewer = this.chatRoomTab.getListViewer();
            this.options = new ArrayList();
            this.chatRoomTab.setKeyListener(this);
            ChatRoomManagerView.this.rootTabFolder.setUnselectedCloseVisible(true);
            ChatRoomManagerView.this.rootTabFolder.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ChatRoom this$1;
                {
                    this.this$1 = chatRoom;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ChatRoom.access$0(this.this$1, (CTabItem)e.item);
                    if (ChatRoom.access$1(this.this$1) == ChatRoomTab.access$2(ChatRoom.access$2(this.this$1))) {
                        this.this$1.makeTabItemNormal();
                    }
                }
            });
        }

        protected void makeTabItemBold() {
            this.changeTabItem(true);
        }

        protected void makeTabItemNormal() {
            this.changeTabItem(false);
        }

        protected void changeTabItem(boolean bold) {
            CTabItem item = this.chatRoomTab.tabItem;
            Font oldFont = item.getFont();
            FontData[] fd = oldFont.getFontData();
            item.setFont(new Font(oldFont.getDevice(), fd[0].getName(), fd[0].getHeight(), bold ? 1 : 0));
        }

        public void handleMessage(ID fromID, String messageBody) {
            Display.getDefault().asyncExec(new Runnable(this, messageBody, fromID){
                final /* synthetic */ ChatRoom this$1;
                private final /* synthetic */ String val$messageBody;
                private final /* synthetic */ ID val$fromID;
                {
                    this.this$1 = chatRoom;
                    this.val$messageBody = string;
                    this.val$fromID = iD;
                }

                public void run() {
                    if (ChatRoom.access$7((ChatRoom)this.this$1).rootDisposed) {
                        return;
                    }
                    ChatRoom.access$7(this.this$1).appendText(ChatRoom.access$3(this.this$1), new ChatLine(this.val$messageBody, ChatRoom.access$7(this.this$1).new ChatRoomParticipant(this.val$fromID)));
                    CTabItem item = ChatRoomManagerView.access$1(ChatRoom.access$7(this.this$1)).getSelection();
                    if (item != ChatRoomTab.access$2(ChatRoom.access$2(this.this$1))) {
                        this.this$1.makeTabItemBold();
                    }
                }
            });
        }

        public void handleInvitationReceived(ID roomID, ID from, String subject, String body) {
            System.out.println("invitation room=" + roomID + ",from=" + from + ",subject=" + subject + ",body=" + body);
        }

        public void keyPressed(KeyEvent e) {
            this.handleKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            this.handleKeyReleased(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleKeyPressed(KeyEvent evt) {
            Text inputText = this.getInputText();
            if (evt.character == '\r') {
                if (inputText.getText().trim().length() > 0) {
                    this.handleTextInput(inputText.getText());
                }
                this.clearInput();
                evt.doit = false;
                this.isCycling = false;
            } else if (evt.character == '\t') {
                evt.doit = false;
                int pos = inputText.getCaretPosition();
                if (pos == 0) {
                    return;
                }
                String text = inputText.getText();
                if (this.isCycling) {
                    if (this.choice == this.options.size()) {
                        this.choice = 0;
                    }
                    String append = String.valueOf(((String)this.options.get(this.choice++)).substring(this.prefixLength)) + (this.isAtStart ? String.valueOf(this.nickCompletionSuffix) + ChatRoomManagerView.COMMAND_DELIM : ChatRoomManagerView.COMMAND_DELIM);
                    inputText.setText(String.valueOf(text.substring(0, this.caret)) + append + text.substring(this.caret + this.nickRemainder));
                    this.nickRemainder = append.length();
                    inputText.setSelection(this.caret + this.nickRemainder, this.caret + this.nickRemainder);
                } else {
                    int count = pos - 1;
                    while (count > -1 && !Character.isWhitespace(text.charAt(count))) {
                        --count;
                    }
                    this.options.clear();
                    String prefix = text.substring(++count, pos);
                    boolean bl = this.isAtStart = count == 0;
                    if (prefix.trim().equals("")) {
                        return;
                    }
                    String[] participants = this.chatRoomParticipantViewer.getList().getItems();
                    int i = 0;
                    while (i < participants.length) {
                        if (participants[i].startsWith(prefix)) {
                            this.options.add(participants[i]);
                        }
                        ++i;
                    }
                    if (this.options.isEmpty()) {
                        return;
                    }
                    this.prefixLength = prefix.length();
                    if (this.options.size() == 1) {
                        String nickname = (String)this.options.get(0);
                        nickname = nickname.substring(this.prefixLength);
                        inputText.insert(String.valueOf(nickname) + (this.isAtStart ? String.valueOf(this.nickCompletionSuffix) + ChatRoomManagerView.COMMAND_DELIM : ChatRoomManagerView.COMMAND_DELIM));
                    } else if (this.options.size() <= this.maximumCyclingOptions) {
                        this.isCycling = true;
                        this.caret = pos;
                        this.choice = 0;
                        String nickname = this.options.get(this.choice++) + (this.isAtStart ? String.valueOf(this.nickCompletionSuffix) + ChatRoomManagerView.COMMAND_DELIM : ChatRoomManagerView.COMMAND_DELIM);
                        nickname = nickname.substring(this.prefixLength);
                        inputText.insert(nickname);
                        this.nickRemainder = nickname.length();
                    } else {
                        StringBuffer choices;
                        StringBuffer stringBuffer = choices = new StringBuffer();
                        synchronized (stringBuffer) {
                            int i2 = 0;
                            while (i2 < this.options.size()) {
                                choices.append(this.options.get(i2)).append(' ');
                                ++i2;
                            }
                            choices.delete(choices.length() - 1, choices.length());
                        }
                        ChatRoomManagerView.this.appendText(this.getOutputText(), new ChatLine(choices.toString()));
                    }
                }
            } else {
                this.isCycling = false;
            }
        }

        protected void handleKeyReleased(KeyEvent evt) {
            if (evt.character == '\t') {
                evt.doit = false;
            }
        }

        protected void handleTextInput(String text) {
            if (this.chatRoomMessageSender == null) {
                MessageDialog.openError((Shell)ChatRoomManagerView.this.getViewSite().getShell(), (String)"Not connect", (String)"Not connected to channel room");
                return;
            }
            this.handleInputLine(text);
        }

        protected void handleInputLine(String line) {
            if (line != null && line.startsWith(ChatRoomManagerView.COMMAND_PREFIX)) {
                StringTokenizer st = new StringTokenizer(line, ChatRoomManagerView.COMMAND_DELIM);
                int countTokens = st.countTokens();
                String[] toks = new String[countTokens];
                int i = 0;
                while (i < countTokens) {
                    toks[i] = st.nextToken();
                    ++i;
                }
                String[] tokens = toks;
                this.handleCommands(line, tokens);
            } else {
                this.sendMessageLine(line);
            }
        }

        protected void handleCommands(String line, String[] tokens) {
            String command = tokens[0];
            while (command.startsWith(ChatRoomManagerView.COMMAND_PREFIX)) {
                command = command.substring(1);
            }
            String[] args = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, args, 0, tokens.length - 1);
            if (command.equalsIgnoreCase("QUIT")) {
                ChatRoomManagerView.this.cleanUp();
            } else if (command.equalsIgnoreCase("PART")) {
                this.disconnect();
            } else if (command.equalsIgnoreCase("JOIN")) {
                String arg1 = args[0];
                String arg2 = "";
                if (args.length > 1) {
                    arg2 = args[1];
                }
                ChatRoomManagerView.this.doJoinRoom(arg1, arg2);
            } else {
                this.sendMessageLine(line);
            }
        }

        protected void disconnect() {
            if (this.chatRoomContainer != null) {
                this.chatRoomContainer.disconnect();
            }
        }

        protected void clearInput() {
            this.getInputText().setText("");
        }

        protected void sendMessageLine(String line) {
            try {
                this.chatRoomMessageSender.sendMessage(line);
            }
            catch (ECFException eCFException) {
                this.disconnected();
            }
        }

        public void handlePresence(ID fromID, IPresence presence) {
            Display.getDefault().asyncExec(new Runnable(this, presence, fromID){
                final /* synthetic */ ChatRoom this$1;
                private final /* synthetic */ IPresence val$presence;
                private final /* synthetic */ ID val$fromID;
                {
                    this.this$1 = chatRoom;
                    this.val$presence = iPresence;
                    this.val$fromID = iD;
                }

                public void run() {
                    if (ChatRoom.access$7((ChatRoom)this.this$1).rootDisposed) {
                        return;
                    }
                    boolean isAdd = this.val$presence.getType().equals((Object)IPresence.Type.AVAILABLE);
                    ChatRoomParticipant p = ChatRoom.access$7(this.this$1).new ChatRoomParticipant(this.val$fromID);
                    if (isAdd) {
                        if (ChatRoom.access$4(this.this$1) == null) {
                            ChatRoom.access$5(this.this$1, p);
                        }
                        this.this$1.addParticipant(p);
                    } else {
                        this.this$1.removeParticipant(p);
                    }
                }
            });
        }

        public void disconnected() {
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ ChatRoom this$1;
                {
                    this.this$1 = chatRoom;
                }

                public void run() {
                    if (ChatRoom.access$7((ChatRoom)this.this$1).rootDisposed) {
                        return;
                    }
                    Text inputText = ChatRoom.access$6(this.this$1);
                    if (!inputText.isDisposed()) {
                        inputText.setEnabled(false);
                    }
                }
            });
        }

        protected boolean isConnected() {
            Text inputText = this.getInputText();
            return !inputText.isDisposed() && inputText.isEnabled();
        }

        protected void setSelected() {
            ChatRoomManagerView.this.rootTabFolder.setSelection(this.chatRoomTab.tabItem);
        }

        protected void addParticipant(IUser p) {
            ID id;
            if (p != null && (id = p.getID()) != null) {
                ChatRoomManagerView.this.appendText(this.getOutputText(), new ChatLine("(" + ChatRoomManagerView.this.getDateTime() + ") " + ChatRoomManagerView.this.trimUserID(id) + " entered", null));
                this.chatRoomParticipantViewer.add((Object)p);
            }
        }

        protected boolean isLocalUser(ID id) {
            if (this.localUser == null) {
                return false;
            }
            return this.localUser.getID().equals((Object)id);
        }

        protected void removeLocalUser() {
            String title = ChatRoomManagerView.this.getPartName();
            ChatRoomManagerView.this.setPartName("(" + title + ")");
            this.removeAllParticipants();
            ChatRoomManagerView.this.cleanUp();
            ChatRoomManagerView.this.setEnabled(false);
        }

        protected void removeParticipant(IUser p) {
            ID id;
            if (p != null && (id = p.getID()) != null) {
                ChatRoomManagerView.this.appendText(this.getOutputText(), new ChatLine("(" + ChatRoomManagerView.this.getDateTime() + ") " + ChatRoomManagerView.this.trimUserID(id) + " left", null));
                this.chatRoomParticipantViewer.remove((Object)p);
            }
        }

        protected void removeAllParticipants() {
            List l = this.chatRoomParticipantViewer.getList();
            int i = 0;
            while (i < l.getItemCount()) {
                Object o = this.chatRoomParticipantViewer.getElementAt(i);
                if (o != null) {
                    this.chatRoomParticipantViewer.remove(o);
                }
                ++i;
            }
        }

        static /* synthetic */ void access$0(ChatRoom chatRoom, CTabItem cTabItem) {
            chatRoom.itemSelected = cTabItem;
        }

        static /* synthetic */ CTabItem access$1(ChatRoom chatRoom) {
            return chatRoom.itemSelected;
        }

        static /* synthetic */ StyledText access$3(ChatRoom chatRoom) {
            return chatRoom.getOutputText();
        }

        static /* synthetic */ IUser access$4(ChatRoom chatRoom) {
            return chatRoom.localUser;
        }

        static /* synthetic */ void access$5(ChatRoom chatRoom, IUser iUser) {
            chatRoom.localUser = iUser;
        }

        static /* synthetic */ Text access$6(ChatRoom chatRoom) {
            return chatRoom.getInputText();
        }

        static /* synthetic */ ChatRoomManagerView access$7(ChatRoom chatRoom) {
            return chatRoom.ChatRoomManagerView.this;
        }
    }

    class ChatRoomParticipant
    implements IUser {
        private static final long serialVersionUID = 2008114088656711572L;
        ID id;

        public ChatRoomParticipant(ID id) {
            this.id = id;
        }

        public ID getID() {
            return this.id;
        }

        public String getName() {
            return this.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ChatRoomParticipant)) {
                return false;
            }
            ChatRoomParticipant o = (ChatRoomParticipant)other;
            return this.id.equals((Object)o.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return ChatRoomManagerView.this.trimUserID(this.id);
        }

        public Map getProperties() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getNickname() {
            return this.getName();
        }
    }

    class ChatRoomTab {
        private SashForm fullChat;
        private CTabItem tabItem;
        private SashForm rightSash;
        private StyledText outputText;
        private Text inputText;
        private ListViewer listViewer;
        private Action outputSelectAll;
        private Action outputCopy;
        private Action outputClear;

        ChatRoomTab(CTabFolder parent, String name) {
            this(true, parent, name, null);
        }

        ChatRoomTab(boolean withParticipantsList, CTabFolder parent, String name, KeyListener keyListener) {
            this.tabItem = new CTabItem(parent, 0);
            this.tabItem.setText(name);
            if (withParticipantsList) {
                this.fullChat = new SashForm((Composite)parent, 256);
                this.fullChat.setLayout((Layout)new FillLayout());
                Composite memberComp = new Composite((Composite)this.fullChat, 0);
                memberComp.setLayout((Layout)new FillLayout());
                this.listViewer = new ListViewer(memberComp, 2816);
                this.listViewer.setSorter(new ViewerSorter());
                Composite rightComp = new Composite((Composite)this.fullChat, 0);
                rightComp.setLayout((Layout)new FillLayout());
                this.rightSash = new SashForm(rightComp, 512);
            } else {
                this.rightSash = new SashForm((Composite)parent, 512);
            }
            Composite readInlayComp = new Composite((Composite)this.rightSash, 4);
            readInlayComp.setLayout((Layout)new GridLayout());
            readInlayComp.setLayoutData((Object)new GridData(1808));
            this.outputText = this.createStyledTextWidget(readInlayComp);
            this.outputText.setEditable(false);
            this.outputText.setLayoutData((Object)new GridData(1808));
            Composite writeComp = new Composite((Composite)this.rightSash, 0);
            writeComp.setLayout((Layout)new FillLayout());
            this.inputText = new Text(writeComp, 2626);
            if (keyListener != null) {
                this.inputText.addKeyListener(keyListener);
            }
            this.rightSash.setWeights(new int[]{7, 1});
            if (withParticipantsList) {
                this.fullChat.setWeights(new int[]{15, 85});
                this.tabItem.setControl((Control)this.fullChat);
            } else {
                this.tabItem.setControl((Control)this.rightSash);
            }
            parent.setSelection(this.tabItem);
            this.makeActions();
            this.hookContextMenu();
        }

        private StyledText createStyledTextWidget(Composite parent) {
            try {
                SourceViewer result = new SourceViewer(parent, null, null, true, 2634);
                result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
                result.setDocument((IDocument)new Document());
                return result.getTextWidget();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, "Source viewer not available.  Hyperlinking will be disabled.", (Throwable)e));
                return new StyledText(parent, 2634);
            }
            catch (NoClassDefFoundError e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, "Source viewer not available.  Hyperlinking will be disabled.", (Throwable)e));
                return new StyledText(parent, 2634);
            }
        }

        protected void outputClear() {
            if (MessageDialog.openConfirm(null, (String)"Confirm Clear Text Output", (String)"Are you sure you want to clear output?")) {
                this.outputText.setText("");
            }
        }

        protected void outputCopy() {
            String t = this.outputText.getSelectionText();
            if (t == null || t.length() == 0) {
                this.outputText.selectAll();
            }
            this.outputText.copy();
            this.outputText.setSelection(this.outputText.getText().length());
        }

        private void fillContextMenu(IMenuManager manager) {
            manager.add((IAction)this.outputCopy);
            manager.add((IAction)this.outputClear);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.outputSelectAll);
            manager.add((IContributionItem)new Separator("Additions"));
        }

        private void hookContextMenu() {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void menuAboutToShow(IMenuManager manager) {
                    ChatRoomTab.access$0(this.this$1, manager);
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)this.outputText);
            this.outputText.setMenu(menu);
            ISelectionProvider selectionProvider = new ISelectionProvider(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    TextSelection selection = new TextSelection(ChatRoomTab.access$1((ChatRoomTab)this.this$1).getSelectionRange().x, ChatRoomTab.access$1((ChatRoomTab)this.this$1).getSelectionRange().y);
                    return selection;
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                    if (selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        ChatRoomTab.access$1(this.this$1).setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                    }
                }
            };
            ChatRoomManagerView.this.getSite().registerContextMenu(menuMgr, selectionProvider);
        }

        private void makeActions() {
            this.outputSelectAll = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    ChatRoomTab.access$1(this.this$1).selectAll();
                }
            };
            this.outputSelectAll.setText("Select All");
            this.outputSelectAll.setToolTipText("Select All");
            this.outputSelectAll.setAccelerator(262209);
            this.outputCopy = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    this.this$1.outputCopy();
                }
            };
            this.outputCopy.setText("Copy");
            this.outputCopy.setToolTipText("Copy Selected");
            this.outputCopy.setAccelerator(262211);
            this.outputCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
            this.outputClear = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    this.this$1.outputClear();
                }
            };
            this.outputClear.setText("Clear");
            this.outputClear.setToolTipText("Clear output window");
            ChatRoomManagerView.this.outputPaste = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    ChatRoomManagerView.access$0(ChatRoomTab.access$3(this.this$1)).paste();
                }
            };
        }

        protected Text getInputText() {
            return this.inputText;
        }

        protected void setKeyListener(KeyListener listener) {
            if (listener != null) {
                this.inputText.addKeyListener(listener);
            }
        }

        protected ListViewer getListViewer() {
            return this.listViewer;
        }

        public StyledText getOutputText() {
            return this.outputText;
        }

        static /* synthetic */ void access$0(ChatRoomTab chatRoomTab, IMenuManager iMenuManager) {
            chatRoomTab.fillContextMenu(iMenuManager);
        }

        static /* synthetic */ StyledText access$1(ChatRoomTab chatRoomTab) {
            return chatRoomTab.outputText;
        }

        static /* synthetic */ ChatRoomManagerView access$3(ChatRoomTab chatRoomTab) {
            return chatRoomTab.ChatRoomManagerView.this;
        }
    }
}

