/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.bittorrent.Torrent;
import org.eclipse.bittorrent.TorrentConfiguration;
import org.eclipse.bittorrent.TorrentFile;

public final class TorrentFactory {
    private static final Map CREATED_TORRENTS = new HashMap();
    private static final FileFilter TORRENTS_FILTER = new TorrentsFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Torrent createTorrent(TorrentFile file, Properties properties) throws IOException {
        if (TorrentConfiguration.statePath == null) {
            throw new IllegalStateException("The folder to store configuration information has not been set yet");
        }
        if (file == null) {
            throw new IllegalArgumentException("The torrent cannot be null");
        }
        Map map = CREATED_TORRENTS;
        synchronized (map) {
            Torrent torrent = (Torrent)CREATED_TORRENTS.get(file.getInfoHash());
            if (torrent == null) {
                File targetFile = file.getTargetFile();
                if (targetFile == null) {
                    throw new IllegalArgumentException("The target file or folder for this torrent has not been set yet");
                }
                torrent = new Torrent(file, properties);
                CREATED_TORRENTS.put(file.getInfoHash(), torrent);
            }
            return torrent;
        }
    }

    public static Torrent createTorrent(TorrentFile file) throws IllegalArgumentException, IllegalStateException, IOException {
        return TorrentFactory.createTorrent(file, null);
    }

    public static Torrent[] getSavedTorrents() throws IllegalStateException, IOException {
        if (TorrentConfiguration.statePath == null) {
            throw new IllegalStateException("The folder to store configuration information has not been set yet");
        }
        File[] files = TorrentConfiguration.statePath.listFiles(TORRENTS_FILTER);
        int count = files.length;
        Torrent[] torrents = new Torrent[count];
        int i = 0;
        while (i < count) {
            String path = files[i].getAbsolutePath();
            path = String.valueOf(path.substring(0, path.lastIndexOf("."))) + ".properties";
            Properties properties = new Properties();
            properties.load(new FileInputStream(path));
            TorrentFile file = new TorrentFile(files[i]);
            file.setTargetFile(new File(properties.getProperty("target")));
            torrents[i] = TorrentFactory.createTorrent(file, properties);
            ++i;
        }
        return torrents;
    }

    private TorrentFactory() {
    }

    private static class TorrentsFilter
    implements FileFilter {
        private TorrentsFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".torrent");
        }
    }
}

