/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.editor.listeners;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.example.collab.editor.Activator;
import org.eclipse.ecf.example.collab.editor.listeners.EditChannelListener;
import org.eclipse.ecf.example.collab.editor.listeners.PresenceChannelListener;
import org.eclipse.ecf.example.collab.editor.message.EditorChangeMessage;
import org.eclipse.ecf.example.collab.editor.message.EditorUpdateRequest;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EditorListener
implements IDocumentListener {
    public static final String SESSION_NAME_DELIMITER = "_";
    private IDocument document;
    private AbstractTextEditor editor;
    private IChannel channel;
    private IContainer container = null;
    private IChannelListener channelListener;
    private String sessionID;
    private boolean documentOwner;
    static /* synthetic */ Class class$0;

    public EditorListener(IDocument document, AbstractTextEditor textEditor, boolean owner) {
        this.document = document;
        this.editor = textEditor;
        this.documentOwner = owner;
        try {
            this.intializeEditorSession();
            if (Activator.getDefault().getPresenceChannelListener() == null) {
                Activator.getDefault().intializePresenceSession(new PresenceChannelListener());
            }
        }
        catch (ECFException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.channel == null) {
            this.document.removeDocumentListener((IDocumentListener)this);
            return;
        }
        if (!Activator.getDefault().isListenerActive()) {
            return;
        }
        this.sendDocumentUpdateMessage();
    }

    public void sendDocumentUpdateMessage() {
        try {
            this.channel.sendMessage(this.createMessageFromEvent(this.document));
        }
        catch (ECFException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private byte[] createMessageFromEvent(IDocument document) throws IOException, ECFException {
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        ObjectOutputStream douts = new ObjectOutputStream(bouts);
        douts.writeObject(new EditorChangeMessage(document.get()));
        return bouts.toByteArray();
    }

    public void intializeEditorSession() throws ECFException, IOException {
        this.container = ContainerFactory.getDefault().createContainer(Activator.getDefault().getPreferenceStore().getString("CONTAINER_TYPE"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IChannelContainerAdapter channelContainer = (IChannelContainerAdapter)this.container.getAdapter((Class)clazz);
        this.sessionID = String.valueOf(Activator.getDefault().getPreferenceStore().getString("CHANNEL_ID")) + SESSION_NAME_DELIMITER + this.editor.getTitle();
        Activator.getDefault().addSession(this.sessionID, this.editor.getTitle());
        ID channelID = IDFactory.getDefault().createID(channelContainer.getChannelNamespace(), this.sessionID);
        this.channelListener = new EditChannelListener(this.document, this.editor, this.documentOwner, this);
        this.channel = channelContainer.createChannel(channelID, this.channelListener, new HashMap());
        this.container.connect(IDFactory.getDefault().createID(this.container.getConnectNamespace(), Activator.getDefault().getPreferenceStore().getString("TARGET_SERVER")), null);
        if (!this.documentOwner) {
            this.sendEditorUpdateRequest();
        }
    }

    private void sendEditorUpdateRequest() throws ECFException, IOException {
        if (this.channel != null) {
            this.channel.sendMessage(new EditorUpdateRequest().toByteArray());
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }
}

