/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.io.File;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.example.collab.share.User;
import org.eclipse.ecf.internal.example.collab.ui.ChatComposite;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

class ChatDropTarget
implements DropTargetListener {
    private final LineChatClientView view;
    DropTarget dropTarget = null;
    TextTransfer textTransfer = null;
    FileTransfer fileTransfer = null;
    ChatComposite composite = null;
    User selectedUser = null;

    public ChatDropTarget(LineChatClientView view, Control control, ChatComposite comp) {
        this.dropTarget = new DropTarget(control, 19);
        this.view = view;
        this.textTransfer = TextTransfer.getInstance();
        this.fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{this.fileTransfer, this.textTransfer};
        this.dropTarget.setTransfer(types);
        this.dropTarget.addDropListener((DropTargetListener)this);
        this.composite = comp;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        int i = 0;
        while (i < event.dataTypes.length) {
            if (this.fileTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                if (event.detail == 1) break;
                event.detail = 0;
                break;
            }
            ++i;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        if (this.fileTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.fileTransfer.isSupportedType(event.currentDataType)) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                ID target = this.selectedUser == null ? null : this.selectedUser.getUserID();
                File file = new File(files[i]);
                if (file.exists() && !file.isDirectory() && this.composite != null) {
                    this.composite.sendFile(file.getPath(), String.valueOf(this.view.downloaddir) + File.separatorChar + file.getName(), null, target, false);
                }
                ++i;
            }
        }
    }
}

