/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.ProxyClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Messages;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientSslTrustManager;

public class SslProtocolSocketFactory
implements ProtocolSocketFactory {
    private SSLContext sslContext;
    private Proxy proxy;

    public SslProtocolSocketFactory(Proxy proxy) {
        this.proxy = proxy;
    }

    private SSLContext getSslContext() {
        if (this.sslContext == null) {
            try {
                this.sslContext = SSLContext.getInstance(Messages.SslProtocolSocketFactory_SSLContext_Instance);
                this.sslContext.init(null, new TrustManager[]{new HttpClientSslTrustManager()}, null);
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer.httpclient", 1111, Messages.SslProtocolSocketFactory_Status_Create_Error, (Throwable)e));
            }
        }
        return this.sslContext;
    }

    public Socket createSocket(String remoteHost, int remotePort) throws IOException, UnknownHostException {
        return this.getSslContext().getSocketFactory().createSocket(remoteHost, remotePort);
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSslContext().getSocketFactory().createSocket(remoteHost, remotePort, clientHost, clientPort);
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null || params.getConnectionTimeout() == 0) {
            return this.getSslContext().getSocketFactory().createSocket(remoteHost, remotePort, clientHost, clientPort);
        }
        if (this.proxy != null && !Proxy.NO_PROXY.equals((Object)this.proxy)) {
            ProxyClient.ConnectResponse response;
            ProxyClient proxyClient = new ProxyClient();
            ProxyAddress address = this.proxy.getAddress();
            proxyClient.getHostConfiguration().setProxy(address.getHostName(), address.getPort());
            proxyClient.getHostConfiguration().setHost(remoteHost, remotePort);
            String proxyUsername = this.proxy.getUsername();
            String proxyPassword = this.proxy.getPassword();
            if (proxyUsername != null && !proxyUsername.equals("")) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                proxyClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
            if ((response = proxyClient.connect()).getSocket() != null) {
                Socket sslsocket = this.getSslContext().getSocketFactory().createSocket(response.getSocket(), remoteHost, remotePort, true);
                return sslsocket;
            }
        }
        Socket socket = this.getSslContext().getSocketFactory().createSocket();
        socket.bind(new InetSocketAddress(clientHost, clientPort));
        socket.connect(new InetSocketAddress(remoteHost, remotePort), params.getConnectionTimeout());
        return socket;
    }
}

