/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class RosterPacket
extends IQ {
    private final List rosterItems = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRosterItems() {
        List list = this.rosterItems;
        synchronized (list) {
            List entries = Collections.unmodifiableList(new ArrayList(this.rosterItems));
            return entries.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<query xmlns=\"jabber:iq:roster\">");
        List list = this.rosterItems;
        synchronized (list) {
            int i = 0;
            while (i < this.rosterItems.size()) {
                Item entry = (Item)this.rosterItems.get(i);
                buf.append(entry.toXML());
                ++i;
            }
        }
        buf.append("</query>");
        return buf.toString();
    }

    public static class Item {
        private String user;
        private String name;
        private ItemType itemType;
        private ItemStatus itemStatus;
        private final List groupNames;

        public Item(String user, String name) {
            this.user = user.toLowerCase();
            this.name = name;
            this.itemType = null;
            this.itemStatus = null;
            this.groupNames = new ArrayList();
        }

        public String getUser() {
            return this.user;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = itemType;
        }

        public ItemStatus getItemStatus() {
            return this.itemStatus;
        }

        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator getGroupNames() {
            List list = this.groupNames;
            synchronized (list) {
                return Collections.unmodifiableList(this.groupNames).iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addGroupName(String groupName) {
            List list = this.groupNames;
            synchronized (list) {
                if (!this.groupNames.contains(groupName)) {
                    this.groupNames.add(groupName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeGroupName(String groupName) {
            List list = this.groupNames;
            synchronized (list) {
                this.groupNames.remove(groupName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<item jid=\"").append(this.user).append("\"");
            if (this.name != null) {
                buf.append(" name=\"").append(this.name).append("\"");
            }
            if (this.itemType != null) {
                buf.append(" subscription=\"").append(this.itemType).append("\"");
            }
            if (this.itemStatus != null) {
                buf.append(" ask=\"").append(this.itemStatus).append("\"");
            }
            buf.append(">");
            List list = this.groupNames;
            synchronized (list) {
                int i = 0;
                while (i < this.groupNames.size()) {
                    String groupName = (String)this.groupNames.get(i);
                    buf.append("<group>").append(StringUtils.escapeForXML(groupName)).append("</group>");
                    ++i;
                }
            }
            buf.append("</item>");
            return buf.toString();
        }
    }

    public static class ItemStatus {
        public static final ItemStatus SUBSCRIPTION_PENDING = new ItemStatus("subscribe");
        public static final ItemStatus UNSUBCRIPTION_PENDING = new ItemStatus("unsubscribe");
        private String value;

        public static ItemStatus fromString(String value) {
            if (value == null) {
                return null;
            }
            if ("unsubscribe".equals(value = value.toLowerCase())) {
                return SUBSCRIPTION_PENDING;
            }
            if ("subscribe".equals(value)) {
                return SUBSCRIPTION_PENDING;
            }
            return null;
        }

        private ItemStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class ItemType {
        public static final ItemType NONE = new ItemType("none");
        public static final ItemType TO = new ItemType("to");
        public static final ItemType FROM = new ItemType("from");
        public static final ItemType BOTH = new ItemType("both");
        public static final ItemType REMOVE = new ItemType("remove");
        private String value;

        public static ItemType fromString(String value) {
            if (value == null) {
                return null;
            }
            if ("none".equals(value = value.toLowerCase())) {
                return NONE;
            }
            if ("to".equals(value)) {
                return TO;
            }
            if ("from".equals(value)) {
                return FROM;
            }
            if ("both".equals(value)) {
                return BOTH;
            }
            if ("remove".equals(value)) {
                return REMOVE;
            }
            return null;
        }

        public ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

