/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.ui.views.IServiceAccessHandler;
import org.eclipse.ecf.internal.discovery.ui.Activator;
import org.eclipse.ecf.internal.discovery.ui.Messages;
import org.eclipse.ecf.internal.discovery.ui.ViewContentProvider;
import org.eclipse.ecf.internal.discovery.ui.ViewLabelProvider;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeObject;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DiscoveryView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    private static final IContributionItem[][] EMPTY_CONTRIBUTION = new IContributionItem[][]{new IContributionItem[0]};
    protected TreeViewer viewer;
    Action refreshAction;
    private Action emptyServiceAccessHandlerAction;
    private ServiceTracker discoveryServiceTracker;
    private IServiceListener serviceListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent e) {
                DiscoveryView.this.openPropertiesView((IStructuredSelection)e.getSelection());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.initializeDiscoveryContainer();
        this.makeActions();
        this.hookContextMenu();
        this.hookActionBars();
    }

    void openPropertiesView(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (!(element instanceof ViewTreeService)) {
            return;
        }
        try {
            this.getSite().getWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DiscoveryView_ERROR_SHOW_VIEW_TITLE, (String)Messages.DiscoveryView_ERROR_SHOW_VIEW_MESSAGE);
        }
    }

    private void hookActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.refreshAction);
    }

    protected IDiscoveryContainerAdapter getDiscovery() {
        if (this.discoveryServiceTracker == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.discovery.service.IDiscoveryService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.discoveryServiceTracker = new ServiceTracker(bundleContext, clazz.getName(), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    Object result = Activator.getContext().getService(reference);
                    DiscoveryView.this.initializeDiscoveryContainer((IDiscoveryContainerAdapter)result);
                    return result;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            });
            this.discoveryServiceTracker.open();
        }
        return (IDiscoveryContainerAdapter)this.discoveryServiceTracker.getService();
    }

    protected void initializeDiscoveryContainer() {
        ContainerFactory.getDefault().getDescriptions();
        this.initializeDiscoveryContainer(this.getDiscovery());
    }

    protected synchronized void initializeDiscoveryContainer(IDiscoveryContainerAdapter discovery) {
        IServiceInfo[] existingServices = null;
        if (discovery != null) {
            if (this.serviceListener == null) {
                this.serviceListener = new DiscoveryViewServiceListener();
                discovery.addServiceListener(this.serviceListener);
            }
            existingServices = discovery.getServices();
        }
        if (existingServices != null) {
            int i = 0;
            while (i < existingServices.length) {
                this.addServiceInfo(existingServices[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllServices() {
        IDiscoveryContainerAdapter discovery = this.getDiscovery();
        if (discovery != null) {
            DiscoveryView discoveryView = this;
            synchronized (discoveryView) {
                if (this.serviceListener != null) {
                    discovery.removeServiceListener(this.serviceListener);
                    this.serviceListener = null;
                }
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ViewContentProvider vcp = (ViewContentProvider)DiscoveryView.this.viewer.getContentProvider();
                if (vcp != null) {
                    vcp.clear();
                    DiscoveryView.this.refreshView();
                }
            }
        });
    }

    public void addServiceTypeInfo(final String type) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViewContentProvider vcp = (ViewContentProvider)DiscoveryView.this.viewer.getContentProvider();
                if (vcp != null) {
                    vcp.addServiceTypeInfo(type);
                    DiscoveryView.this.refreshView();
                }
            }
        });
    }

    public void addServiceInfo(final IServiceInfo serviceInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViewContentProvider vcp = (ViewContentProvider)DiscoveryView.this.viewer.getContentProvider();
                if (vcp != null) {
                    vcp.addServiceInfo(serviceInfo);
                    DiscoveryView.this.refreshView();
                }
            }
        });
    }

    public void addServiceInfo(final IServiceID id) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViewContentProvider vcp = (ViewContentProvider)DiscoveryView.this.viewer.getContentProvider();
                if (vcp != null) {
                    vcp.addServiceInfo(id);
                    DiscoveryView.this.refreshView();
                }
            }
        });
    }

    public void removeServiceInfo(final IServiceInfo serviceInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViewContentProvider vcp = (ViewContentProvider)DiscoveryView.this.viewer.getContentProvider();
                if (vcp != null) {
                    vcp.removeServiceInfo(serviceInfo);
                    DiscoveryView.this.refreshView();
                }
            }
        });
    }

    protected void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                DiscoveryView.this.viewer.refresh();
                DiscoveryView.this.expandAll();
            }
        });
    }

    protected void expandAll() {
        this.viewer.expandToLevel(3);
    }

    private void makeActions() {
        this.emptyServiceAccessHandlerAction = new Action(){

            public void run() {
            }
        };
        this.emptyServiceAccessHandlerAction.setText(Messages.DiscoveryView_NO_SERVICE_HANDLER_LABEL);
        this.emptyServiceAccessHandlerAction.setEnabled(false);
        this.refreshAction = new Action(){

            public void run() {
                DiscoveryView.this.clearAllServices();
                DiscoveryView.this.initializeDiscoveryContainer();
            }
        };
        this.refreshAction.setText(Messages.DiscoveryView_REFRESH_ACTION_LABEL);
        this.refreshAction.setToolTipText(Messages.DiscoveryView_REFRESH_SERVICES_TOOLTIPTEXT);
        this.refreshAction.setEnabled(true);
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ecf.discovery.ui", (String)"icons/nav_refresh.gif"));
    }

    void fillContextMenu(IMenuManager manager) {
        ViewTreeObject viewTreeObject = this.getSelectedTreeObject();
        if (viewTreeObject != null && viewTreeObject instanceof ViewTreeService) {
            IContributionItem[][] contributions;
            ViewTreeService tp = (ViewTreeService)viewTreeObject;
            ViewContentProvider vcp = (ViewContentProvider)this.viewer.getContentProvider();
            IServiceInfo serviceInfo = tp.getServiceInfo();
            if (!(vcp != null && vcp.isRoot(tp) || serviceInfo == null || tp.getID() == null || (contributions = this.getContributionsForServiceInfo(serviceInfo)) == null)) {
                int count = 0;
                int i = 0;
                while (i < contributions.length) {
                    int j = 0;
                    while (j < contributions[i].length) {
                        ++count;
                        manager.add(contributions[i][j]);
                        ++j;
                    }
                    manager.add((IContributionItem)new Separator());
                    ++i;
                }
                if (count == 0) {
                    manager.add((IAction)this.emptyServiceAccessHandlerAction);
                }
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected ViewTreeObject getSelectedTreeObject() {
        ISelection selection = this.viewer.getSelection();
        return (ViewTreeObject)((IStructuredSelection)selection).getFirstElement();
    }

    private IContributionItem[][] getContributionsForServiceInfo(IServiceInfo serviceInfo) {
        IExtensionRegistry reg = Activator.getDefault().getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint serviceAccessPoint = reg.getExtensionPoint("org.eclipse.ecf.discovery.ui", "serviceAccessHandler");
            if (serviceAccessPoint == null) {
                return EMPTY_CONTRIBUTION;
            }
            IConfigurationElement[] serviceAccessConfigurationElements = serviceAccessPoint.getConfigurationElements();
            ArrayList<IContributionItem[]> results = new ArrayList<IContributionItem[]>();
            int i = 0;
            while (i < serviceAccessConfigurationElements.length) {
                try {
                    IServiceAccessHandler sah = (IServiceAccessHandler)serviceAccessConfigurationElements[i].createExecutableExtension("class");
                    results.add(sah.getContributionsForService(serviceInfo));
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.discovery.ui", 2, Messages.DiscoveryView_EXCEPTION_CREATING_SERVICEACCESSHANDLER, (Throwable)e));
                }
                ++i;
            }
            return (IContributionItem[][])results.toArray((T[])new IContributionItem[0][]);
        }
        return EMPTY_CONTRIBUTION;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DiscoveryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void dispose() {
        super.dispose();
        IDiscoveryContainerAdapter discovery = this.getDiscovery();
        if (discovery != null) {
            discovery.removeServiceListener(this.serviceListener);
        }
        if (this.discoveryServiceTracker != null) {
            this.discoveryServiceTracker.close();
            this.discoveryServiceTracker = null;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class DiscoveryViewServiceListener
    implements IServiceListener {
        DiscoveryViewServiceListener() {
        }

        public void serviceDiscovered(IServiceEvent anEvent) {
            DiscoveryView.this.addServiceInfo(anEvent.getServiceInfo());
        }

        public void serviceUndiscovered(IServiceEvent anEvent) {
            DiscoveryView.this.removeServiceInfo(anEvent.getServiceInfo());
        }
    }
}

