/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.server;

import java.security.InvalidParameterException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.examples.remoteservices.server.Activator;
import org.eclipse.ecf.internal.examples.remoteservices.server.RemoteEnvironmentInfoImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.util.DiscoveryProperties;
import org.eclipse.ecf.remoteservice.util.RemoteServiceProperties;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class DiscoverableServer
implements IApplication {
    private static final String ECF_GENERIC_CLIENT = "ecf.generic.client";
    private IContainer serviceHostContainer;
    private IServiceInfo serviceInfo;
    private IDiscoveryContainerAdapter discovery;
    private String containerType;
    private String connectTarget;
    private String connectPassword;
    private String serviceType;
    private boolean done = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private String getCompleteServiceType() {
        return "_" + this.serviceType + "._tcp.local.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext ctxt) throws Exception {
        Map args = ctxt.getArguments();
        this.initializeFromArguments((String[])args.get("application.args"));
        this.serviceHostContainer = ContainerFactory.getDefault().createContainer(this.containerType);
        ID targetID = IDFactory.getDefault().createID(this.serviceHostContainer.getConnectNamespace(), this.connectTarget);
        IConnectContext connectContext = this.connectPassword == null ? null : ConnectContextFactory.createPasswordConnectContext((String)this.connectPassword);
        this.serviceHostContainer.connect(targetID, connectContext);
        this.discovery = Activator.getDefault().getDiscoveryService(5000);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRemoteServiceContainerAdapter containerAdapter = (IRemoteServiceContainerAdapter)this.serviceHostContainer.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String className = clazz2.getName();
        RemoteServiceProperties props = new RemoteServiceProperties(this.containerType, this.serviceHostContainer);
        props.put("org.eclipse.ecf.serviceRegistrationRemote", "true");
        containerAdapter.registerRemoteService(new String[]{className}, (Object)new RemoteEnvironmentInfoImpl(), (Dictionary)props);
        System.out.println("Registered remote service " + className);
        String serviceName = String.valueOf(System.getProperty("user.name")) + System.currentTimeMillis();
        IServiceID serviceID = ServiceIDFactory.getDefault().createServiceID(this.discovery.getServicesNamespace(), this.getCompleteServiceType(), serviceName);
        this.serviceInfo = new ServiceInfo(this.serviceType, null, 80, serviceID, (IServiceProperties)new ServiceProperties((Properties)new DiscoveryProperties(className, this.containerType, this.serviceHostContainer)));
        this.discovery.registerService(this.serviceInfo);
        System.out.println("discovery publish\n\tserviceName=" + serviceID.getServiceName() + "\n\tserviceTypeID=" + serviceID.getServiceTypeID());
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            while (!this.done) {
                this.wait();
            }
        }
        return new Integer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.serviceInfo != null && this.discovery != null) {
            IContainer container;
            try {
                this.discovery.unregisterService(this.serviceInfo);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
            this.serviceInfo = null;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((container = (IContainer)this.discovery.getAdapter((Class)clazz)) != null) {
                container.disconnect();
            }
            this.discovery = null;
        }
        if (this.serviceHostContainer != null) {
            this.serviceHostContainer.disconnect();
            this.serviceHostContainer = null;
        }
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            this.done = true;
            this.notifyAll();
        }
    }

    private void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (!args[i].startsWith("-")) {
                this.connectTarget = args[i++];
            } else if (args[i - 1].equalsIgnoreCase("-containerType")) {
                this.containerType = args[++i];
            } else if (args[i - 1].equalsIgnoreCase("-connectPassword")) {
                this.connectPassword = args[++i];
            } else if (args[i - 1].equalsIgnoreCase("-serviceType")) {
                this.serviceType = args[++i];
            }
            ++i;
        }
        if (this.connectTarget == null) {
            this.usage();
            throw new InvalidParameterException("connectTarget cannot be null");
        }
        if (this.containerType == null) {
            this.containerType = ECF_GENERIC_CLIENT;
        }
        if (this.serviceType == null) {
            this.serviceType = "remotesvcs";
        }
    }

    private void usage() {
        System.out.println("usage: eclipse -console [options] -application org.eclipse.ecf.examples.remoteservices.server.remoteServicesServer <connectTarget>");
        System.out.println("   options: [-containerType <typename>] default=ecf.generic.client");
        System.out.println("            [-connectPassword <password>] default=none");
        System.out.println("            [-serviceType <serviceType>] default=remotesvcs");
    }
}

