/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.efs;

import java.net.URL;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.efs.EFSRemoteFile;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;

public class FileStoreBrowser
extends AbstractFileSystemBrowser {
    IFileStore fileStore;
    URL efsDirectory;

    public FileStoreBrowser(IFileStore store, URL efsDirectory, IFileID directoryID2, IRemoteFileSystemListener listener) throws RemoteFileSystemException {
        super(directoryID2, listener);
        Assert.isNotNull((Object)store);
        this.fileStore = store;
        Assert.isNotNull((Object)efsDirectory);
        this.efsDirectory = efsDirectory;
    }

    protected void runRequest() throws Exception {
        IFileInfo fileStoreInfo = this.fileStore.fetchInfo();
        if (fileStoreInfo.isDirectory()) {
            IFileInfo[] fileInfos = this.fileStore.childInfos(0, null);
            this.remoteFiles = new IRemoteFile[fileInfos.length];
            int i = 0;
            while (i < fileInfos.length) {
                this.remoteFiles[i] = new EFSRemoteFile(FileIDFactory.getDefault().createFileID(this.fileID.getNamespace(), new URL(this.efsDirectory + "/" + fileInfos[i].getName())), fileInfos[i]);
                ++i;
            }
        } else {
            this.remoteFiles = new IRemoteFile[1];
            this.remoteFiles[0] = new EFSRemoteFile(this.fileID, fileStoreInfo);
        }
    }
}

