/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.util.Dictionary;
import org.eclipse.ecf.internal.provider.remoteservice.Activator;
import org.eclipse.ecf.internal.provider.remoteservice.Messages;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceReferenceImpl;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class RemoteFilterImpl
implements IRemoteFilter {
    Filter filter;

    public RemoteFilterImpl(String createFilter) throws InvalidSyntaxException {
        if (createFilter == null) {
            throw new InvalidSyntaxException(Messages.RemoteFilter_EXCEPTION_FILTER_NOT_NULL, createFilter);
        }
        this.filter = Activator.getDefault().createFilter(createFilter);
    }

    public boolean match(IRemoteServiceReference reference) {
        if (reference == null) {
            return false;
        }
        if (reference instanceof RemoteServiceReferenceImpl) {
            RemoteServiceReferenceImpl impl = (RemoteServiceReferenceImpl)reference;
            return this.match(impl.getRegistration().properties);
        }
        return false;
    }

    public boolean match(Dictionary dictionary) {
        return this.filter.match(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.filter.matchCase(dictionary);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemoteFilterImpl)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.filter.toString();
    }
}

