/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferResponseEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDataEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDoneEvent;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

public class XMPPOutgoingFileTransfer
implements IOutgoingFileTransfer {
    private static final int BUFFER_SIZE = 4096;
    ID sessionID;
    XMPPID remoteTarget;
    IFileTransferInfo transferInfo;
    IFileTransferListener listener;
    FileTransferManager manager;
    File localFile;
    long fileSize;
    OutgoingFileTransfer outgoingFileTransfer;
    long amountWritten = 0L;
    FileTransfer.Status status;
    Exception exception;
    OutgoingFileTransfer.NegotiationProgress progress = new OutgoingFileTransfer.NegotiationProgress();

    public XMPPOutgoingFileTransfer(FileTransferManager manager, XMPPID remoteTarget, IFileTransferInfo fileTransferInfo, IFileTransferListener listener) {
        this.manager = manager;
        this.remoteTarget = remoteTarget;
        this.transferInfo = fileTransferInfo;
        this.listener = listener;
        this.sessionID = this.createSessionID();
        String fullyQualifiedName = remoteTarget.getFQName();
        this.outgoingFileTransfer = manager.createOutgoingFileTransfer(fullyQualifiedName);
    }

    private ID createSessionID() {
        try {
            return IDFactory.getDefault().createGUID();
        }
        catch (IDCreateException iDCreateException) {
            throw new NullPointerException("cannot create id for XMPPOutgoingFileTransfer");
        }
    }

    public synchronized ID getRemoteTargetID() {
        return this.remoteTarget;
    }

    public ID getID() {
        return this.sessionID;
    }

    private void fireTransferListenerEvent(IFileTransferEvent event) {
        this.listener.handleTransferEvent(event);
    }

    private void setStatus(FileTransfer.Status s) {
        this.status = s;
    }

    private void setException(Exception e) {
        this.exception = e;
    }

    private FileTransfer.Status getStatus() {
        return this.status;
    }

    public synchronized void startSend(File localFile, String description) throws XMPPException {
        this.localFile = localFile;
        this.fileSize = localFile.length();
        this.setStatus(FileTransfer.Status.INITIAL);
        this.outgoingFileTransfer.sendFile(localFile.getAbsolutePath(), this.fileSize, description, this.progress);
        Thread transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                OutputStream outs;
                XMPPOutgoingFileTransfer.this.setStatus(XMPPOutgoingFileTransfer.this.outgoingFileTransfer.getStatus());
                boolean negotiation = true;
                while (true) {
                    if (!negotiation) {
                        outs = XMPPOutgoingFileTransfer.this.progress.getOutputStream();
                        if (outs != null) break;
                        return;
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    FileTransfer.Status s = XMPPOutgoingFileTransfer.this.progress.getStatus();
                    XMPPOutgoingFileTransfer.this.setStatus(s);
                    boolean negotiated = XMPPOutgoingFileTransfer.this.getStatus().equals(FileTransfer.Status.NEGOTIATED);
                    if (!s.equals(FileTransfer.Status.NEGOTIATED) && !s.equals(FileTransfer.Status.CANCLED) && !s.equals(FileTransfer.Status.COMPLETE) && !s.equals(FileTransfer.Status.ERROR) && !s.equals(FileTransfer.Status.REFUSED)) continue;
                    XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new IOutgoingFileTransferResponseEvent(this, negotiated){
                        private static final long serialVersionUID = -5940612388464073240L;
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ boolean val$negotiated;
                        {
                            this.this$1 = var1_1;
                            this.val$negotiated = bl;
                        }

                        public boolean requestAccepted() {
                            return this.val$negotiated;
                        }

                        public IOutgoingFileTransfer getSource() {
                            return 1.access$0(this.this$1);
                        }

                        public String toString() {
                            StringBuffer buf = new StringBuffer("OutgoingFileTransferResponseEvent[");
                            buf.append("requestAccepted=").append(this.requestAccepted()).append("]");
                            return buf.toString();
                        }

                        public void setFileTransferJob(FileTransferJob job) {
                        }
                    });
                    negotiation = false;
                }
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(XMPPOutgoingFileTransfer.this.localFile);
                        XMPPOutgoingFileTransfer.this.writeToStream(inputStream, outs);
                    }
                    catch (FileNotFoundException e) {
                        XMPPOutgoingFileTransfer.this.setStatus(FileTransfer.Status.ERROR);
                        XMPPOutgoingFileTransfer.this.setException(e);
                    }
                    catch (XMPPException e) {
                        XMPPOutgoingFileTransfer.this.setStatus(FileTransfer.Status.ERROR);
                        XMPPOutgoingFileTransfer.this.setException((Exception)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    XMPPOutgoingFileTransfer.this.setStatus(FileTransfer.Status.COMPLETE);
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        outs.flush();
                        outs.close();
                    }
                    catch (IOException iOException) {}
                    XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new IOutgoingFileTransferSendDoneEvent(this){
                        private static final long serialVersionUID = -6315336868737148845L;
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public IOutgoingFileTransfer getSource() {
                            return 1.access$0(this.this$1);
                        }

                        public String toString() {
                            StringBuffer buf = new StringBuffer("IOutgoingFileTransferSendDoneEvent[");
                            buf.append("isDone=" + this.getSource().isDone());
                            buf.append(";bytesSent=").append(this.getSource().getBytesSent()).append("]");
                            return buf.toString();
                        }
                    });
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                }
                XMPPOutgoingFileTransfer.this.setStatus(FileTransfer.Status.COMPLETE);
                try {}
                catch (IOException iOException) {}
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                try {}
                catch (IOException iOException) {}
                outs.flush();
                outs.close();
                XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
            }

            static /* synthetic */ XMPPOutgoingFileTransfer access$0(1 var0) {
                return var0.XMPPOutgoingFileTransfer.this;
            }
        }, "ECF XMPP file send");
        transferThread.start();
    }

    public synchronized void cancel() {
        this.setStatus(FileTransfer.Status.CANCLED);
    }

    public synchronized File getLocalFile() {
        return this.localFile;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    public Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        return this.fileSize <= 0L ? 1.0 : (double)this.amountWritten / (double)this.fileSize;
    }

    public boolean isDone() {
        return this.status == FileTransfer.Status.CANCLED || this.status == FileTransfer.Status.ERROR || this.status == FileTransfer.Status.COMPLETE;
    }

    public ID getSessionID() {
        return this.sessionID;
    }

    protected void writeToStream(InputStream in, OutputStream out) throws XMPPException {
        byte[] b = new byte[4096];
        int count = 0;
        this.amountWritten = 0L;
        do {
            try {
                out.write(b, 0, count);
            }
            catch (IOException e) {
                throw new XMPPException("error writing to output stream", (Throwable)e);
            }
            this.amountWritten += (long)count;
            if (count > 0) {
                this.fireTransferListenerEvent((IFileTransferEvent)new IOutgoingFileTransferSendDataEvent(){
                    private static final long serialVersionUID = 2327297070577249812L;

                    public IOutgoingFileTransfer getSource() {
                        return XMPPOutgoingFileTransfer.this;
                    }

                    public String toString() {
                        StringBuffer buf = new StringBuffer("IOutgoingFileTransferSendDataEvent[");
                        buf.append("bytesSent=").append(this.getSource().getBytesSent());
                        buf.append(";percentComplete=").append(this.getSource().getPercentComplete()).append("]");
                        return buf.toString();
                    }
                });
            }
            try {
                count = in.read(b);
            }
            catch (IOException e) {
                throw new XMPPException("error reading from input stream", (Throwable)e);
            }
        } while (count != -1 && !this.getStatus().equals(FileTransfer.Status.CANCLED));
        if (!this.getStatus().equals(FileTransfer.Status.CANCLED) && this.amountWritten != this.fileSize) {
            this.setStatus(FileTransfer.Status.ERROR);
        }
    }

    public long getFileLength() {
        return this.fileSize;
    }
}

