/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterAccount;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterBuddy;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterGroup;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterObject;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterParent;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterUserAccount;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterView;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RosterViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private final RosterView rosterView;
    private RosterParent invisibleRoot;
    private RosterParent root;

    RosterViewContentProvider(RosterView rosterView) {
        this.rosterView = rosterView;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public RosterBuddy findBuddyWithUserID(ID userID) {
        return this.findBuddy(this.root, userID);
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.rosterView.getViewSite())) {
            if (this.root == null) {
                this.root = new RosterParent("Buddy List");
                this.invisibleRoot = new RosterParent("");
                this.invisibleRoot.addChild(this.root);
            }
            return this.getChildren(this.root);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof RosterObject) {
            return ((RosterObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof RosterParent) {
            return ((RosterParent)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof RosterParent) {
            return ((RosterParent)parent).hasChildren();
        }
        return false;
    }

    public RosterBuddy fillPresence(RosterBuddy obj, IPresence presence) {
        obj.setPresence(presence);
        obj.removeChildren();
        obj.addChild(new RosterObject("User: " + obj.getID().getName()));
        obj.addChild(new RosterObject("Type: " + presence.getType().toString()));
        String status = presence.getStatus();
        if (status != null && !status.equals("")) {
            obj.addChild(new RosterObject("Status: " + status));
        }
        Map props = presence.getProperties();
        Iterator i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)props.get(key);
            if (key == null || value == null) continue;
            obj.addChild(new RosterObject(String.valueOf(key) + ": " + value));
        }
        return obj;
    }

    public RosterBuddy createBuddy(ID svcID, RosterBuddy oldBuddy, IRosterEntry entry) {
        String name = entry.getName();
        if (name == null) {
            name = this.rosterView.getUserNameFromID(entry.getUser().getID());
        }
        name = name.replace('?', '\'');
        IPresence presence = entry.getPresence();
        RosterBuddy newBuddy = null;
        if (oldBuddy == null) {
            newBuddy = new RosterBuddy(svcID, name, entry.getUser().getID(), presence);
        } else {
            newBuddy = oldBuddy;
            if (entry.getName() != null) {
                newBuddy.setName(entry.getName());
            }
        }
        if (presence != null) {
            this.fillPresence(newBuddy, presence);
        }
        return newBuddy;
    }

    public RosterGroup findGroup(RosterParent parent, String name) {
        if (parent == null) {
            return null;
        }
        RosterObject[] objs = parent.getChildren();
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                if (objs[i].getName().equals(name)) {
                    return (RosterGroup)objs[i];
                }
                ++i;
            }
        }
        return null;
    }

    public RosterGroup findGroup(RosterParent parent, ID id) {
        if (parent == null) {
            return null;
        }
        RosterObject[] objs = parent.getChildren();
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                ID idd = objs[i].getID();
                if (id.equals((Object)idd)) {
                    return (RosterGroup)objs[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getAllGroupNamesForAccount(ID accountID) {
        RosterGroup accountRoot = this.findAccount(accountID);
        RosterObject[] objs = accountRoot.getChildren();
        if (objs != null) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < objs.length) {
                RosterObject o = objs[i];
                if (o instanceof RosterGroup) {
                    l.add(((RosterGroup)o).getName());
                }
                ++i;
            }
            return l.toArray(new String[0]);
        }
        return new String[0];
    }

    public RosterBuddy findBuddy(RosterParent parent, IRosterEntry entry) {
        return this.findBuddy(parent, entry.getUser().getID());
    }

    public RosterBuddy findBuddy(RosterParent parent, ID entryID) {
        if (parent == null) {
            return null;
        }
        RosterObject[] objs = parent.getChildren();
        if (objs == null) {
            return null;
        }
        int i = 0;
        while (i < objs.length) {
            RosterBuddy found;
            if (objs[i] instanceof RosterBuddy) {
                RosterBuddy tb = (RosterBuddy)objs[i];
                ID tbid = tb.getID();
                if (tbid != null && tbid.equals((Object)entryID)) {
                    RosterBuddy buddy = (RosterBuddy)objs[i];
                    buddy.setID(entryID);
                    return buddy;
                }
            } else if (objs[i] instanceof RosterGroup && (found = this.findBuddy((RosterParent)objs[i], entryID)) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public void replaceEntry(ID svcID, RosterParent parent, IRosterEntry entry) {
        RosterBuddy tb = this.findBuddy(parent, entry);
        RosterParent tp = null;
        if (tb != null && (tp = tb.getParent()) != null) {
            tp.removeChild(tb);
            if (tp.getName().equals("Buddies") && !tp.hasChildren()) {
                RosterParent tpp = tp.getParent();
                tpp.removeChild(tp);
            }
        }
        RosterBuddy newBuddy = this.createBuddy(svcID, tb, entry);
        if (tp != null) {
            tp.addChild(newBuddy);
        } else {
            Iterator groups = entry.getGroups().iterator();
            if (groups.hasNext()) {
                String groupName = ((IRosterGroup)groups.next()).getName();
                RosterGroup oldgrp = this.findGroup(parent, groupName);
                if (oldgrp != null) {
                    oldgrp.addChild(newBuddy);
                } else {
                    if (groupName.equals("")) {
                        groupName = "Buddies";
                    }
                    this.addBuddyWithGroupName(parent, parent.getID(), groupName, newBuddy);
                }
            } else {
                this.addBuddyWithGroupName(parent, parent.getID(), "Buddies", newBuddy);
            }
        }
    }

    protected void addBuddyWithGroupName(RosterParent parent, ID serviceID, String groupName, RosterBuddy newBuddy) {
        RosterGroup tg = this.findGroup(parent, groupName);
        if (tg == null) {
            tg = new RosterGroup(groupName, serviceID);
            tg.addChild(newBuddy);
            parent.addChild(tg);
        } else {
            tg.addChild(newBuddy);
        }
    }

    public void addAccount(ID accountID, String name) {
        RosterGroup oldgrp = this.findGroup(this.root, accountID);
        if (oldgrp != null) {
            return;
        }
        this.root.addChild(new RosterAccount(name, accountID));
    }

    protected RosterGroup findAccount(String accountName) {
        return this.findGroup(this.root, accountName);
    }

    protected RosterGroup findAccount(ID acct) {
        return this.findGroup(this.root, acct);
    }

    public void addGroup(ID svcID, String name) {
        RosterGroup accountRoot = this.findAccount(svcID);
        if (accountRoot != null) {
            this.addGroup(svcID, accountRoot, name);
        }
    }

    public void addGroup(ID svcID, RosterParent parent, String name) {
        RosterGroup oldgrp = this.findGroup(parent, name);
        if (oldgrp != null) {
            return;
        }
        RosterGroup newgrp = new RosterGroup(name, svcID);
        parent.addChild(newgrp);
    }

    public void removeGroup(RosterParent parent, String name) {
        RosterGroup oldgrp = this.findGroup(parent, name);
        if (oldgrp == null) {
            return;
        }
        parent.removeChild(oldgrp);
    }

    public void removeGroup(String name) {
        if (name == null) {
            return;
        }
        this.removeGroup(this.root, name);
    }

    public void handleRosterEntryUpdate(ID serviceID, IRosterEntry entry) {
        if (entry == null) {
            return;
        }
        RosterGroup tg = this.findAccount(serviceID.getName());
        this.replaceEntry(serviceID, tg, entry);
    }

    public void handlePresence(ID groupID, ID userID, IPresence presence) {
        RosterBuddy buddy = this.findBuddy((RosterParent)this.findAccount(groupID.getName()), userID);
        if (buddy != null) {
            this.fillPresence(buddy, presence);
        }
    }

    public void handleRosterEntryAdd(ID serviceID, IRosterEntry entry) {
        this.handleRosterEntryUpdate(serviceID, entry);
    }

    public void handleRosterEntryRemove(ID entry) {
        if (entry == null) {
            return;
        }
        RosterUserAccount ua = this.rosterView.getAccountForUser(entry);
        if (ua == null) {
            return;
        }
        ID svcID = ua.getServiceID();
        RosterGroup tg = this.findAccount(svcID.getName());
        this.removeEntry(tg, entry);
    }

    public void removeEntry(RosterParent parent, ID entry) {
        RosterBuddy buddy = this.findBuddy(parent, entry);
        if (buddy == null) {
            return;
        }
        RosterParent p = buddy.getParent();
        if (p != null) {
            p.removeChild(buddy);
            this.rosterView.refreshView();
        }
    }

    protected void removeChildren(RosterParent parent, ID svcID) {
        RosterObject[] childs = parent.getChildren();
        int i = 0;
        while (i < childs.length) {
            RosterGroup tg;
            ID id;
            if (childs[i] instanceof RosterParent) {
                this.removeChildren((RosterParent)childs[i], svcID);
            }
            if (childs[i] instanceof RosterBuddy) {
                RosterBuddy tb = (RosterBuddy)childs[i];
                id = tb.getServiceID();
                if (id.equals((Object)svcID)) {
                    parent.removeChild(tb);
                }
            } else if (childs[i] instanceof RosterGroup && (id = (tg = (RosterGroup)childs[i]).getID()).equals((Object)svcID)) {
                parent.removeChild(tg);
            }
            ++i;
        }
    }

    public void removeAllEntriesForAccount(RosterUserAccount account) {
        if (account == null) {
            this.root = null;
        } else {
            this.removeChildren(this.root, account.getServiceID());
        }
    }
}

