/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.hyperlink;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public abstract class AbstractURLHyperlinkDetector
extends AbstractHyperlinkDetector {
    public static final String DEFAULT_DETECTABLE = "://";
    public static final String DEFAULT_ENDDELIMITERS = " \t\n\r\f<>";
    String[] protocols = null;

    protected void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    protected String[] getProtocols() {
        return this.protocols;
    }

    protected IRegion detectSubRegion(IRegion lineInfo, String fromLine, int offsetInLine) {
        boolean startDoubleQuote = false;
        int detectableOffsetInLine = 0;
        int resultLength = 0;
        int separatorOffset = fromLine.indexOf(DEFAULT_DETECTABLE);
        while (separatorOffset >= 0) {
            char ch;
            detectableOffsetInLine = separatorOffset;
            do {
                ch = ' ';
                if (--detectableOffsetInLine > -1) {
                    ch = fromLine.charAt(detectableOffsetInLine);
                }
                boolean bl = startDoubleQuote = ch == '\"';
            } while (Character.isUnicodeIdentifierStart(ch));
            ++detectableOffsetInLine;
            StringTokenizer tokenizer = new StringTokenizer(fromLine.substring(separatorOffset + DEFAULT_DETECTABLE.length()), DEFAULT_ENDDELIMITERS, false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            resultLength = tokenizer.nextToken().length() + DEFAULT_DETECTABLE.length() + separatorOffset - detectableOffsetInLine;
            if (offsetInLine >= detectableOffsetInLine && offsetInLine <= detectableOffsetInLine + resultLength) break;
            separatorOffset = fromLine.indexOf(DEFAULT_DETECTABLE, separatorOffset + 1);
        }
        if (separatorOffset < 0) {
            return null;
        }
        if (startDoubleQuote) {
            int endOffset = -1;
            int nextDoubleQuote = fromLine.indexOf(34, detectableOffsetInLine);
            int nextWhitespace = fromLine.indexOf(32, detectableOffsetInLine);
            if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                endOffset = Math.min(nextDoubleQuote, nextWhitespace);
            } else if (nextDoubleQuote != -1) {
                endOffset = nextDoubleQuote;
            } else if (nextWhitespace != -1) {
                endOffset = nextWhitespace;
            }
            if (endOffset != -1) {
                resultLength = endOffset - detectableOffsetInLine;
            }
        }
        return new Region(lineInfo.getOffset() + detectableOffsetInLine, resultLength);
    }

    protected URI detectProtocol(String uriString) {
        String protocol;
        URI uri;
        block6: {
            if (uriString == null) {
                return null;
            }
            uri = null;
            uri = new URI(uriString);
            protocol = uri.getScheme();
            if (protocol != null && this.protocols != null) break block6;
            return null;
        }
        try {
            int i = 0;
            while (i < this.protocols.length) {
                if (this.protocols[i].equalsIgnoreCase(protocol)) {
                    return uri;
                }
                ++i;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return null;
    }

    protected abstract IHyperlink[] createHyperLinksForURI(IRegion var1, URI var2);

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (this.protocols == null) {
            return null;
        }
        int offset = region.getOffset();
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        IRegion detectedRegion = this.detectSubRegion(lineInfo, line, offset - lineInfo.getOffset());
        if (detectedRegion == null) {
            return null;
        }
        int detectedOffset = detectedRegion.getOffset() - lineInfo.getOffset();
        URI uri = this.detectProtocol(line.substring(detectedOffset, detectedOffset + detectedRegion.getLength()));
        if (uri == null) {
            return null;
        }
        return this.createHyperLinksForURI(detectedRegion, uri);
    }
}

