/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class Packet {
    public static final String ID_NOT_AVAILABLE = "ID_NOT_AVAILABLE";
    private static String prefix = String.valueOf(StringUtils.randomString(5)) + "-";
    private static long id = 0L;
    private String packetID = null;
    private String to = null;
    private String from = null;
    private List packetExtensions = null;
    private Map properties = null;
    private XMPPError error = null;

    private static synchronized String nextID() {
        return String.valueOf(prefix) + Long.toString(id++);
    }

    public String getPacketID() {
        if (ID_NOT_AVAILABLE.equals(this.packetID)) {
            return null;
        }
        if (this.packetID == null) {
            this.packetID = Packet.nextID();
        }
        return this.packetID;
    }

    public void setPacketID(String packetID) {
        this.packetID = packetID;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError error) {
        this.error = error;
    }

    public synchronized Iterator getExtensions() {
        if (this.packetExtensions == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableList(new ArrayList(this.packetExtensions)).iterator();
    }

    public synchronized PacketExtension getExtension(String elementName, String namespace) {
        if (this.packetExtensions == null || elementName == null || namespace == null) {
            return null;
        }
        Iterator i = this.packetExtensions.iterator();
        while (i.hasNext()) {
            PacketExtension ext = (PacketExtension)i.next();
            if (!elementName.equals(ext.getElementName()) || !namespace.equals(ext.getNamespace())) continue;
            return ext;
        }
        return null;
    }

    public synchronized void addExtension(PacketExtension extension) {
        if (this.packetExtensions == null) {
            this.packetExtensions = new ArrayList();
        }
        this.packetExtensions.add(extension);
    }

    public synchronized void removeExtension(PacketExtension extension) {
        if (this.packetExtensions != null) {
            this.packetExtensions.remove(extension);
        }
    }

    public synchronized Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, new Integer(value));
    }

    public void setProperty(String name, long value) {
        this.setProperty(name, new Long(value));
    }

    public void setProperty(String name, float value) {
        this.setProperty(name, new Float(value));
    }

    public void setProperty(String name, double value) {
        this.setProperty(name, new Double(value));
    }

    public void setProperty(String name, boolean value) {
        this.setProperty(name, new Boolean(value));
    }

    public synchronized void setProperty(String name, Object value) {
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Value must be serialiazble");
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public synchronized void deleteProperty(String name) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(name);
    }

    public synchronized Iterator getPropertyNames() {
        if (this.properties == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.properties.keySet().iterator();
    }

    public abstract String toXML();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized String getExtensionsXML() {
        StringBuffer buf = new StringBuffer();
        Iterator extensions = this.getExtensions();
        while (true) {
            if (!extensions.hasNext()) break;
            PacketExtension extension = (PacketExtension)extensions.next();
            buf.append(extension.toXML());
        }
        if (this.properties == null) return buf.toString();
        if (this.properties.isEmpty()) return buf.toString();
        buf.append("<properties xmlns=\"http://www.jivesoftware.com/xmlns/xmpp/properties\">");
        Iterator i = this.getPropertyNames();
        while (true) {
            block18: {
                ByteArrayOutputStream byteStream;
                block17: {
                    Object var9_10;
                    Object value;
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            if (!i.hasNext()) {
                                                buf.append("</properties>");
                                                return buf.toString();
                                            }
                                            String name = (String)i.next();
                                            value = this.getProperty(name);
                                            buf.append("<property>");
                                            buf.append("<name>").append(StringUtils.escapeForXML(name)).append("</name>");
                                            buf.append("<value type=\"");
                                            if (!(value instanceof Integer)) break block19;
                                            buf.append("integer\">").append(value).append("</value>");
                                            break block18;
                                        }
                                        if (!(value instanceof Long)) break block20;
                                        buf.append("long\">").append(value).append("</value>");
                                        break block18;
                                    }
                                    if (!(value instanceof Float)) break block21;
                                    buf.append("float\">").append(value).append("</value>");
                                    break block18;
                                }
                                if (!(value instanceof Double)) break block22;
                                buf.append("double\">").append(value).append("</value>");
                                break block18;
                            }
                            if (!(value instanceof Boolean)) break block23;
                            buf.append("boolean\">").append(value).append("</value>");
                            break block18;
                        }
                        if (!(value instanceof String)) break block24;
                        buf.append("string\">");
                        buf.append(StringUtils.escapeForXML((String)value));
                        buf.append("</value>");
                        break block18;
                    }
                    byteStream = null;
                    ObjectOutputStream out = null;
                    try {
                        try {
                            byteStream = new ByteArrayOutputStream();
                            out = new ObjectOutputStream(byteStream);
                            out.writeObject(value);
                            buf.append("java-object\">");
                            String encodedVal = StringUtils.encodeBase64(byteStream.toByteArray());
                            buf.append(encodedVal).append("</value>");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (byteStream == null) throw throwable;
                        try {
                            byteStream.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    {
                        var9_10 = null;
                        if (out == null) break block17;
                    }
                    try {}
                    catch (Exception exception) {}
                    out.close();
                }
                if (byteStream != null) {
                    try {}
                    catch (Exception exception) {}
                    byteStream.close();
                }
            }
            buf.append("</property>");
        }
    }
}

