/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.impl.AuthenticatedURL;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ServiceURL
extends AuthenticatedURL
implements Serializable {
    private static final long serialVersionUID = 9181946114021582389L;
    public static final int NO_PORT = 0;
    public static final int LIFETIME_NONE = 0;
    public static final int LIFETIME_DEFAULT = 10800;
    public static final int LIFETIME_MAXIMUM = 65535;
    public static final int LIFETIME_PERMANENT = -1;
    private String url = null;
    private int lifetime = 0;
    private ServiceType type = null;
    private String host = null;
    private String protocol = null;
    private int port = 0;
    private String path = null;

    private ServiceURL() {
    }

    public ServiceURL(String string, int n) throws ServiceLocationException {
        this.url = string;
        this.lifetime = n;
        try {
            this.parse();
        }
        catch (Exception exception) {
            throw new ServiceLocationException(2, "service url is malformed: [" + this.url + "]. ");
        }
    }

    private void parse() {
        int n;
        int n2;
        int n3 = this.url.indexOf("://");
        this.type = new ServiceType(this.url.substring(0, n3++));
        int n4 = this.url.indexOf("://", n3 + 1);
        if (n4 > -1) {
            this.protocol = this.url.substring(n3 + 2, n4);
            n3 = n4 + 1;
        }
        if ((n2 = this.url.indexOf(":", n3 + 2)) == -1) {
            this.port = 0;
            n = n2 = this.url.indexOf("/", n3 + 2);
        } else {
            n = this.url.indexOf("/", n2 + 1);
            this.port = n == -1 ? Integer.parseInt(this.url.substring(n2 + 1)) : Integer.parseInt(this.url.substring(n2 + 1, n));
        }
        this.host = n2 == -1 ? this.url.substring(n3 + 2) : this.url.substring(n3 + 2, n2);
        this.path = n == -1 ? "" : this.url.substring(n);
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceURL) {
            ServiceURL serviceURL = (ServiceURL)object;
            return this.type.equals(serviceURL.type) && this.host.equals(serviceURL.host) && this.port == serviceURL.port && (this.protocol == null && serviceURL.protocol == null || this.protocol.equals(serviceURL.protocol)) && this.path.equals(serviceURL.path);
        }
        return false;
    }

    public boolean matches(Object object) {
        if (object instanceof ServiceURL) {
            return this.equals(object);
        }
        if (object instanceof ServiceType) {
            return this.type.matches(object);
        }
        return false;
    }

    public String toString() {
        return this.type.toString() + "://" + (this.protocol != null ? this.protocol + "://" : "") + this.host + (this.port != 0 ? ":" + this.port : "") + this.path;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public ServiceType getServiceType() {
        return this.type;
    }

    public String getTransport() {
        return "";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.path;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(0);
        dataOutputStream.writeShort((short)this.lifetime);
        dataOutputStream.writeUTF(this.toString());
        this.writeAuthBlock(dataOutputStream);
    }

    public int getLength() {
        return 5 + this.toString().length() + this.getAuthBlockLength();
    }

    public static ServiceURL fromBytes(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        ServiceURL serviceURL = new ServiceURL();
        dataInputStream.readByte();
        serviceURL.lifetime = dataInputStream.readShort();
        serviceURL.url = dataInputStream.readUTF();
        serviceURL.authBlocks = AuthenticatedURL.parseAuthBlock(dataInputStream);
        serviceURL.parse();
        return serviceURL;
    }
}

