/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.editor.listeners;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelEvent;
import org.eclipse.ecf.datashare.events.IChannelMessageEvent;
import org.eclipse.ecf.example.collab.editor.Activator;
import org.eclipse.ecf.example.collab.editor.listeners.EditorListener;
import org.eclipse.ecf.example.collab.editor.message.EditorChangeMessage;
import org.eclipse.ecf.example.collab.editor.message.EditorUpdateRequest;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EditChannelListener
implements IChannelListener {
    private IDocument document;
    private AbstractTextEditor editor;
    private StyledText textControl;
    private boolean documentOwner;
    private EditorListener editorListener;
    static /* synthetic */ Class class$0;

    public EditChannelListener(IDocument document, AbstractTextEditor editor, boolean owner, EditorListener editorListener) {
        this.document = document;
        this.editor = editor;
        this.editorListener = editorListener;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.textControl = (StyledText)editor.getAdapter((Class)clazz);
        this.documentOwner = owner;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleChannelEvent(IChannelEvent event) {
        if (!(event instanceof IChannelMessageEvent)) return;
        this.setEditorEditable(false);
        Activator.getDefault().setListenerActive(false);
        IChannelMessageEvent msg = (IChannelMessageEvent)event;
        ByteArrayInputStream bins = new ByteArrayInputStream(msg.getData());
        try {
            try {
                ObjectInputStream ois = new ObjectInputStream(bins);
                Object message = ois.readObject();
                if (message instanceof EditorChangeMessage) {
                    this.appendLocallyFromRemote((EditorChangeMessage)message);
                } else if (message instanceof EditorUpdateRequest && this.documentOwner) {
                    this.editorListener.sendDocumentUpdateMessage();
                }
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
            }
            catch (ClassNotFoundException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.setEditorEditable(true);
            Activator.getDefault().setListenerActive(true);
            throw throwable;
        }
        {
            Object var6_10 = null;
            this.setEditorEditable(true);
            Activator.getDefault().setListenerActive(true);
            return;
        }
    }

    protected void appendLocallyFromRemote(final EditorChangeMessage message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (message.getDocument().equals(EditChannelListener.this.document.get())) {
                    return;
                }
                ISelection selection = EditChannelListener.this.editor.getSelectionProvider().getSelection();
                if (selection instanceof TextSelection) {
                    TextSelection textSelection = (TextSelection)selection;
                    EditChannelListener.this.document.set(message.getDocument());
                    EditChannelListener.this.editor.selectAndReveal(textSelection.getOffset(), 0);
                }
            }
        });
    }

    private void setEditorEditable(final boolean editable) {
        if (!this.textControl.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    EditChannelListener.this.textControl.setEditable(editable);
                }
            });
        }
    }
}

