/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.editor.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.example.collab.editor.Activator;
import org.eclipse.ecf.example.collab.editor.listeners.EditorListener;
import org.eclipse.ecf.example.collab.editor.wizards.NewSharedSessionWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class NewSharedSessionWizard
extends Wizard
implements INewWizard {
    private NewSharedSessionWizardPage page;
    private ISelection selection;

    public NewSharedSessionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewSharedSessionWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewSharedSessionWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    if (editorPart instanceof AbstractTextEditor) {
                        IDocumentProvider dp = DocumentProviderRegistry.getDefault().getDocumentProvider(editorPart.getEditorInput());
                        AbstractTextEditor textEditor = (AbstractTextEditor)editorPart;
                        IDocument document = dp.getDocument((Object)editorPart.getEditorInput());
                        if (document != null) {
                            EditorListener listener = new EditorListener(document, textEditor, false);
                            document.addDocumentListener((IDocumentListener)listener);
                        } else {
                            if (dp instanceof TextFileDocumentProvider) {
                                ((TextFileDocumentProvider)dp).connect((Object)editorPart.getEditorInput());
                                document = ((TextFileDocumentProvider)dp).getDocument((Object)editorPart.getEditorInput());
                                if (document != null) {
                                    EditorListener listener = new EditorListener(document, textEditor, false);
                                    document.addDocumentListener((IDocumentListener)listener);
                                    return;
                                }
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, "Unable to get reference to editor's document.  Shared session not created.", null));
                            }
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, "Unable to get reference to editor's document.  Shared session not created.", null));
                        }
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String contents = "";
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.ecf.example.collab.editor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

