/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.editor.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelEvent;
import org.eclipse.ecf.datashare.events.IChannelMessageEvent;
import org.eclipse.ecf.example.collab.editor.Activator;
import org.eclipse.ecf.example.collab.editor.message.SharedEditorSessionList;
import org.eclipse.ecf.example.collab.editor.message.SharedEditorSessionListRequest;
import org.eclipse.ecf.example.collab.editor.model.SessionInstance;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewSharedSessionWizardPage
extends WizardPage {
    private Text containerText;
    private ISelection selection;
    private TableViewer sessionViewer;
    private List sessions;

    public NewSharedSessionWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Shared Editor");
        this.setDescription("Connect to a live shared editor session.");
        this.selection = selection;
        this.sessions = new ArrayList();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 0);
        label.setText("&Project:");
        this.containerText = new Text(main, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSharedSessionWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(main, 8);
        button.setText("Browse...");
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSharedSessionWizardPage.this.handleBrowse();
            }
        });
        Label label2 = new Label(main, 0);
        label2.setText("&Shared File:");
        label2.setLayoutData((Object)new GridData(2));
        this.sessionViewer = new TableViewer(main, 67584);
        this.sessionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.sessionViewer.setLabelProvider((IBaseLabelProvider)new SessionNameLabelProvider());
        this.sessionViewer.setInput((Object)this.sessions);
        GridData gData = new GridData(768);
        gData.heightHint = 120;
        this.sessionViewer.getTable().setLayoutData((Object)gData);
        this.sessionViewer.getTable().setHeaderVisible(true);
        this.sessionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewSharedSessionWizardPage.this.dialogChanged();
            }
        });
        TableColumn tc = new TableColumn(this.sessionViewer.getTable(), 0);
        tc.setText("Filename");
        tc.setWidth(140);
        tc = new TableColumn(this.sessionViewer.getTable(), 0);
        tc.setText("Owner");
        tc.setWidth(120);
        tc = new TableColumn(this.sessionViewer.getTable(), 0);
        tc.setText("Shared On");
        tc.setWidth(140);
        Button refreshButton = new Button(main, 0);
        refreshButton.setText("Refresh");
        refreshButton.setLayoutData((Object)new GridData(770));
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewSharedSessionWizardPage.this.sendSessionListRequestMessage();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)main);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.sendSessionListRequestMessage();
    }

    private void sendSessionListRequestMessage() {
        try {
            IChannel channel = Activator.getDefault().intializePresenceSession(new SessionResponseListener());
            channel.sendMessage(new SharedEditorSessionListRequest().toByteArray());
        }
        catch (ECFException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName == null || fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        if (!this.sessionViewer.getSelection().isEmpty()) {
            StructuredSelection s = (StructuredSelection)this.sessionViewer.getSelection();
            SessionInstance si = (SessionInstance)s.getFirstElement();
            return si.getName();
        }
        return null;
    }

    static /* synthetic */ TableViewer access$1(NewSharedSessionWizardPage newSharedSessionWizardPage) {
        return newSharedSessionWizardPage.sessionViewer;
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SessionNameLabelProvider
    implements ITableLabelProvider {
        private SessionNameLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text;
            SessionInstance instance = (SessionInstance)element;
            switch (columnIndex) {
                case 0: {
                    text = instance.getName();
                    break;
                }
                case 1: {
                    text = instance.getOwner();
                    break;
                }
                case 2: {
                    DateFormat df = DateFormat.getInstance();
                    df.setTimeZone(TimeZone.getTimeZone("GMT"));
                    text = df.format(instance.getCreated());
                    break;
                }
                default: {
                    text = "";
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class SessionResponseListener
    implements IChannelListener {
        private SessionResponseListener() {
        }

        public void handleChannelEvent(IChannelEvent event) {
            if (event instanceof IChannelMessageEvent) {
                IChannelMessageEvent msg = (IChannelMessageEvent)event;
                ByteArrayInputStream bins = new ByteArrayInputStream(msg.getData());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bins);
                    Object o = ois.readObject();
                    if (o instanceof SharedEditorSessionList) {
                        SharedEditorSessionList l = (SharedEditorSessionList)o;
                        Iterator i = l.getNames().iterator();
                        while (i.hasNext()) {
                            Object element = i.next();
                            if (NewSharedSessionWizardPage.this.sessions.contains(element)) continue;
                            NewSharedSessionWizardPage.this.sessions.add(element);
                        }
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                            final /* synthetic */ SessionResponseListener this$1;
                            {
                                this.this$1 = sessionResponseListener;
                            }

                            public void run() {
                                if (!NewSharedSessionWizardPage.access$1(SessionResponseListener.access$1(this.this$1)).getTable().isDisposed()) {
                                    NewSharedSessionWizardPage.access$1(SessionResponseListener.access$1(this.this$1)).refresh();
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
                }
                catch (ClassNotFoundException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab.editor", 0, e.getLocalizedMessage(), (Throwable)e));
                }
            }
        }

        static /* synthetic */ NewSharedSessionWizardPage access$1(SessionResponseListener sessionResponseListener) {
            return sessionResponseListener.NewSharedSessionWizardPage.this;
        }
    }
}

