/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.util.List;
import org.eclipse.ecf.example.collab.share.User;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.ui.ChatComposite;
import org.eclipse.ecf.internal.example.collab.ui.ChatLine;
import org.eclipse.ecf.internal.example.collab.ui.ChatWindow;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

class TeamChat
extends Composite {
    ChatComposite chat = null;
    SashForm sash = null;
    TableViewer tableView = null;
    ToolBar bar;
    LineChatClientView view;
    ChatWindow chatWindow;
    static final int DEFAULT_TREE_WIDGET_PERCENT = 15;

    TeamChat(LineChatClientView view, Composite parent, int options, String initText) {
        super(parent, options);
        this.view = view;
        this.setLayout((Layout)new FillLayout());
        boolean useChatWindow = ClientPlugin.getDefault().getPluginPreferences().getBoolean("useChatWindow");
        int[] w = null;
        if (!useChatWindow) {
            this.sash = new SashForm((Composite)this, 0);
            this.sash.setLayout((Layout)new FillLayout());
            this.sash.setOrientation(256);
            w = new int[]{15, 100 - w[0]};
        }
        this.tableView = new TableViewer((Composite)(useChatWindow ? this : this.sash), 2818);
        this.tableView.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableView.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        if (useChatWindow) {
            this.chatWindow = new ChatWindow(view, this.tableView, initText);
            this.chatWindow.create();
            this.chat = this.chatWindow.getChat();
        } else {
            this.chat = new ChatComposite(view, (Composite)this.sash, this.tableView, initText);
            this.sash.setWeights(w);
        }
    }

    void appendText(ChatLine text) {
        if (this.chatWindow != null && this.chatWindow.getShell() != null && !this.chatWindow.getShell().isDisposed() && !this.chatWindow.hasFocus()) {
            if (this.chatWindow.getShell().isVisible()) {
                this.chatWindow.flash();
            } else {
                this.chatWindow.open();
            }
        }
        this.chat.appendText(text);
        this.setStatus(null);
    }

    void setStatus(String status) {
        if (this.chatWindow != null) {
            this.chatWindow.setStatus(status);
        }
    }

    void clearInput() {
        this.chat.clearInput();
    }

    TableViewer getTableViewer() {
        return this.tableView;
    }

    Control getTreeControl() {
        return this.tableView.getControl();
    }

    Control getTextControl() {
        return this.chat.getTextControl();
    }

    public void dispose() {
        if (this.chatWindow != null) {
            this.chatWindow.close();
            this.chatWindow = null;
        }
        super.dispose();
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((List)parent).toArray();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }

    private class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public Image getImage(Object obj) {
            return obj instanceof User ? SharedImages.getImage((String)"IMG_USER_AVAILABLE") : null;
        }
    }
}

