/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.screencapture;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.ui.screencapture.IImageSender;
import org.eclipse.ecf.ui.screencapture.ScreenCaptureConfirmationDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class ScreenCaptureJob
extends UIJob {
    final Color blackColor;
    final Color whiteColor;
    boolean isDragging = false;
    int downX = -1;
    int downY = -1;
    final IImageSender imageSender;
    final ID targetID;
    final String nickName;

    public ScreenCaptureJob(Display display, ID targetID, String nickName, IImageSender imageSender) {
        super(display, "Capturing screen...");
        this.blackColor = new Color((Device)display, 0, 0, 0);
        this.whiteColor = new Color((Device)display, 255, 255, 255);
        this.targetID = targetID;
        this.nickName = nickName;
        this.imageSender = imageSender;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        final Display display = this.getDisplay();
        GC context = new GC((Drawable)display);
        Rectangle displayBounds = display.getBounds();
        final Image image = new Image((Device)display, displayBounds);
        context.copyArea(image, displayBounds.x, displayBounds.y);
        context.dispose();
        final Shell shell = new Shell(display, 8);
        shell.setLayout((Layout)new FillLayout());
        shell.setBounds(displayBounds);
        final GC gc = new GC((Drawable)shell);
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                gc.drawImage(image, 0, 0);
            }
        });
        shell.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    shell.close();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    shell.close();
                }
            }
        });
        shell.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ScreenCaptureJob.this.isDragging = true;
                ScreenCaptureJob.this.downX = e.x;
                ScreenCaptureJob.this.downY = e.y;
            }

            public void mouseUp(MouseEvent e) {
                ScreenCaptureJob.this.isDragging = false;
                int width = Math.max(ScreenCaptureJob.this.downX, e.x) - Math.min(ScreenCaptureJob.this.downX, e.x);
                int height = Math.max(ScreenCaptureJob.this.downY, e.y) - Math.min(ScreenCaptureJob.this.downY, e.y);
                if (width != 0 && height != 0) {
                    Image copy = new Image((Device)display, width, height);
                    gc.copyArea(copy, Math.min(ScreenCaptureJob.this.downX, e.x), Math.min(ScreenCaptureJob.this.downY, e.y));
                    ScreenCaptureJob.this.blackColor.dispose();
                    ScreenCaptureJob.this.whiteColor.dispose();
                    ScreenCaptureConfirmationDialog dialog = new ScreenCaptureConfirmationDialog(shell, ScreenCaptureJob.this.targetID, ScreenCaptureJob.this.nickName, copy, width, height, ScreenCaptureJob.this.imageSender);
                    dialog.open();
                    shell.close();
                    image.dispose();
                }
            }
        });
        shell.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ScreenCaptureJob.this.isDragging) {
                    gc.drawImage(image, 0, 0);
                    gc.setForeground(ScreenCaptureJob.this.blackColor);
                    gc.drawRectangle(ScreenCaptureJob.this.downX, ScreenCaptureJob.this.downY, e.x - ScreenCaptureJob.this.downX, e.y - ScreenCaptureJob.this.downY);
                    gc.setForeground(ScreenCaptureJob.this.whiteColor);
                    gc.drawRectangle(ScreenCaptureJob.this.downX - 1, ScreenCaptureJob.this.downY - 1, e.x - ScreenCaptureJob.this.downX + 2, e.y - ScreenCaptureJob.this.downY + 2);
                }
            }
        });
        shell.setCursor(new Cursor((Device)this.getDisplay(), 2));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return Status.OK_STATUS;
    }
}

