/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.provider.irc.Messages;
import org.eclipse.ecf.internal.provider.irc.identity.IRCID;
import org.eclipse.osgi.util.NLS;

public class IRCNamespace
extends Namespace {
    private static final long serialVersionUID = 1005111581522377553L;
    public static final String IRC_PROTOCOL = "irc";
    static /* synthetic */ Class class$0;

    private String getProtocolPrefix() {
        return String.valueOf(this.getScheme()) + "://";
    }

    public ID createInstance(Object[] args) throws IDCreateException {
        URI newURI = null;
        String s = null;
        try {
            s = (String)args[0];
        }
        catch (ClassCastException classCastException) {
            throw new IDCreateException(NLS.bind((String)Messages.IRCNamespace_EXCEPTION_CREATE_CANNOT_CAST_TO_STRING, (Object)args[0]));
        }
        if (!s.startsWith(this.getProtocolPrefix())) {
            s = String.valueOf(this.getProtocolPrefix()) + s;
        }
        try {
            newURI = this.createURI(s);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IDCreateException(NLS.bind((String)Messages.IRCNamespace_EXCEPTION_CREATING_URI, (Object)s));
        }
        String uriScheme = newURI.getScheme();
        if (uriScheme == null || !uriScheme.equalsIgnoreCase(this.getScheme())) {
            throw new IDCreateException(NLS.bind((String)Messages.IRCNamespace_EXCEPTION_INVALID_PROTOCOL, (Object)newURI, (Object)IRC_PROTOCOL));
        }
        return new IRCID(this, newURI);
    }

    private URI createURI(String s) throws IDCreateException, URISyntaxException {
        URI ret = null;
        String uname = s.substring(this.getProtocolPrefix().length(), s.indexOf("@"));
        int hostend = s.lastIndexOf("/");
        int hoststart = s.indexOf("@");
        if (hoststart > hostend || hostend == -1) {
            hostend = s.length();
        }
        String host = s.substring(hoststart + 1, hostend);
        int port = -1;
        int portidx = host.indexOf(":");
        if (portidx >= 0) {
            port = Integer.parseInt(host.substring(portidx + 1, host.length()));
            host = host.substring(0, portidx);
        }
        String path = s.substring(hostend, s.length());
        ret = new URI(this.getScheme(), uname, host, port, path, null, null);
        return ret;
    }

    public String getScheme() {
        return IRC_PROTOCOL;
    }

    public Class[][] getSupportedParameterTypes() {
        Class[][] classArray = new Class[1][];
        Class[] classArray2 = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz;
        classArray[0] = classArray2;
        return classArray;
    }
}

