/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl.filter;

import ch.ethz.iks.slp.impl.filter.Filter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public final class RFC1960Filter
implements Filter {
    private static final int AND_OPERATOR = 1;
    private static final int OR_OPERATOR = 2;
    private static final int NOT_OPERATOR = 3;
    private static final int EQUALS = 0;
    private static final int PRESENT = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final String[] OP = new String[]{"=", "=*", "~=", ">=", "<="};
    private static final Class[] STRINGCLASS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RFC1960Filter.class$("java.lang.String")) : class$java$lang$String};
    private static final Filter NULL_FILTER = new Filter(){

        public boolean match(Dictionary dictionary) {
            return true;
        }

        public String toString() {
            return "";
        }
    };
    private List operands = new ArrayList(1);
    private int operator;
    static /* synthetic */ Class class$java$lang$String;

    private RFC1960Filter(int n) {
        this.operator = n;
    }

    public static Filter fromString(String string) {
        if (string == null || "".equals(string)) {
            return NULL_FILTER;
        }
        Stack<RFC1960Filter> stack = new Stack<RFC1960Filter>();
        try {
            int n = string.length();
            int n2 = -1;
            int n3 = 0;
            String string2 = null;
            int n4 = -1;
            char[] cArray = string.toCharArray();
            stack.clear();
            block10: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '(': {
                        char c = cArray[i + 1];
                        if (c == '&') {
                            stack.push(new RFC1960Filter(1));
                            continue block10;
                        }
                        if (c == '|') {
                            stack.push(new RFC1960Filter(2));
                            continue block10;
                        }
                        if (c == '!') {
                            stack.push(new RFC1960Filter(3));
                            continue block10;
                        }
                        if (n2 == -1) {
                            n2 = i;
                            continue block10;
                        }
                        throw new IllegalStateException("Surplus left paranthesis at: " + string.substring(i));
                    }
                    case ')': {
                        Object object;
                        Object object2;
                        if (n2 == -1) {
                            object2 = (RFC1960Filter)stack.pop();
                            if (stack.isEmpty()) {
                                return object2;
                            }
                            object = (RFC1960Filter)stack.peek();
                            if (((RFC1960Filter)object).operator == 3 && !((RFC1960Filter)object).operands.isEmpty()) {
                                throw new IllegalStateException("Unexpected literal: " + string.substring(i));
                            }
                            ((RFC1960Filter)object).operands.add(object2);
                            if (i != n - 1) continue block10;
                            throw new IllegalStateException("Missing right paranthesis at the end.");
                        }
                        if (n3 == 0) {
                            throw new IllegalStateException("Missing operator.");
                        }
                        if (stack.isEmpty()) {
                            if (i == n - 1) {
                                if (((String)(object2 = string.substring(++n3, n - 1))).equals("*") && n4 == 0) {
                                    n4 = 1;
                                    object2 = null;
                                }
                                return new RFC1960SimpleFilter(string2, n4, (String)object2);
                            }
                            throw new IllegalStateException("Unexpected literal: " + string.substring(i));
                        }
                        object2 = (RFC1960Filter)stack.peek();
                        if (((String)(object = string.substring(++n3, i))).equals("*") && n4 == 0) {
                            n4 = 1;
                            object = null;
                        }
                        ((RFC1960Filter)object2).operands.add(new RFC1960SimpleFilter(string2, n4, (String)object));
                        n3 = 0;
                        n2 = -1;
                        string2 = null;
                        n4 = -1;
                        continue block10;
                    }
                    case '~': {
                        if (n3 == 0 && cArray[i + 1] == '=') {
                            string2 = string.substring(n2 + 1, i).trim();
                            n4 = 2;
                            n3 = ++i;
                            continue block10;
                        }
                        throw new IllegalStateException("Unexpected character " + cArray[i + 1]);
                    }
                    case '>': {
                        if (n3 == 0 && cArray[i + 1] == '=') {
                            string2 = string.substring(n2 + 1, i).trim();
                            n4 = 3;
                            n3 = ++i;
                            continue block10;
                        }
                        throw new IllegalStateException("Unexpected character " + cArray[i + 1]);
                    }
                    case '<': {
                        if (n3 == 0 && cArray[i + 1] == '=') {
                            string2 = string.substring(n2 + 1, i).trim();
                            n4 = 4;
                            n3 = ++i;
                            continue block10;
                        }
                        throw new IllegalStateException("Unexpected character " + cArray[i + 1]);
                    }
                    case '=': {
                        string2 = string.substring(n2 + 1, i).trim();
                        n4 = 0;
                        n3 = i;
                        continue block10;
                    }
                }
            }
            return (RFC1960Filter)stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new IllegalStateException("Filter expression not well-formed.");
        }
    }

    public boolean match(Dictionary dictionary) {
        if (this.operator == 1) {
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (filterArray[i].match(dictionary)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == 2) {
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].match(dictionary)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == 3) {
            return !((Filter)this.operands.get(0)).match(dictionary);
        }
        throw new IllegalStateException("PARSER ERROR");
    }

    public String toString() {
        if (this.operator == 3) {
            return "(!" + this.operands.get(0) + ")";
        }
        StringBuffer stringBuffer = new StringBuffer(this.operator == 1 ? "(&" : "(|");
        Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
        for (int i = 0; i < filterArray.length; ++i) {
            stringBuffer.append(filterArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof RFC1960Filter) {
            RFC1960Filter rFC1960Filter = (RFC1960Filter)object;
            if (this.operands.size() != rFC1960Filter.operands.size()) {
                return false;
            }
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            Filter[] filterArray2 = rFC1960Filter.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (filterArray[i].equals(filterArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class RFC1960SimpleFilter
    implements Filter {
        private final String id;
        private final int comparator;
        private final String value;

        private RFC1960SimpleFilter(String string, int n, String string2) {
            this.id = string;
            this.comparator = n;
            this.value = string2;
        }

        public boolean match(Dictionary dictionary) {
            Object object;
            Enumeration enumeration;
            Object var2_2 = null;
            var2_2 = dictionary.get(this.id);
            if (var2_2 == null) {
                var2_2 = dictionary.get(this.id.toLowerCase());
            }
            if (var2_2 == null) {
                enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String[])enumeration.nextElement();
                    if (!((String)object).equalsIgnoreCase(this.id)) continue;
                    var2_2 = dictionary.get(object);
                    break;
                }
            }
            if (var2_2 == null) {
                return false;
            }
            if (this.comparator == 1) {
                return true;
            }
            enumeration = var2_2;
            try {
                if (enumeration instanceof String) {
                    return RFC1960SimpleFilter.compareString(this.value, this.comparator, (String)((Object)enumeration));
                }
                if (enumeration instanceof Number) {
                    return RFC1960SimpleFilter.compareNumber(this.value, this.comparator, (Number)((Object)enumeration));
                }
                if (enumeration instanceof String[]) {
                    object = (String[])enumeration;
                    if (((String[])object).length == 0) {
                        return false;
                    }
                    String string = this.comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(this.value) : this.value;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (!RFC1960SimpleFilter.compareString(string, this.comparator, (String)object[i])) continue;
                        return true;
                    }
                    return false;
                }
                if (enumeration instanceof Boolean) {
                    return (this.comparator == 0 || this.comparator == 2) && ((Boolean)((Object)enumeration)).equals(Boolean.valueOf(this.value));
                }
                if (enumeration instanceof Character) {
                    return this.value.length() == 1 ? RFC1960SimpleFilter.compareTyped(new Character(this.value.charAt(0)), this.comparator, (Character)((Object)enumeration)) : false;
                }
                if (enumeration instanceof Vector) {
                    object = (Vector)((Object)enumeration);
                    Object[] objectArray = new Object[((Vector)object).size()];
                    ((Vector)object).copyInto(objectArray);
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, objectArray);
                }
                if (enumeration instanceof Object[]) {
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, (Object[])enumeration);
                }
                if (enumeration.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(enumeration); ++i) {
                        Object object2 = Array.get(enumeration, i);
                        if ((!(object2 instanceof Number) || !RFC1960SimpleFilter.compareNumber(this.value, this.comparator, (Number)object2)) && (!(object2 instanceof Comparable) || !RFC1960SimpleFilter.compareReflective(this.value, this.comparator, (Comparable)object2))) continue;
                        return true;
                    }
                    return false;
                }
                if (enumeration instanceof Comparable) {
                    return RFC1960SimpleFilter.compareReflective(this.value, this.comparator, (Comparable)((Object)enumeration));
                }
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        private static boolean compareString(String string, int n, String string2) {
            String string3 = n == 2 ? RFC1960SimpleFilter.stripWhitespaces(string) : string;
            String string4 = n == 2 ? RFC1960SimpleFilter.stripWhitespaces(string2) : string2;
            switch (n) {
                case 0: 
                case 2: {
                    return RFC1960SimpleFilter.stringCompare(string3.toCharArray(), 0, string4.toCharArray(), 0) == 0;
                }
                case 3: {
                    return RFC1960SimpleFilter.stringCompare(string3.toCharArray(), 0, string4.toCharArray(), 0) <= 0;
                }
                case 4: {
                    return RFC1960SimpleFilter.stringCompare(string3.toCharArray(), 0, string4.toCharArray(), 0) >= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareNumber(String string, int n, Number number) {
            if (number instanceof Integer) {
                int n2 = (Integer)number;
                int n3 = Integer.parseInt(string);
                switch (n) {
                    case 3: {
                        return n2 >= n3;
                    }
                    case 4: {
                        return n2 <= n3;
                    }
                }
                return n2 == n3;
            }
            if (number instanceof Long) {
                long l = (Long)number;
                long l2 = Long.parseLong(string);
                switch (n) {
                    case 3: {
                        return l >= l2;
                    }
                    case 4: {
                        return l <= l2;
                    }
                }
                return l == l2;
            }
            if (number instanceof Short) {
                short s = (Short)number;
                short s2 = Short.parseShort(string);
                switch (n) {
                    case 3: {
                        return s >= s2;
                    }
                    case 4: {
                        return s <= s2;
                    }
                }
                return s == s2;
            }
            if (number instanceof Double) {
                double d = (Double)number;
                double d2 = Double.parseDouble(string);
                switch (n) {
                    case 3: {
                        return d >= d2;
                    }
                    case 4: {
                        return d <= d2;
                    }
                }
                return d == d2;
            }
            if (number instanceof Float) {
                float f = ((Float)number).floatValue();
                float f2 = Float.parseFloat(string);
                switch (n) {
                    case 3: {
                        return f >= f2;
                    }
                    case 4: {
                        return f <= f2;
                    }
                }
                return f == f2;
            }
            if (number instanceof Byte) {
                try {
                    return RFC1960SimpleFilter.compareTyped(Byte.decode(string), n, (Byte)number);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return RFC1960SimpleFilter.compareReflective(string, n, (Comparable)((Object)number));
        }

        private static boolean compareTyped(Object object, int n, Comparable comparable) {
            switch (n) {
                case 0: 
                case 2: {
                    return comparable.equals(object);
                }
                case 3: {
                    return comparable.compareTo(object) >= 0;
                }
                case 4: {
                    return comparable.compareTo(object) <= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareArray(String string, int n, Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof String ? RFC1960SimpleFilter.compareString(string, n, (String)object) : (object instanceof Number ? RFC1960SimpleFilter.compareNumber(string, n, (Number)object) : object instanceof Comparable && RFC1960SimpleFilter.compareReflective(string, n, (Comparable)object)))) continue;
                return true;
            }
            return false;
        }

        private static boolean compareReflective(String string, int n, Comparable comparable) {
            Class<?> clazz = comparable.getClass();
            Object var4_4 = null;
            try {
                Constructor<?> constructor = clazz.getConstructor(STRINGCLASS);
                var4_4 = constructor.newInstance(string);
                return RFC1960SimpleFilter.compareTyped(var4_4, n, comparable);
            }
            catch (Exception exception) {
                return false;
            }
        }

        private static String stripWhitespaces(String string) {
            return string.replace(' ', '\u0000');
        }

        private static int stringCompare(char[] cArray, int n, char[] cArray2, int n2) {
            if (n == cArray.length) {
                return 0;
            }
            int n3 = cArray.length;
            int n4 = cArray2.length;
            while (n < n3 && n2 < n4) {
                if (cArray[n] == cArray2[n2]) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (cArray[n] > 'A' && cArray[n] < 'Z') {
                    cArray[n] = (char)(cArray[n] + 32);
                }
                if (cArray2[n2] > 'A' && cArray2[n2] < 'Z') {
                    cArray2[n2] = (char)(cArray2[n2] + 32);
                }
                if (cArray[n] == cArray2[n2]) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (cArray[n] == '*') {
                    ++n;
                    do {
                        if (RFC1960SimpleFilter.stringCompare(cArray, n, cArray2, n2) != 0) continue;
                        return 0;
                    } while (n4 - ++n2 > -1);
                    return 1;
                }
                if (cArray[n] < cArray2[n2]) {
                    return -1;
                }
                if (cArray[n] <= cArray2[n2]) continue;
                return 1;
            }
            if (n == n3 && n2 == n4 && cArray[n - 1] == cArray2[n2 - 1]) {
                return 0;
            }
            if (cArray[n - 1] == '*' && n == n3 && n2 == n4) {
                return 0;
            }
            int n5 = n3 < n4 ? n3 : n4;
            return n3 == n5 ? -1 : 1;
        }

        public String toString() {
            return "(" + this.id + OP[this.comparator] + (this.value == null ? "" : this.value) + ")";
        }

        public boolean equals(Object object) {
            if (object instanceof RFC1960SimpleFilter) {
                RFC1960SimpleFilter rFC1960SimpleFilter = (RFC1960SimpleFilter)object;
                return this.comparator == rFC1960SimpleFilter.comparator && this.id.equals(rFC1960SimpleFilter.id) && this.value.equals(rFC1960SimpleFilter.value);
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

