/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.io.FileInputStream;
import java.net.URI;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectManager;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.security.ISharedObjectPolicy;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.eclipse.ecf.server.generic.app.ServerConfigParser;

public class ServerApplication {
    public static final int DEFAULT_KEEPALIVE = 30000;
    static TCPServerSOContainerGroup[] serverGroups = null;
    static List servers = new ArrayList();

    public static void main(String[] args) throws Exception {
        String serverName = null;
        List connectors = null;
        if (args.length > 0) {
            if (args[0].equals("-c")) {
                ServerConfigParser parser = new ServerConfigParser();
                connectors = parser.load(new FileInputStream(args[1]));
            } else if (!args[0].equals("-")) {
                serverName = args[0];
            }
        }
        if (connectors != null) {
            serverGroups = new TCPServerSOContainerGroup[connectors.size()];
            int j = 0;
            Iterator i = connectors.iterator();
            while (i.hasNext()) {
                Connector connect = (Connector)i.next();
                ServerApplication.serverGroups[j] = ServerApplication.createServerGroup(connect.getHostname(), connect.getPort());
                List groups = connect.getGroups();
                Iterator g = groups.iterator();
                while (g.hasNext()) {
                    NamedGroup group = (NamedGroup)g.next();
                    TCPServerSOContainer cont = ServerApplication.createServerContainer(group.getIDForGroup(), serverGroups[j], group.getName(), connect.getTimeout());
                    cont.setConnectPolicy((IConnectHandlerPolicy)new JoinListener());
                    servers.add(cont);
                }
                System.out.println("Putting server " + connect.getHostname() + " on the air");
                serverGroups[j].putOnTheAir();
                ++j;
                System.out.println("<ctrl>-c to stop server");
            }
        } else {
            String name;
            URI anURL;
            int port;
            if (serverName == null) {
                serverName = TCPServerSOContainer.getDefaultServerURL();
            }
            if ((port = (anURL = new URI(serverName)).getPort()) == -1) {
                port = 3282;
            }
            if ((name = anURL.getPath()) == null) {
                name = "/server";
            }
            serverGroups = new TCPServerSOContainerGroup[1];
            ServerApplication.serverGroups[0] = new TCPServerSOContainerGroup(anURL.getPort());
            ID id = IDFactory.getDefault().createStringID(serverName);
            SOContainerConfig config = new SOContainerConfig(id);
            System.out.print("Creating ECF server container...");
            TCPServerSOContainer server = new TCPServerSOContainer((ISharedObjectContainerConfig)config, serverGroups[0], name, 30000);
            server.setConnectPolicy((IConnectHandlerPolicy)new JoinListener());
            ISharedObjectManager manager = server.getSharedObjectManager();
            manager.setRemoteAddPolicy((ISharedObjectPolicy)new SharedObjectAddListener());
            serverGroups[0].putOnTheAir();
            servers.add(server);
            System.out.println("success!");
            System.out.println("Waiting for JOIN requests at '" + id.getName() + "'...");
            System.out.println("<ctrl>-c to stop server");
        }
    }

    protected static TCPServerSOContainerGroup createServerGroup(String name, int port) {
        System.out.println("Creating server group named " + name + " to listen on port " + port);
        TCPServerSOContainerGroup group = new TCPServerSOContainerGroup(name, port);
        return group;
    }

    protected static TCPServerSOContainer createServerContainer(String id, TCPServerSOContainerGroup group, String path, int keepAlive) throws IDCreateException {
        System.out.println("  Creating container with id=" + id + ", group=" + path + " keepAlive=" + keepAlive);
        ID newServerID = IDFactory.getDefault().createStringID(id);
        SOContainerConfig config = new SOContainerConfig(newServerID);
        return new TCPServerSOContainer((ISharedObjectContainerConfig)config, group, path, keepAlive);
    }

    static class JoinListener
    implements IConnectHandlerPolicy {
        JoinListener() {
        }

        public PermissionCollection checkConnect(Object addr, ID fromID, ID targetID, String targetGroup, Object joinData) throws Exception {
            System.out.println("JOIN Addr=" + addr + ";From=" + fromID + ";Target Group=" + targetGroup + ";Data=" + joinData);
            return null;
        }

        public void refresh() {
            System.out.println("connectHandlerPolicy.refresh()");
        }
    }

    static class SharedObjectAddListener
    implements ISharedObjectPolicy {
        SharedObjectAddListener() {
        }

        public PermissionCollection checkAddSharedObject(ID fromID, ID toID, ID localID, ReplicaSharedObjectDescription newObject) throws SecurityException {
            System.out.println("CHECKADDSHAREDOBJECT From=" + fromID + ";To=" + toID + ";SharedObject=" + newObject);
            return null;
        }

        public void refresh() {
            System.out.println("connectHandlerPolicy.refresh()");
        }
    }
}

