/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Dictionary;

public final class LeaseMessage
extends RemoteOSGiMessage {
    private String[] serviceIDs;
    private String[][] serviceInterfaces;
    private Dictionary[] serviceProperties;
    private String[] topics;

    public LeaseMessage() {
        super((short)1);
    }

    LeaseMessage(ObjectInputStream input) throws IOException {
        super((short)1);
        short serviceCount = input.readShort();
        this.serviceIDs = new String[serviceCount];
        this.serviceInterfaces = new String[serviceCount][];
        this.serviceProperties = new Dictionary[serviceCount];
        try {
            short i = 0;
            while (i < serviceCount) {
                this.serviceIDs[i] = input.readUTF();
                this.serviceInterfaces[i] = LeaseMessage.readStringArray(input);
                this.serviceProperties[i] = (Dictionary)input.readObject();
                i = (short)(i + 1);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.topics = LeaseMessage.readStringArray(input);
    }

    public String[][] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public void setServiceInterfaces(String[][] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public String[] getServiceIDs() {
        return this.serviceIDs;
    }

    public void setServiceIDs(String[] serviceIDs) {
        this.serviceIDs = serviceIDs;
    }

    public Dictionary[] getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Dictionary[] serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }

    public void writeBody(ObjectOutputStream out) throws IOException {
        int slen = this.serviceInterfaces.length;
        out.writeShort(slen);
        int i = 0;
        while (i < slen) {
            out.writeUTF(this.serviceIDs[i]);
            LeaseMessage.writeStringArray(out, this.serviceInterfaces[i]);
            out.writeObject(this.serviceProperties[i]);
            i = (short)(i + 1);
        }
        LeaseMessage.writeStringArray(out, this.topics);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[LEASE] - XID: ");
        buffer.append(this.xid);
        buffer.append(", services: ");
        int i = 0;
        while (i < this.serviceInterfaces.length) {
            buffer.append(Arrays.asList(this.serviceInterfaces[i]));
            buffer.append("-");
            buffer.append(this.serviceIDs[i]);
            if (i < this.serviceInterfaces.length) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(", topics: ");
        buffer.append(Arrays.asList(this.topics));
        return buffer.toString();
    }
}

