/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.Advertiser;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.ServiceAcknowledgement;
import ch.ethz.iks.slp.impl.ServiceDeregistration;
import ch.ethz.iks.slp.impl.ServiceRegistration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;

public final class AdvertiserImpl
implements Advertiser {
    private Locale locale;

    public AdvertiserImpl() {
        this.locale = SLPCore.DEFAULT_LOCALE;
    }

    public AdvertiserImpl(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void register(ServiceURL serviceURL, Dictionary dictionary) throws ServiceLocationException {
        this.register(serviceURL, null, dictionary);
    }

    public void register(ServiceURL serviceURL, List list, Dictionary dictionary) throws ServiceLocationException {
        ServiceRegistration serviceRegistration = new ServiceRegistration(serviceURL, serviceURL.getServiceType(), list, SLPUtils.dictToAttrList(dictionary), this.locale);
        try {
            serviceRegistration.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            serviceRegistration.address = SLPCore.getMyIP();
        }
        serviceRegistration.port = SLPCore.SLP_PORT;
        ServiceAcknowledgement serviceAcknowledgement = (ServiceAcknowledgement)SLPCore.sendMessage(serviceRegistration, true);
        if (serviceAcknowledgement.errorCode != 0) {
            throw new ServiceLocationException((short)serviceAcknowledgement.errorCode, "Registration failed");
        }
    }

    public void deregister(ServiceURL serviceURL) throws ServiceLocationException {
        this.deregister(serviceURL, null);
    }

    public void deregister(ServiceURL serviceURL, List list) throws ServiceLocationException {
        ServiceDeregistration serviceDeregistration = new ServiceDeregistration(serviceURL, list, null, this.locale);
        try {
            serviceDeregistration.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            serviceDeregistration.address = SLPCore.getMyIP();
        }
        serviceDeregistration.port = SLPCore.SLP_PORT;
        ServiceAcknowledgement serviceAcknowledgement = (ServiceAcknowledgement)SLPCore.sendMessage(serviceDeregistration, true);
        if (serviceAcknowledgement.errorCode != 0) {
            throw new ServiceLocationException((short)serviceAcknowledgement.errorCode, "Deregistration failed");
        }
    }

    public void addAttributes(ServiceURL serviceURL, Dictionary dictionary) throws ServiceLocationException {
        throw new ServiceLocationException(16, "incremental registration not supported");
    }

    public void deleteAttributes(ServiceURL serviceURL, Dictionary dictionary) throws ServiceLocationException {
        throw new ServiceLocationException(16, "incremental registration not supported");
    }

    public InetAddress getMyIP() {
        try {
            return SLPCore.getMyIP();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

