/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.PlatformAbstraction;
import ch.ethz.iks.slp.impl.filter.Filter;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.log.LogService;

public class OSGiPlatformAbstraction
implements PlatformAbstraction,
ServiceListener {
    private final BundleContext context;
    private LogService log;
    private boolean debug;

    OSGiPlatformAbstraction(BundleContext bundleContext, LogService logService, boolean bl) {
        this.context = bundleContext;
        this.log = logService;
        this.debug = bl;
        if (logService != null) {
            if (bl) {
                logService.log(3, "DEBUG OUTPUTS ENABLED");
            } else {
                logService.log(3, "DEBUG OUTPUTS DISABLED");
            }
        }
        try {
            bundleContext.addServiceListener((ServiceListener)this, "(objectClass=org.osgi.service.log)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            invalidSyntaxException.printStackTrace();
        }
    }

    public Filter createFilter(String string) {
        try {
            final org.osgi.framework.Filter filter = this.context.createFilter(string);
            return new Filter(){

                public boolean match(Dictionary dictionary) {
                    return filter.match(dictionary);
                }

                public String toString() {
                    return filter.toString();
                }
            };
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            invalidSyntaxException.printStackTrace();
            throw new IllegalArgumentException(invalidSyntaxException.getMessage());
        }
    }

    public boolean isDebugEnabled() {
        return this.log != null && this.debug;
    }

    public boolean isErrorEnabled() {
        return this.log != null;
    }

    public boolean isTraceEnabled() {
        return this.log != null;
    }

    public boolean isWarningEnabled() {
        return this.log != null;
    }

    public void logDebug(String string) {
        this.log.log(4, string);
    }

    public void logDebug(String string, Throwable throwable) {
        this.log.log(4, string, throwable);
    }

    public void logError(String string) {
        this.log.log(1, string);
    }

    public void logError(String string, Throwable throwable) {
        this.log.log(1, string, throwable);
    }

    public void logTrace(String string) {
        this.log.log(3, string);
    }

    public void logTrace(String string, Throwable throwable) {
        this.log.log(3, string, throwable);
    }

    public void logWarning(String string) {
        this.log.log(2, string);
    }

    public void logWarning(String string, Throwable throwable) {
        this.log.log(2, string, throwable);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 1: {
                this.log = (LogService)this.context.getService(serviceEvent.getServiceReference());
                return;
            }
            case 4: {
                this.log = null;
            }
        }
    }
}

