/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class ServiceRegistration
extends SLPMessage {
    ServiceURL url;
    ServiceType serviceType;
    List scopeList;
    List attList;
    AuthenticationBlock[] authBlocks;

    ServiceRegistration(ServiceURL serviceURL, ServiceType serviceType, List list, List list2, Locale locale) {
        this.funcID = (byte)3;
        this.locale = locale;
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL must not be null");
        }
        if (serviceType == null) {
            throw new IllegalArgumentException("serviceType must not be null");
        }
        this.url = serviceURL;
        this.serviceType = serviceType;
        this.scopeList = list;
        if (this.scopeList == null) {
            this.scopeList = Arrays.asList("default");
        }
        this.attList = list2;
        if (this.attList == null) {
            this.attList = new ArrayList();
        }
        this.authBlocks = new AuthenticationBlock[0];
    }

    ServiceRegistration(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        this.funcID = (byte)3;
        this.locale = SLPCore.DEFAULT_LOCALE;
        this.url = ServiceURL.fromBytes(dataInputStream);
        this.serviceType = new ServiceType(dataInputStream.readUTF());
        this.scopeList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.attList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.authBlocks = AuthenticationBlock.parse(dataInputStream);
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "Authentication failed for " + this.toString());
        }
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        this.url.writeTo(dataOutputStream);
        dataOutputStream.writeUTF(this.serviceType.toString());
        dataOutputStream.writeUTF(SLPMessage.listToString(this.scopeList, ","));
        dataOutputStream.writeUTF(SLPMessage.listToString(this.attList, ","));
        dataOutputStream.write(this.authBlocks.length);
        for (int i = 0; i < this.authBlocks.length; ++i) {
            this.authBlocks[i].write(dataOutputStream);
        }
    }

    int getSize() {
        int n = this.getHeaderSize() + this.url.getLength() + 2 + this.serviceType.toString().length() + 2 + SLPMessage.listToString(this.scopeList, ",").length() + 2 + SLPMessage.listToString(this.attList, ",").length() + 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            n += this.authBlocks[i].getLength();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", url: " + this.url);
        stringBuffer.append(", serviceType: " + this.serviceType);
        stringBuffer.append(", scopeList: " + this.scopeList);
        stringBuffer.append(", attList: " + this.attList);
        return stringBuffer.toString();
    }

    void sign(List list) throws ServiceLocationException {
        this.url.sign(list);
        this.authBlocks = new AuthenticationBlock[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n = SLPUtils.getTimestamp();
            String string = (String)list.get(i);
            byte[] byArray = this.getAuthData(string, n);
            this.authBlocks[i] = new AuthenticationBlock(2, string, n, byArray, null);
        }
    }

    boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            if (!this.authBlocks[i].verify(this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp()))) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String string, int n) throws ServiceLocationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF(SLPMessage.listToString(this.attList, ","));
            dataOutputStream.writeInt(n);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, iOException.getMessage());
        }
    }
}

