/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui.chatroom;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.ChatLine;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView;
import org.eclipse.ecf.presence.ui.chatroom.ChatRoomViewerConfiguration;
import org.eclipse.ecf.presence.ui.chatroom.IChatRoomCommandListener;
import org.eclipse.ecf.presence.ui.chatroom.IChatRoomViewCloseListener;
import org.eclipse.ecf.presence.ui.chatroom.IMessageRenderer;
import org.eclipse.ecf.presence.ui.chatroom.MessageRenderer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ChatRoomManagerView
extends ViewPart
implements IChatRoomInvitationListener {
    private static final String ATSIGN = "@";
    public static final String VIEW_ID = "org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView";
    public static final String PARTICIPANTS_MENU_ID = "org.eclipse.ecf.presence.ui.chatroom.participantsView";
    private static final int RATIO_WRITE_PANE = 1;
    private static final int RATIO_READ_PANE = 9;
    private static final int RATIO_READ_WRITE_PANE = 85;
    private static final int RATIO_PRESENCE_PANE = 15;
    protected static final int DEFAULT_INPUT_HEIGHT = 25;
    protected static final int DEFAULT_INPUT_SEPARATOR = 5;
    private CTabFolder rootTabFolder = null;
    private ChatRoomTab rootChannelTab = null;
    private IChatRoomViewCloseListener rootCloseListener = null;
    private IChatRoomMessageSender rootMessageSender = null;
    private IMessageRenderer messageRenderer = null;
    Action outputClear = null;
    Action outputCopy = null;
    Action outputPaste = null;
    Action outputSelectAll = null;
    boolean rootDisposed = false;
    private boolean rootEnabled = false;
    private Hashtable chatRooms = new Hashtable();
    private IChatRoomCommandListener commandListener = null;
    private IChatRoomContainer container = null;
    private String localUserName = Messages.ChatRoomManagerView_DEFAULT_USER;
    private String hostName = Messages.ChatRoomManagerView_DEFAULT_HOST;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createPartControl(Composite parent) {
        Composite rootComposite = new Composite(parent, 0);
        rootComposite.setLayout((Layout)new FillLayout());
        boolean useTraditionalTabFolder = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        this.rootTabFolder = new CTabFolder(rootComposite, 64);
        this.rootTabFolder.setUnselectedCloseVisible(false);
        this.rootTabFolder.setSimple(useTraditionalTabFolder);
        PlatformUI.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("SHOW_TRADITIONAL_STYLE_TABS") && !ChatRoomManagerView.this.rootTabFolder.isDisposed()) {
                    ChatRoomManagerView.this.rootTabFolder.setSimple(((Boolean)event.getNewValue()).booleanValue());
                    ChatRoomManagerView.this.rootTabFolder.redraw();
                }
            }
        });
        this.rootTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = ChatRoomManagerView.this.closeTabItem((CTabItem)event.item);
            }
        });
    }

    private boolean closeTabItem(CTabItem tabItem) {
        ChatRoom chatRoom = this.findChatRoomForTabItem(tabItem);
        if (chatRoom == null) {
            return true;
        }
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.ChatRoomManagerView_CLOSE_CHAT_ROOM_TITLE, (String)NLS.bind((String)Messages.ChatRoomManagerView_CLOSE_CHAT_ROOM_MESSAGE, (Object)tabItem.getText()))) {
            chatRoom.chatRoomDisconnect();
            return true;
        }
        return false;
    }

    public IChatRoomContainer getRootChatRoomContainer() {
        return this.container;
    }

    public IChatRoomContainer getActiveChatRoomContainer() {
        ChatRoom chatRoom;
        CTabItem selection = this.rootTabFolder.getSelection();
        if (selection != null && (chatRoom = this.findChatRoomForTabItem(selection)) != null) {
            return chatRoom.chatRoomContainer;
        }
        return null;
    }

    private ChatRoom findChatRoomForTabItem(CTabItem tabItem) {
        Iterator i = this.chatRooms.values().iterator();
        while (i.hasNext()) {
            ChatRoom cr = (ChatRoom)i.next();
            if (tabItem != cr.chatRoomTab.tabItem) continue;
            return cr;
        }
        return null;
    }

    private Text getRootTextInput() {
        if (this.rootChannelTab == null) {
            return null;
        }
        return this.rootChannelTab.getInputText();
    }

    private StyledText getRootTextOutput() {
        if (this.rootChannelTab == null) {
            return null;
        }
        return this.rootChannelTab.getOutputText();
    }

    public void initializeWithoutManager(String username, String hostname, IChatRoomCommandListener commandListener1, IChatRoomViewCloseListener closeListener) {
        this.initializeWithManager(username, hostname, null, commandListener1, closeListener);
    }

    public void initializeWithManager(String localUserName1, String hostName1, IChatRoomContainer rootChatRoomContainer, IChatRoomCommandListener commandListener1, IChatRoomViewCloseListener closeListener) {
        this.localUserName = localUserName1 == null ? Messages.ChatRoomManagerView_DEFAULT_USER : localUserName1;
        this.hostName = hostName1 == null ? Messages.ChatRoomManagerView_DEFAULT_HOST : hostName1;
        this.rootCloseListener = closeListener;
        this.commandListener = commandListener1;
        String viewTitle = String.valueOf(localUserName1) + ATSIGN + hostName1;
        this.setPartName(NLS.bind((String)Messages.ChatRoomManagerView_VIEW_TITLE, (Object)viewTitle));
        this.setTitleToolTip(String.valueOf(Messages.ChatRoomManagerView_VIEW_TITLE_HOST_PREFIX) + this.hostName);
        if (rootChatRoomContainer != null) {
            StyledText outputText;
            this.container = rootChatRoomContainer;
            this.rootMessageSender = rootChatRoomContainer.getChatRoomMessageSender();
            this.rootChannelTab = new ChatRoomTab(false, this.rootTabFolder, this.hostName, new KeyListener(){

                public void keyPressed(KeyEvent evt) {
                    ChatRoomManagerView.this.handleKeyPressed(evt);
                }

                public void keyReleased(KeyEvent evt) {
                }
            });
            this.makeActions();
            this.hookContextMenu();
            if (rootChatRoomContainer.getConnectedID() == null && !(outputText = this.getRootTextOutput()).isDisposed()) {
                outputText.setText(String.valueOf(new SimpleDateFormat(Messages.ChatRoomManagerView_CONNECT_DATE_TIME_FORMAT).format(new Date())) + NLS.bind((String)Messages.ChatRoomManagerView_CONNECT_MESSAGE, (Object)viewTitle));
            }
        }
        this.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        this.rootEnabled = enabled;
        Text inputText = this.getRootTextInput();
        if (inputText != null && !inputText.isDisposed()) {
            inputText.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.rootEnabled;
    }

    protected void clearInput() {
        Text textInput = this.getRootTextInput();
        if (textInput != null) {
            textInput.setText("");
        }
    }

    public void sendMessageLine(String line) {
        try {
            if (this.rootMessageSender != null) {
                this.rootMessageSender.sendMessage(line);
            }
        }
        catch (ECFException eCFException) {
            this.removeLocalUser();
        }
    }

    public void disconnected() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ChatRoomManagerView.this.rootDisposed) {
                    return;
                }
                ChatRoomManagerView.this.setEnabled(false);
                ChatRoomManagerView.this.setPartName(NLS.bind((String)Messages.ChatRoomManagerView_VIEW_DISABLED_NAME, (Object)ChatRoomManagerView.this.getPartName()));
            }
        });
    }

    protected CTabItem getTabItem(String targetName) {
        CTabItem[] items = this.rootTabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(targetName)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    protected void doJoinRoom(IChatRoomInfo roomInfo, final String password) {
        final ID targetRoomID = roomInfo.getRoomID();
        final String targetRoomName = targetRoomID.getName();
        ChatRoom room = (ChatRoom)this.chatRooms.get(targetRoomName);
        if (room != null && room.isConnected()) {
            room.setSelected();
            return;
        }
        try {
            final IChatRoomContainer chatRoomContainer = roomInfo.createChatRoomContainer();
            final ChatRoom chatroom = new ChatRoom(chatRoomContainer, new ChatRoomTab(this.rootTabFolder, targetRoomName));
            chatRoomContainer.addMessageListener(new IIMMessageListener(){

                public void handleMessageEvent(IIMMessageEvent messageEvent) {
                    if (messageEvent instanceof IChatRoomMessageEvent) {
                        IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
                        chatroom.handleMessage(m.getFromID(), m.getMessage());
                    }
                }
            });
            chatRoomContainer.addChatRoomParticipantListener(new IChatRoomParticipantListener(){

                public void handlePresenceUpdated(ID fromID, IPresence presence) {
                    chatroom.handlePresence(fromID, presence);
                }

                public void handleArrived(IUser participant) {
                }

                public void handleUpdated(IUser updatedParticipant) {
                }

                public void handleDeparted(IUser participant) {
                }
            });
            chatRoomContainer.addListener(new IContainerListener(){

                public void handleEvent(IContainerEvent evt) {
                    if (evt instanceof IContainerDisconnectedEvent || evt instanceof IContainerEjectedEvent) {
                        chatroom.disconnected();
                    }
                }
            });
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        chatRoomContainer.connect(targetRoomID, ConnectContextFactory.createPasswordConnectContext((String)password));
                        ChatRoomManagerView.this.chatRooms.put(targetRoomName, chatroom);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)ChatRoomManagerView.this.getSite().getShell(), (String)"Connect Error", (String)NLS.bind((String)"Could not connect to {0}.\n\nError is {1}.", (Object)targetRoomName, (Object)e.getLocalizedMessage()));
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Container Create Error", (String)NLS.bind((String)"Could not create chatRoomContainer for {0}.\n\nError is {1}.", (Object)targetRoomName, (Object)e.getLocalizedMessage()));
        }
    }

    protected void handleTextInput(String text) {
        if (this.rootMessageSender == null) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)Messages.ChatRoomManagerView_NOT_CONNECTED_TITLE, (String)Messages.ChatRoomManagerView_NOT_CONNECTED_MESSAGE);
        } else {
            String output = this.processForCommand(null, text);
            if (output != null) {
                this.sendMessageLine(output);
            }
        }
    }

    protected String processForCommand(IChatRoomContainer chatRoomContainer, String text) {
        IChatRoomCommandListener l = this.commandListener;
        if (l != null) {
            return l.handleCommand(chatRoomContainer, text);
        }
        return text;
    }

    protected void handleEnter() {
        Text inputText = this.getRootTextInput();
        if (inputText.getText().trim().length() > 0) {
            this.handleTextInput(inputText.getText());
        }
        this.clearInput();
        this.scrollToEnd(this.getRootTextOutput());
        if (this.rootChannelTab != null) {
            this.rootChannelTab.makeTabItemNormal();
        }
    }

    protected void handleKeyPressed(KeyEvent evt) {
        if (evt.character == '\r') {
            this.handleEnter();
            evt.doit = false;
        }
    }

    public void setFocus() {
        Text text = this.getRootTextInput();
        if (text != null) {
            text.setFocus();
        }
    }

    public void joinRoom(final IChatRoomInfo info, final String password) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (ChatRoomManagerView.this.rootDisposed) {
                    return;
                }
                ChatRoomManagerView.this.doJoinRoom(info, password);
            }
        });
    }

    public void dispose() {
        this.disconnect();
        this.rootDisposed = true;
        super.dispose();
    }

    protected String getMessageString(ID fromID, String text) {
        return NLS.bind((String)Messages.ChatRoomManagerView_MESSAGE, (Object)fromID.getName(), (Object)text);
    }

    private ID createStringID(String str) {
        try {
            return IDFactory.getDefault().createStringID(str);
        }
        catch (IDCreateException iDCreateException) {
            return null;
        }
    }

    private MessagesView getMessagesView() throws PartInitException {
        IWorkbenchPage page = this.getSite().getPage();
        MessagesView messageView = (MessagesView)page.findView("org.eclipse.ecf.presence.ui.MessagesView");
        if (messageView == null) {
            messageView = (MessagesView)page.showView("org.eclipse.ecf.presence.ui.MessagesView", null, 3);
        }
        return messageView;
    }

    public void handleChatMessage(final IChatMessage message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ID targetID = ChatRoomManagerView.this.createStringID(ChatRoomManagerView.this.localUserName);
                    MessagesView messageView = ChatRoomManagerView.this.getMessagesView();
                    IWorkbenchPartSite iWorkbenchPartSite = messageView.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                    if (ChatRoomManagerView.this.container.getPrivateMessageSender() != null) {
                        messageView.openTab(ChatRoomManagerView.this.container.getPrivateMessageSender(), null, targetID, message.getFromID());
                        messageView.showMessage(message);
                        service.warnOfContentChange();
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, String.valueOf(Messages.ChatRoomManagerView_EXCEPTION_MESSAGE_VIEW_INITIALIZATION) + message.getFromID(), (Throwable)e));
                }
            }
        });
    }

    public void handleMessage(final ID fromID, final String messageBody) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ChatRoomManagerView.this.rootDisposed) {
                    return;
                }
                if (ChatRoomManagerView.this.rootChannelTab != null) {
                    ChatRoomManagerView.this.appendText(ChatRoomManagerView.this.rootChannelTab, ChatRoomManagerView.this.getRootTextOutput(), new ChatLine(messageBody, new ChatRoomParticipant(fromID)));
                    ChatRoomManagerView.this.rootChannelTab.makeTabItemBold();
                }
            }
        });
    }

    public static String getUsernameFromID(ID targetID) {
        IChatID chatID;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.presence.im.IChatID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((chatID = (IChatID)targetID.getAdapter((Class)clazz)) != null) {
            return chatID.getUsername();
        }
        try {
            URI uri = new URI(targetID.getName());
            String user = uri.getUserInfo();
            return user == null ? targetID.getName() : user;
        }
        catch (URISyntaxException uRISyntaxException) {
            String userAtHost = targetID.getName();
            int atIndex = userAtHost.lastIndexOf(ATSIGN);
            if (atIndex != -1) {
                userAtHost = userAtHost.substring(0, atIndex);
            }
            return userAtHost;
        }
    }

    public static String getHostnameFromID(ID targetID) {
        IChatID chatID;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.presence.im.IChatID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((chatID = (IChatID)targetID.getAdapter((Class)clazz)) != null) {
            return chatID.getHostname();
        }
        try {
            URI uri = new URI(targetID.getName());
            String host = uri.getHost();
            return host == null ? targetID.getName() : host;
        }
        catch (URISyntaxException uRISyntaxException) {
            String userAtHost = targetID.getName();
            int atIndex = userAtHost.lastIndexOf(ATSIGN);
            if (atIndex != -1) {
                userAtHost = userAtHost.substring(atIndex + 1);
            }
            return userAtHost;
        }
    }

    public void disconnect() {
        if (this.rootCloseListener != null) {
            this.rootCloseListener.chatRoomViewClosing();
        }
        Iterator i = this.chatRooms.values().iterator();
        while (i.hasNext()) {
            ChatRoom chatRoom = (ChatRoom)i.next();
            IChatRoomContainer c = chatRoom.chatRoomContainer;
            if (c == null) continue;
            c.disconnect();
        }
        this.rootMessageSender = null;
        this.rootCloseListener = null;
        this.chatRooms.clear();
    }

    protected void removeLocalUser() {
        String title = this.getPartName();
        this.setPartName(NLS.bind((String)Messages.ChatRoomManagerView_VIEW_DISABLED_NAME, (Object)title));
        this.disconnect();
        this.setEnabled(false);
    }

    public void handleInvitationReceived(ID roomID, ID from, String subject, String body) {
    }

    private boolean isLastOutputInvisible(StyledText chatText) {
        Point locAtEnd = chatText.getLocationAtOffset(chatText.getText().length());
        Rectangle bounds = chatText.getBounds();
        return locAtEnd.y > bounds.height + 5;
    }

    private void scrollToEnd(StyledText chatText) {
        chatText.setSelection(chatText.getText().length());
    }

    protected void appendText(ChatRoomTab chatRoomTab, StyledText st, ChatLine text) {
        if (st == null || text == null) {
            return;
        }
        boolean isAtEndBeforeAppend = !this.isLastOutputInvisible(st);
        String originator = null;
        if (text.getOriginator() != null) {
            originator = text.getOriginator().getNickname();
        }
        if (this.messageRenderer == null) {
            this.messageRenderer = new MessageRenderer();
        }
        String output = this.messageRenderer.render(text.getText(), originator, this.localUserName);
        StyleRange[] ranges = this.messageRenderer.getStyleRanges();
        if (output == null) {
            return;
        }
        int startRange = st.getText().length();
        if (!text.isNoCRLF()) {
            output = String.valueOf(output) + "\n";
        }
        st.append(output);
        if (ranges != null) {
            int i = 0;
            while (i < ranges.length) {
                ranges[i].start += startRange;
                ++i;
            }
            st.replaceStyleRanges(startRange, output.length(), ranges);
        }
        if (isAtEndBeforeAppend) {
            this.scrollToEnd(st);
        }
        if (this.isCurrentlyActive(chatRoomTab)) {
            chatRoomTab.makeTabItemNormal();
        } else {
            chatRoomTab.makeTabItemBold();
        }
    }

    protected void outputClear() {
        if (MessageDialog.openConfirm(null, (String)Messages.ChatRoomManagerView_CLEAR_CONFIRM_TITLE, (String)Messages.ChatRoomManagerView_CLEAR_CONFIRM_MESSAGE)) {
            this.getRootTextOutput().setText("");
        }
    }

    protected void outputCopy() {
        StyledText outputText = this.getRootTextOutput();
        String t = outputText.getSelectionText();
        if (t == null || t.length() == 0) {
            outputText.selectAll();
        }
        outputText.copy();
        outputText.setSelection(outputText.getText().length());
    }

    protected void outputSelectAll() {
        this.getRootTextOutput().selectAll();
    }

    protected void makeActions() {
        this.outputSelectAll = new Action(){

            public void run() {
                ChatRoomManagerView.this.outputSelectAll();
            }
        };
        this.outputSelectAll.setText(Messages.ChatRoomManagerView_SELECT_ALL_TEXT);
        this.outputSelectAll.setToolTipText(Messages.ChatRoomManagerView_SELECT_ALL_TOOLTIP);
        this.outputSelectAll.setAccelerator(262209);
        this.outputCopy = new Action(){

            public void run() {
                ChatRoomManagerView.this.outputCopy();
            }
        };
        this.outputCopy.setText(Messages.ChatRoomManagerView_COPY_TEXT);
        this.outputCopy.setToolTipText(Messages.ChatRoomManagerView_COPY_TOOLTIP);
        this.outputCopy.setAccelerator(262211);
        this.outputCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.outputClear = new Action(){

            public void run() {
                ChatRoomManagerView.this.outputClear();
            }
        };
        this.outputClear.setText(Messages.ChatRoomManagerView_CLEAR_TEXT);
        this.outputClear.setToolTipText(Messages.ChatRoomManagerView_CLEAR_TOOLTIP);
        this.outputPaste = new Action(){

            public void run() {
                ChatRoomManagerView.this.getRootTextInput().paste();
            }
        };
        this.outputPaste.setText(Messages.ChatRoomManagerView_PASTE_TEXT);
        this.outputPaste.setToolTipText(Messages.ChatRoomManagerView_PASTE_TOOLTIP);
        this.outputPaste.setAccelerator(262230);
        this.outputPaste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.outputCopy);
        manager.add((IAction)this.outputPaste);
        manager.add((IAction)this.outputClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.outputSelectAll);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChatRoomManagerView.this.fillContextMenu(manager);
            }
        });
        StyledText outputText = this.getRootTextOutput();
        Menu menu = menuMgr.createContextMenu((Control)outputText);
        outputText.setMenu(menu);
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                StyledText ot = ChatRoomManagerView.this.getRootTextOutput();
                TextSelection selection = new TextSelection(ot.getSelectionRange().x, ot.getSelectionRange().y);
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    StyledText ot = ChatRoomManagerView.this.getRootTextOutput();
                    ot.setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                }
            }
        };
        this.getSite().registerContextMenu(menuMgr, selectionProvider);
    }

    public void setMessageRenderer(IMessageRenderer defaultMessageRenderer) {
        this.messageRenderer = defaultMessageRenderer;
    }

    private boolean isCurrentlyActive(ChatRoomTab chatRoomTab) {
        CTabItem item;
        int selected = this.rootTabFolder.getSelectionIndex();
        return selected != -1 && (item = this.rootTabFolder.getItem(selected)) == chatRoomTab.tabItem;
    }

    static /* synthetic */ boolean access$0(ChatRoomManagerView chatRoomManagerView, StyledText styledText) {
        return chatRoomManagerView.isLastOutputInvisible(styledText);
    }

    class ChatRoom
    implements IChatRoomInvitationListener,
    KeyListener {
        private IChatRoomContainer chatRoomContainer;
        private ChatRoomTab chatRoomTab;
        private IChatRoomMessageSender chatRoomMessageSender;
        private IUser localUser;
        private Label chatRoomParticipantsLabel;
        private TableViewer chatRoomParticipantViewer = null;
        private ArrayList options;
        private int maximumCyclingOptions = 5;
        private int prefixLength;
        private int choice = 0;
        private int nickRemainder;
        private int caret;
        private char nickCompletionSuffix = (char)58;
        private boolean isCycling = false;
        private boolean isAtStart = false;
        private CTabItem itemSelected = null;
        private SelectionListener scrollSelectionListener = new SelectionListener(this){
            final /* synthetic */ ChatRoom this$1;
            {
                this.this$1 = chatRoom;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ChatRoomManagerView.access$0(ChatRoom.access$9(this.this$1), ChatRoom.access$1(this.this$1))) {
                    this.this$1.makeTabItemNormal();
                }
            }
        };

        private Text getInputText() {
            return this.chatRoomTab.getInputText();
        }

        private StyledText getOutputText() {
            return this.chatRoomTab.getOutputText();
        }

        ChatRoom(IChatRoomContainer container, ChatRoomTab tabItem) {
            ScrollBar vsb;
            Assert.isNotNull((Object)container);
            Assert.isNotNull((Object)tabItem);
            this.chatRoomContainer = container;
            this.chatRoomMessageSender = container.getChatRoomMessageSender();
            this.chatRoomTab = tabItem;
            this.options = new ArrayList();
            this.chatRoomTab.setKeyListener(this);
            this.chatRoomParticipantsLabel = tabItem.getParticipantsLabel();
            this.chatRoomParticipantViewer = tabItem.getParticipantsViewer();
            this.chatRoomContainer.addChatRoomAdminListener(new IChatRoomAdminListener(this){
                final /* synthetic */ ChatRoom this$1;
                {
                    this.this$1 = chatRoom;
                }

                public void handleSubjectChange(ID from, String newSubject) {
                    ChatRoom.access$2(this.this$1).getInputText().getDisplay().asyncExec(new Runnable(this, newSubject){
                        final /* synthetic */ 13 this$2;
                        private final /* synthetic */ String val$newSubject;
                        {
                            this.this$2 = var1_1;
                            this.val$newSubject = string;
                        }

                        public void run() {
                            ChatRoom.access$2(13.access$0(this.this$2)).setSubject(this.val$newSubject);
                        }
                    });
                }

                static /* synthetic */ ChatRoom access$0(13 var0) {
                    return var0.this$1;
                }
            });
            ChatRoomManagerView.this.rootTabFolder.setUnselectedCloseVisible(true);
            ChatRoomManagerView.this.rootTabFolder.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ChatRoom this$1;
                {
                    this.this$1 = chatRoom;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ChatRoom.access$3(this.this$1, (CTabItem)e.item);
                    if (ChatRoom.access$4(this.this$1) == ChatRoomTab.access$0(ChatRoom.access$2(this.this$1))) {
                        this.this$1.makeTabItemNormal();
                    }
                    if (ChatRoomManagerView.access$7(ChatRoom.access$9(this.this$1)) != null && ChatRoom.access$4(this.this$1) == ChatRoomTab.access$0(ChatRoomManagerView.access$7(ChatRoom.access$9(this.this$1)))) {
                        ChatRoomManagerView.access$7(ChatRoom.access$9(this.this$1)).makeTabItemNormal();
                    }
                }
            });
            StyledText st = this.getOutputText();
            if (st != null && (vsb = st.getVerticalBar()) != null) {
                vsb.addSelectionListener(this.scrollSelectionListener);
                vsb.addDisposeListener(new DisposeListener(this){
                    final /* synthetic */ ChatRoom this$1;
                    {
                        this.this$1 = chatRoom;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        ScrollBar vb;
                        StyledText ot = ChatRoom.access$1(this.this$1);
                        if (ot != null && (vb = ot.getVerticalBar()) != null) {
                            vb.removeSelectionListener(ChatRoom.access$5(this.this$1));
                        }
                    }
                });
            }
        }

        protected void makeTabItemBold() {
            this.changeTabItem(true);
        }

        protected void makeTabItemNormal() {
            this.changeTabItem(false);
        }

        protected void changeTabItem(boolean bold) {
            CTabItem item = this.chatRoomTab.tabItem;
            Font oldFont = item.getFont();
            FontData[] fd = oldFont.getFontData();
            item.setFont(new Font(oldFont.getDevice(), fd[0].getName(), fd[0].getHeight(), bold ? 1 : 0));
        }

        public void handleMessage(ID fromID, String messageBody) {
            Display.getDefault().asyncExec(new Runnable(this, messageBody, fromID){
                final /* synthetic */ ChatRoom this$1;
                private final /* synthetic */ String val$messageBody;
                private final /* synthetic */ ID val$fromID;
                {
                    this.this$1 = chatRoom;
                    this.val$messageBody = string;
                    this.val$fromID = iD;
                }

                public void run() {
                    if (ChatRoom.access$9((ChatRoom)this.this$1).rootDisposed) {
                        return;
                    }
                    ChatRoom.access$9(this.this$1).appendText(ChatRoom.access$2(this.this$1), ChatRoom.access$1(this.this$1), new ChatLine(this.val$messageBody, ChatRoom.access$9(this.this$1).new ChatRoomParticipant(this.val$fromID)));
                }
            });
        }

        public void handleInvitationReceived(ID roomID, ID from, String subject, String body) {
        }

        public void keyPressed(KeyEvent e) {
            this.handleKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            this.handleKeyReleased(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleKeyPressed(KeyEvent evt) {
            Text inputText = this.getInputText();
            if (evt.character == '\r') {
                if (inputText.getText().trim().length() > 0) {
                    this.handleTextInput(inputText.getText());
                }
                this.clearInput();
                this.makeTabItemNormal();
                if (Activator.getDefault().getPreferenceStore().getBoolean("chatroom.scrollonuserinput")) {
                    ChatRoomManagerView.this.scrollToEnd(this.getOutputText());
                }
                evt.doit = false;
                this.isCycling = false;
            } else if (evt.character == '\t') {
                evt.doit = false;
                int pos = inputText.getCaretPosition();
                if (pos == 0) {
                    return;
                }
                String text = inputText.getText();
                if (this.isCycling) {
                    if (this.choice == this.options.size()) {
                        this.choice = 0;
                    }
                    String append = String.valueOf((String)this.options.get(this.choice++)) + (this.isAtStart ? String.valueOf(this.nickCompletionSuffix) + " " : " ");
                    inputText.setText(String.valueOf(text.substring(0, this.caret - this.prefixLength)) + append + text.substring(this.caret + this.nickRemainder));
                    this.nickRemainder = append.length() - this.prefixLength;
                    inputText.setSelection(this.caret + this.nickRemainder);
                } else {
                    int count = pos - 1;
                    while (count > -1 && !Character.isWhitespace(text.charAt(count))) {
                        --count;
                    }
                    this.options.clear();
                    String prefix = text.substring(++count, pos).toLowerCase();
                    boolean bl = this.isAtStart = count == 0;
                    if (prefix.trim().equals("")) {
                        return;
                    }
                    TableItem[] participants = this.chatRoomParticipantViewer.getTable().getItems();
                    int i = 0;
                    while (i < participants.length) {
                        String name = participants[i].getText();
                        if (name.toLowerCase().startsWith(prefix)) {
                            this.options.add(name);
                        }
                        ++i;
                    }
                    if (this.options.isEmpty()) {
                        return;
                    }
                    this.prefixLength = prefix.length();
                    if (this.options.size() == 1) {
                        String nickname = (String)this.options.get(0);
                        inputText.setSelection(pos - this.prefixLength, pos);
                        inputText.insert(String.valueOf(nickname) + (this.isAtStart ? String.valueOf(this.nickCompletionSuffix) + " " : " "));
                    } else if (this.options.size() <= this.maximumCyclingOptions) {
                        this.isCycling = true;
                        this.caret = pos;
                        this.choice = 0;
                        String nickname = this.options.get(this.choice++) + (this.isAtStart ? String.valueOf(this.nickCompletionSuffix) + " " : " ");
                        inputText.setSelection(pos - this.prefixLength, pos);
                        inputText.insert(nickname);
                        this.nickRemainder = nickname.length() - this.prefixLength;
                    } else {
                        StringBuffer choices;
                        StringBuffer stringBuffer = choices = new StringBuffer();
                        synchronized (stringBuffer) {
                            int i2 = 0;
                            while (i2 < this.options.size()) {
                                choices.append(this.options.get(i2)).append(' ');
                                ++i2;
                            }
                            choices.delete(choices.length() - 1, choices.length());
                        }
                        ChatRoomManagerView.this.appendText(this.chatRoomTab, this.getOutputText(), new ChatLine(choices.toString()));
                    }
                }
            } else {
                this.isCycling = false;
            }
        }

        protected void handleKeyReleased(KeyEvent evt) {
            if (evt.character == '\t') {
                evt.doit = false;
            }
        }

        protected void handleTextInput(String text) {
            if (this.chatRoomMessageSender == null) {
                MessageDialog.openError((Shell)ChatRoomManagerView.this.getViewSite().getShell(), (String)Messages.ChatRoomManagerView_NOT_CONNECTED_TITLE, (String)Messages.ChatRoomManagerView_NOT_CONNECTED_MESSAGE);
                return;
            }
            String output = ChatRoomManagerView.this.processForCommand(this.chatRoomContainer, text);
            if (output != null) {
                this.sendMessageLine(output);
            }
        }

        protected void chatRoomDisconnect() {
            if (this.chatRoomContainer != null) {
                this.chatRoomContainer.disconnect();
            }
        }

        protected void clearInput() {
            this.getInputText().setText("");
        }

        protected void sendMessageLine(String line) {
            try {
                this.chatRoomMessageSender.sendMessage(line);
            }
            catch (ECFException eCFException) {
                this.disconnected();
            }
        }

        public void handlePresence(ID fromID, IPresence presence) {
            Display.getDefault().asyncExec(new Runnable(this, presence, fromID){
                final /* synthetic */ ChatRoom this$1;
                private final /* synthetic */ IPresence val$presence;
                private final /* synthetic */ ID val$fromID;
                {
                    this.this$1 = chatRoom;
                    this.val$presence = iPresence;
                    this.val$fromID = iD;
                }

                public void run() {
                    if (ChatRoom.access$9((ChatRoom)this.this$1).rootDisposed) {
                        return;
                    }
                    boolean isAdd = this.val$presence.getType().equals((Object)IPresence.Type.AVAILABLE);
                    ChatRoomParticipant p = ChatRoom.access$9(this.this$1).new ChatRoomParticipant(this.val$fromID);
                    if (isAdd) {
                        if (ChatRoom.access$6(this.this$1) == null) {
                            ChatRoom.access$7(this.this$1, p);
                        }
                        this.this$1.addParticipant(p);
                    } else {
                        this.this$1.removeParticipant(p);
                    }
                }
            });
        }

        public void disconnected() {
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ ChatRoom this$1;
                {
                    this.this$1 = chatRoom;
                }

                public void run() {
                    if (ChatRoom.access$9((ChatRoom)this.this$1).rootDisposed) {
                        return;
                    }
                    Text inputText = ChatRoom.access$8(this.this$1);
                    if (!inputText.isDisposed()) {
                        inputText.setEnabled(false);
                    }
                }
            });
        }

        protected boolean isConnected() {
            Text inputText = this.getInputText();
            return !inputText.isDisposed() && inputText.isEnabled();
        }

        protected void setSelected() {
            ChatRoomManagerView.this.rootTabFolder.setSelection(this.chatRoomTab.tabItem);
        }

        protected void addParticipant(IUser p) {
            ID id;
            if (p != null && (id = p.getID()) != null) {
                Preferences prefs = Activator.getDefault().getPluginPreferences();
                if (prefs.getBoolean("chatroom.user.presence.visible")) {
                    ChatRoomManagerView.this.appendText(this.chatRoomTab, this.getOutputText(), new ChatLine(NLS.bind((String)Messages.ChatRoomManagerView_ENTERED_MESSAGE, (Object)ChatRoomManagerView.getUsernameFromID(id)), null));
                }
                this.chatRoomParticipantViewer.add((Object)p);
                this.chatRoomParticipantsLabel.setText(NLS.bind((String)Messages.ChatRoomManagerView_USERS_IN_CHAT_ROOM, (Object)String.valueOf(this.chatRoomContainer.getChatRoomParticipants().length)));
            }
        }

        protected boolean isLocalUser(ID id) {
            if (this.localUser == null) {
                return false;
            }
            return this.localUser.getID().equals((Object)id);
        }

        protected void removeLocalUser() {
            String title = ChatRoomManagerView.this.getPartName();
            ChatRoomManagerView.this.setPartName(NLS.bind((String)Messages.ChatRoomManagerView_VIEW_DISABLED_NAME, (Object)title));
            this.removeAllParticipants();
            ChatRoomManagerView.this.disconnect();
            ChatRoomManagerView.this.setEnabled(false);
        }

        protected void removeParticipant(IUser p) {
            ID id;
            if (p != null && (id = p.getID()) != null) {
                Preferences prefs = Activator.getDefault().getPluginPreferences();
                if (prefs.getBoolean("chatroom.user.presence.visible")) {
                    ChatRoomManagerView.this.appendText(this.chatRoomTab, this.getOutputText(), new ChatLine(NLS.bind((String)Messages.ChatRoomManagerView_LEFT_MESSAGE, (Object)ChatRoomManagerView.getUsernameFromID(id)), null));
                }
                this.chatRoomParticipantViewer.remove((Object)p);
                this.chatRoomParticipantsLabel.setText(NLS.bind((String)Messages.ChatRoomManagerView_USERS_IN_CHAT_ROOM, (Object)String.valueOf(this.chatRoomContainer.getChatRoomParticipants().length)));
            }
        }

        protected void removeAllParticipants() {
            Table t = this.chatRoomParticipantViewer.getTable();
            int i = 0;
            while (i < t.getItemCount()) {
                Object o = this.chatRoomParticipantViewer.getElementAt(i);
                if (o != null) {
                    this.chatRoomParticipantViewer.remove(o);
                }
                ++i;
            }
            this.chatRoomParticipantsLabel.setText(NLS.bind((String)Messages.ChatRoomManagerView_USERS_IN_CHAT_ROOM, (Object)String.valueOf(this.chatRoomContainer.getChatRoomParticipants().length)));
        }

        static /* synthetic */ StyledText access$1(ChatRoom chatRoom) {
            return chatRoom.getOutputText();
        }

        static /* synthetic */ void access$3(ChatRoom chatRoom, CTabItem cTabItem) {
            chatRoom.itemSelected = cTabItem;
        }

        static /* synthetic */ CTabItem access$4(ChatRoom chatRoom) {
            return chatRoom.itemSelected;
        }

        static /* synthetic */ SelectionListener access$5(ChatRoom chatRoom) {
            return chatRoom.scrollSelectionListener;
        }

        static /* synthetic */ IUser access$6(ChatRoom chatRoom) {
            return chatRoom.localUser;
        }

        static /* synthetic */ void access$7(ChatRoom chatRoom, IUser iUser) {
            chatRoom.localUser = iUser;
        }

        static /* synthetic */ Text access$8(ChatRoom chatRoom) {
            return chatRoom.getInputText();
        }

        static /* synthetic */ ChatRoomManagerView access$9(ChatRoom chatRoom) {
            return chatRoom.ChatRoomManagerView.this;
        }
    }

    class ChatRoomParticipant
    implements IUser,
    IActionFilter {
        private static final long serialVersionUID = 2008114088656711572L;
        ID id;

        public ChatRoomParticipant(ID id) {
            this.id = id;
        }

        public ID getID() {
            return this.id;
        }

        public String getName() {
            return this.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ChatRoomParticipant)) {
                return false;
            }
            ChatRoomParticipant o = (ChatRoomParticipant)other;
            return this.id.equals((Object)o.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return ChatRoomManagerView.getUsernameFromID(this.id);
        }

        public Map getProperties() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getNickname() {
            return this.getName();
        }

        public boolean testAttribute(Object target, String name, String value) {
            if (name.equals("scheme")) {
                IChatRoomContainer c = ChatRoomManagerView.this.container;
                String scheme = c.getConnectedID().getNamespace().getScheme();
                return scheme.equalsIgnoreCase(value);
            }
            return false;
        }
    }

    class ChatRoomTab {
        private SashForm fullChat;
        private CTabItem tabItem;
        private SashForm rightSash;
        private StyledText subjectText;
        private StyledText outputText;
        private Text inputText;
        private Label participantsNumberLabel;
        private TableViewer participantsTable;
        private Action tabSelectAll;
        private Action tabCopy;
        private Action tabClear;
        private Action tabPaste;
        private boolean withParticipants;
        private SelectionListener scrollSelectionListener = new SelectionListener(this){
            final /* synthetic */ ChatRoomTab this$1;
            {
                this.this$1 = chatRoomTab;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ChatRoomManagerView.access$0(ChatRoomTab.access$5(this.this$1), this.this$1.getOutputText())) {
                    this.this$1.makeTabItemNormal();
                }
            }
        };

        ChatRoomTab(CTabFolder parent, String name) {
            this(true, parent, name, null);
        }

        ChatRoomTab(boolean withParticipantsList, CTabFolder parent, String name, KeyListener keyListener) {
            ScrollBar vsb;
            StyledText st;
            this.withParticipants = withParticipantsList;
            this.tabItem = new CTabItem(parent, 0);
            this.tabItem.setText(name);
            if (this.withParticipants) {
                this.fullChat = new SashForm((Composite)parent, 256);
                this.fullChat.setLayout((Layout)new FillLayout());
                Composite memberComp = new Composite((Composite)this.fullChat, 0);
                GridLayout layout = new GridLayout(1, true);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                memberComp.setLayout((Layout)layout);
                this.participantsNumberLabel = new Label(memberComp, 2056);
                this.participantsNumberLabel.setLayoutData((Object)new GridData(4, 1, true, false));
                this.participantsNumberLabel.setAlignment(0x1000000);
                this.participantsTable = new TableViewer(memberComp, 2818);
                this.participantsTable.setSorter(new ViewerSorter());
                this.participantsTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                this.participantsTable.addOpenListener(new IOpenListener(this){
                    final /* synthetic */ ChatRoomTab this$1;
                    {
                        this.this$1 = chatRoomTab;
                    }

                    public void open(OpenEvent event) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        String user = ((ChatRoomParticipant)selection.getFirstElement()).getName();
                        if (!ChatRoomManagerView.access$1(ChatRoomTab.access$5(this.this$1)).equals(user)) {
                            try {
                                MessagesView messagesView = ChatRoomManagerView.access$2(ChatRoomTab.access$5(this.this$1));
                                messagesView.selectTab(ChatRoomManagerView.access$3(ChatRoomTab.access$5(this.this$1)).getPrivateMessageSender(), null, ChatRoomManagerView.access$4(ChatRoomTab.access$5(this.this$1), ChatRoomManagerView.access$1(ChatRoomTab.access$5(this.this$1))), ChatRoomManagerView.access$4(ChatRoomTab.access$5(this.this$1), user));
                                ChatRoomTab.access$5(this.this$1).getSite().getPage().activate((IWorkbenchPart)messagesView);
                            }
                            catch (PartInitException e) {
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, NLS.bind((String)Messages.ChatRoomManagerView_EXCEPTION_MESSAGE_VIEW_INITIALIZATION, (Object)user), (Throwable)e));
                            }
                        }
                    }
                });
                Composite rightComp = new Composite((Composite)this.fullChat, 0);
                rightComp.setLayout((Layout)layout);
                this.subjectText = this.createStyledTextWidget(rightComp, 2052);
                this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.subjectText.addKeyListener((KeyListener)new KeyAdapter(this){
                    final /* synthetic */ ChatRoomTab this$1;
                    {
                        this.this$1 = chatRoomTab;
                    }

                    public void keyPressed(KeyEvent evt) {
                        ChatRoom chatroom;
                        if ((evt.character == '\r' || evt.character == '\u1000050') && (chatroom = (ChatRoom)ChatRoomManagerView.access$5(ChatRoomTab.access$5(this.this$1)).get(ChatRoomTab.access$0(this.this$1).getText())) != null) {
                            IChatRoomAdminSender chatRoomAdminSender = ChatRoom.access$0(chatroom).getChatRoomAdminSender();
                            try {
                                if (chatRoomAdminSender != null) {
                                    chatRoomAdminSender.sendSubjectChange(ChatRoomTab.access$1(this.this$1).getText());
                                }
                            }
                            catch (ECFException eCFException) {
                                ChatRoomTab.access$5(this.this$1).disconnected();
                            }
                        }
                    }
                });
                this.rightSash = new SashForm(rightComp, 512);
                this.rightSash.setLayoutData((Object)new GridData(4, 4, true, true));
            } else {
                this.rightSash = new SashForm((Composite)parent, 512);
            }
            this.outputText = this.createStyledTextWidget((Composite)this.rightSash, 2634);
            this.outputText.setEditable(false);
            this.outputText.setLayoutData((Object)new GridData(1808));
            this.inputText = new Text((Composite)this.rightSash, 2626);
            if (keyListener != null) {
                this.inputText.addKeyListener(keyListener);
            }
            this.rightSash.setWeights(new int[]{9, 1});
            if (this.withParticipants) {
                this.fullChat.setWeights(new int[]{15, 85});
                this.tabItem.setControl((Control)this.fullChat);
            } else {
                this.tabItem.setControl((Control)this.rightSash);
            }
            parent.setSelection(this.tabItem);
            this.makeActions();
            this.hookContextMenu();
            if (this.withParticipants) {
                this.hookParticipantsContextMenu();
            }
            if ((st = this.getOutputText()) != null && (vsb = st.getVerticalBar()) != null) {
                vsb.addSelectionListener(this.scrollSelectionListener);
                vsb.addDisposeListener(new DisposeListener(this){
                    final /* synthetic */ ChatRoomTab this$1;
                    {
                        this.this$1 = chatRoomTab;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        ScrollBar sb;
                        StyledText ot = this.this$1.getOutputText();
                        if (ot != null && (sb = ot.getVerticalBar()) != null) {
                            sb.removeSelectionListener(ChatRoomTab.access$2(this.this$1));
                        }
                    }
                });
            }
        }

        protected void makeTabItemBold() {
            this.changeTabItem(true);
        }

        protected void makeTabItemNormal() {
            this.changeTabItem(false);
        }

        protected void changeTabItem(boolean bold) {
            CTabItem item = this.tabItem;
            Font oldFont = item.getFont();
            FontData[] fd = oldFont.getFontData();
            item.setFont(new Font(oldFont.getDevice(), fd[0].getName(), fd[0].getHeight(), bold ? 1 : 0));
        }

        private StyledText createStyledTextWidget(Composite parent, int styles) {
            try {
                SourceViewer result = new SourceViewer(parent, null, null, true, styles);
                result.configure((SourceViewerConfiguration)new ChatRoomViewerConfiguration(EditorsUI.getPreferenceStore(), ChatRoomManagerView.this.container, ChatRoomManagerView.this));
                result.setDocument((IDocument)new Document());
                return result.getTextWidget();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.presence.ui", 2, Messages.ChatRoomManagerView_WARNING_HYPERLINKING_NOT_AVAILABLE, (Throwable)e));
                return new StyledText(parent, styles);
            }
            catch (NoClassDefFoundError e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.presence.ui", 2, Messages.ChatRoomManagerView_WARNING_HYPERLINKING_NOT_AVAILABLE, (Throwable)e));
                return new StyledText(parent, styles);
            }
        }

        protected void outputClear() {
            if (MessageDialog.openConfirm(null, (String)Messages.ChatRoomManagerView_CONFIRM_CLEAR_TEXT_OUTPUT_TITLE, (String)Messages.ChatRoomManagerView_CONFIRM_CLEAR_TEXT_OUTPUT_MESSAGE)) {
                this.outputText.setText("");
            }
        }

        protected void outputCopy() {
            String t = this.outputText.getSelectionText();
            if (t == null || t.length() == 0) {
                this.outputText.selectAll();
            }
            this.outputText.copy();
            this.outputText.setSelection(this.outputText.getText().length());
        }

        private void fillContextMenu(IMenuManager manager) {
            manager.add((IAction)this.tabCopy);
            manager.add((IAction)this.tabPaste);
            manager.add((IAction)this.tabClear);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.tabSelectAll);
            manager.add((IContributionItem)new Separator("additions"));
        }

        private void hookContextMenu() {
            MenuManager menuMgr = new MenuManager();
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void menuAboutToShow(IMenuManager manager) {
                    ChatRoomTab.access$3(this.this$1, manager);
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)this.outputText);
            this.outputText.setMenu(menu);
            ISelectionProvider selectionProvider = new ISelectionProvider(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    TextSelection selection = new TextSelection(ChatRoomTab.access$4((ChatRoomTab)this.this$1).getSelectionRange().x, ChatRoomTab.access$4((ChatRoomTab)this.this$1).getSelectionRange().y);
                    return selection;
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                    if (selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        ChatRoomTab.access$4(this.this$1).setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                    }
                }
            };
            ChatRoomManagerView.this.getSite().registerContextMenu(menuMgr, selectionProvider);
        }

        private void hookParticipantsContextMenu() {
            MenuManager menuMgr = new MenuManager();
            menuMgr.addMenuListener(new IMenuListener(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IContributionItem)new Separator("additions"));
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            Control control = this.participantsTable.getControl();
            Menu menu = menuMgr.createContextMenu(control);
            control.setMenu(menu);
            ChatRoomManagerView.this.getSite().registerContextMenu(ChatRoomManagerView.PARTICIPANTS_MENU_ID, menuMgr, (ISelectionProvider)this.participantsTable);
        }

        private void makeActions() {
            this.tabSelectAll = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    ChatRoomTab.access$4(this.this$1).selectAll();
                }
            };
            this.tabSelectAll.setText(Messages.ChatRoomManagerView_SELECT_ALL_TEXT);
            this.tabSelectAll.setToolTipText(Messages.ChatRoomManagerView_SELECT_ALL_TOOLTIP);
            this.tabSelectAll.setAccelerator(262209);
            this.tabCopy = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    this.this$1.outputCopy();
                }
            };
            this.tabCopy.setText(Messages.ChatRoomManagerView_COPY_TEXT);
            this.tabCopy.setToolTipText(Messages.ChatRoomManagerView_COPY_TOOLTIP);
            this.tabCopy.setAccelerator(262211);
            this.tabCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
            this.tabClear = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    this.this$1.outputClear();
                }
            };
            this.tabClear.setText(Messages.ChatRoomManagerView_CLEAR_TEXT);
            this.tabClear.setToolTipText(Messages.ChatRoomManagerView_CLEAR_TOOLTIP);
            this.tabPaste = new Action(this){
                final /* synthetic */ ChatRoomTab this$1;
                {
                    this.this$1 = chatRoomTab;
                }

                public void run() {
                    this.this$1.getInputText().paste();
                }
            };
            this.tabPaste.setText(Messages.ChatRoomManagerView_PASTE_TEXT);
            this.tabPaste.setToolTipText(Messages.ChatRoomManagerView_PASTE_TOOLTIP);
            this.tabPaste.setAccelerator(262230);
            this.tabPaste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        }

        protected Text getInputText() {
            return this.inputText;
        }

        protected void setKeyListener(KeyListener listener) {
            if (listener != null) {
                this.inputText.addKeyListener(listener);
            }
        }

        protected Label getParticipantsLabel() {
            return this.participantsNumberLabel;
        }

        protected TableViewer getParticipantsViewer() {
            return this.participantsTable;
        }

        public StyledText getOutputText() {
            return this.outputText;
        }

        public void setSubject(String subject) {
            this.subjectText.setText(subject);
        }

        static /* synthetic */ StyledText access$1(ChatRoomTab chatRoomTab) {
            return chatRoomTab.subjectText;
        }

        static /* synthetic */ SelectionListener access$2(ChatRoomTab chatRoomTab) {
            return chatRoomTab.scrollSelectionListener;
        }

        static /* synthetic */ void access$3(ChatRoomTab chatRoomTab, IMenuManager iMenuManager) {
            chatRoomTab.fillContextMenu(iMenuManager);
        }

        static /* synthetic */ StyledText access$4(ChatRoomTab chatRoomTab) {
            return chatRoomTab.outputText;
        }

        static /* synthetic */ ChatRoomManagerView access$5(ChatRoomTab chatRoomTab) {
            return chatRoomTab.ChatRoomManagerView.this;
        }
    }
}

