/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import ch.ethz.iks.slp.Advertiser;
import ch.ethz.iks.slp.Locator;
import ch.ethz.iks.slp.ServiceLocationEnumeration;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.jslp.JSLPDebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.jslp";
    private BundleContext bundleContext;
    private ServiceTracker locatorST;
    private ServiceTracker advertiserST;
    private final ServiceLocationEnumeration emptyServiceLocationEnumeration = new ServiceLocationEnumeration(){

        public Object next() throws ServiceLocationException {
            throw new ServiceLocationException(20, "no elements");
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Activator getDefault() {
        return plugin;
    }

    public Activator() {
        plugin = this;
    }

    public Bundle getBundle() {
        return this.bundleContext.getBundle();
    }

    private Locator getLocator() {
        try {
            this.locatorST.open();
            Locator service = (Locator)this.locatorST.waitForService(10000L);
            return service;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private Advertiser getAdvertiser() {
        try {
            this.advertiserST.open();
            this.advertiserST.waitForService(10000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return (Advertiser)this.advertiserST.getService();
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.iks.slp.Locator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.locatorST = new ServiceTracker(this.bundleContext, clazz.getName(), null);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.ethz.iks.slp.Advertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.advertiserST = new ServiceTracker(this.bundleContext, clazz2.getName(), null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.locatorST != null) {
            this.locatorST.close();
            this.locatorST = null;
        }
        if (this.advertiserST != null) {
            this.advertiserST.close();
            this.advertiserST = null;
        }
        plugin = null;
        this.bundleContext = null;
    }

    public ServiceLocationEnumeration findServiceTypes(String namingAuthority, List scopes) throws ServiceLocationException {
        Locator locator = this.getLocator();
        if (locator != null) {
            return locator.findServiceTypes(namingAuthority, scopes);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("ch.ethz.iks.slp.Locator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"findServiceTypes(String, List)", (String)stringBuffer.append(clazz2).append(" not present").toString());
        return this.emptyServiceLocationEnumeration;
    }

    private ServiceLocationEnumeration findServices(ServiceType type, List scopes, String searchFilter) throws ServiceLocationException {
        Locator locator = this.getLocator();
        if (locator != null) {
            return locator.findServices(type, scopes, searchFilter);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("ch.ethz.iks.slp.Locator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"findServies(ServiceType, List, String)", (String)stringBuffer.append(clazz2).append(" not present").toString());
        return this.emptyServiceLocationEnumeration;
    }

    private ServiceLocationEnumeration findAttributes(ServiceURL anURL, List scopes, List attributes) throws ServiceLocationException {
        Locator locator = this.getLocator();
        if (locator != null) {
            return locator.findAttributes(anURL, scopes, attributes);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("ch.ethz.iks.slp.Locator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"findAttributes(ch.ethz.iks.slp.ServiceType, java.util.List, java.util.List)", (String)stringBuffer.append(clazz2).append(" not present").toString());
        return this.emptyServiceLocationEnumeration;
    }

    public void deregister(ServiceURL url) throws ServiceLocationException {
        Advertiser advertiser = this.getAdvertiser();
        if (advertiser != null) {
            advertiser.deregister(url);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.ethz.iks.slp.Advertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"deregister(ServiceURL)", (String)stringBuffer.append(clazz2).append(" not present").toString());
    }

    public void deregister(ServiceURL url, List scopes) throws ServiceLocationException {
        Advertiser advertiser = this.getAdvertiser();
        if (advertiser != null) {
            advertiser.deregister(url, scopes);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.ethz.iks.slp.Advertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"deregister(ServiceURL, List)", (String)stringBuffer.append(clazz2).append(" not present").toString());
    }

    public void register(ServiceURL url, Dictionary attributes) throws ServiceLocationException {
        Advertiser advertiser = this.getAdvertiser();
        if (advertiser != null) {
            advertiser.register(url, attributes);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.ethz.iks.slp.Advertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"register(ServiceURL, Dictionary)", (String)stringBuffer.append(clazz2).append(" not present").toString());
    }

    public void register(ServiceURL url, List scopes, Dictionary attributes) throws ServiceLocationException {
        Advertiser advertiser = this.getAdvertiser();
        if (advertiser != null) {
            advertiser.register(url, scopes, attributes);
        }
        Class<?> clazz = this.getClass();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.ethz.iks.slp.Advertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.trace((String)PLUGIN_ID, (String)JSLPDebugOptions.METHODS_TRACING, clazz, (String)"register(ServiceURL, List, Dictionary)", (String)stringBuffer.append(clazz2).append(" not present").toString());
    }

    public Map getServiceURLs() throws ServiceLocationException {
        ServiceLocationEnumeration stEnum = this.findServiceTypes(null, null);
        HashSet aSet = new HashSet(Collections.list(stEnum));
        HashMap result = new HashMap();
        Iterator itr = aSet.iterator();
        while (itr.hasNext()) {
            String type = (String)itr.next();
            ServiceLocationEnumeration services = this.findServices(new ServiceType(type), null, null);
            while (services.hasMoreElements()) {
                ServiceURL url = (ServiceURL)services.next();
                result.put(url, Collections.list(this.findAttributes(url, null, null)));
            }
        }
        return result;
    }

    public Map getServiceURLs(ServiceType aServiceType, List scopes) throws ServiceLocationException {
        HashMap result = new HashMap();
        ServiceLocationEnumeration services = this.findServices(aServiceType, scopes, null);
        while (services.hasMoreElements()) {
            ServiceURL url = (ServiceURL)services.next();
            result.put(url, Collections.list(this.findAttributes(url, scopes, null)));
        }
        return result;
    }
}

