/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.ecf.core.util.AsyncResult;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.IAsyncResult;
import org.eclipse.ecf.internal.provider.remoteservice.Messages;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;

public class RemoteServiceImpl
implements IRemoteService,
InvocationHandler {
    protected static final long DEFAULT_TIMEOUT = 30000L;
    protected RemoteServiceRegistrationImpl registration = null;
    protected RegistrySharedObject sharedObject = null;

    public RemoteServiceImpl(RegistrySharedObject sharedObject, RemoteServiceRegistrationImpl registration) {
        this.sharedObject = sharedObject;
        this.registration = registration;
    }

    public void callAsynch(IRemoteCall call, IRemoteCallListener listener) {
        this.sharedObject.sendCallRequestWithListener(this.registration, call, listener);
    }

    public IAsyncResult callAsynch(IRemoteCall call) {
        final AsyncResult result = new AsyncResult();
        IRemoteCallListener listener = new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    IRemoteCallCompleteEvent cce = (IRemoteCallCompleteEvent)event;
                    if (cce.hadException()) {
                        result.setException(cce.getException());
                    } else {
                        result.set(cce.getResponse());
                    }
                }
            }
        };
        this.callAsynch(call, listener);
        return result;
    }

    public Object callSynch(IRemoteCall call) throws ECFException {
        return this.sharedObject.callSynch(this.registration, call);
    }

    public void fireAsynch(IRemoteCall call) throws ECFException {
        this.sharedObject.sendFireRequest(this.registration, call);
    }

    public Object getProxy() throws ECFException {
        Object proxy;
        try {
            String[] clazzes = this.registration.getClasses();
            Class[] cs = new Class[clazzes.length];
            int i = 0;
            while (i < clazzes.length) {
                cs[i] = Class.forName(clazzes[i]);
                ++i;
            }
            proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), cs, (InvocationHandler)this);
        }
        catch (Exception e) {
            throw new ECFException(Messages.RemoteServiceImpl_EXCEPTION_CREATING_PROXY, (Throwable)e);
        }
        return proxy;
    }

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        return this.callSynch(new IRemoteCall(){

            public String getMethod() {
                return method.getName();
            }

            public Object[] getParameters() {
                return args;
            }

            public long getTimeout() {
                return 30000L;
            }
        });
    }
}

