/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.presence.service.IPresenceService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class XmppPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.xmpp";
    protected static final String NAMESPACE_IDENTIFIER = "ecf.xmpp";
    protected static final String SECURE_NAMESPACE_IDENTIFIER = "ecf.xmpps";
    protected static final String ROOM_NAMESPACE_IDENTIFIER = "xmpp.room.jive";
    private static XmppPlugin plugin;
    private BundleContext context = null;
    private ServiceTracker logServiceTracker = null;
    private Map services;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void log(String message) {
        XmppPlugin.getDefault().log((IStatus)new Status(0, PLUGIN_ID, 0, message, null));
    }

    public static void log(String message, Throwable e) {
        XmppPlugin.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 0, message, e));
    }

    public XmppPlugin() {
        plugin = this;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.services = new HashMap();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        this.context = null;
        plugin = null;
    }

    public void registerService(IPresenceService service) {
        if (this.context != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.presence.service.IPresenceService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.services.put(service, this.context.registerService(clazz.getName(), (Object)service, null));
        }
    }

    public void unregisterService(IPresenceService service) {
        ServiceRegistration registration = (ServiceRegistration)this.services.remove(service);
        if (registration != null) {
            registration.unregister();
        }
    }

    public static synchronized XmppPlugin getDefault() {
        if (plugin == null) {
            plugin = new XmppPlugin();
        }
        return plugin;
    }

    public String getNamespaceIdentifier() {
        return NAMESPACE_IDENTIFIER;
    }

    public String getSecureNamespaceIdentifier() {
        return SECURE_NAMESPACE_IDENTIFIER;
    }

    public String getRoomNamespaceIdentifier() {
        return ROOM_NAMESPACE_IDENTIFIER;
    }
}

