/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.filetransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.FileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.SendFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.xmpp.filetransfer.XMPPFileTransferRequestListener;
import org.eclipse.ecf.internal.provider.xmpp.filetransfer.XMPPOutgoingFileTransfer;
import org.eclipse.ecf.provider.xmpp.XMPPContainer;
import org.eclipse.ecf.provider.xmpp.identity.XMPPFileID;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;

public class XMPPOutgoingFileTransferHelper
implements ISendFileTransferContainerAdapter {
    List transferListeners = new ArrayList();
    List incomingListeners = new ArrayList();
    XMPPContainer container = null;
    FileTransferManager manager = null;

    public XMPPOutgoingFileTransferHelper(XMPPContainer container) {
        this.container = container;
    }

    public void dispose() {
        this.transferListeners.clear();
        this.incomingListeners.clear();
        this.manager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileTransferListener(IFileTransferListener listener) {
        List list = this.transferListeners;
        synchronized (list) {
            this.transferListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFileTransferListener(IFileTransferListener listener) {
        List list = this.transferListeners;
        synchronized (list) {
            this.transferListeners.remove(listener);
        }
    }

    public void addListener(IIncomingFileTransferRequestListener listener) {
        if (listener == null) {
            return;
        }
        XMPPFileTransferRequestListener xmppListener = new XMPPFileTransferRequestListener((IContainer)this.container, listener);
        this.incomingListeners.add(xmppListener);
        if (this.manager != null) {
            this.manager.addFileTransferListener((FileTransferListener)xmppListener);
        }
    }

    public void sendOutgoingRequest(IFileID targetReceiver, IFileTransferInfo localFileToSend, IFileTransferListener progressListener, Map options) throws SendFileTransferException {
        if (this.manager == null) {
            throw new SendFileTransferException("not connected");
        }
        if (!(targetReceiver instanceof XMPPFileID)) {
            throw new SendFileTransferException("target receiver not XMPPFileID type.");
        }
        XMPPFileID fileID = (XMPPFileID)targetReceiver;
        XMPPOutgoingFileTransfer fileTransfer = new XMPPOutgoingFileTransfer(this.manager, fileID.getXMPPID(), localFileToSend, progressListener);
        try {
            fileTransfer.startSend(localFileToSend.getFile(), localFileToSend.getDescription());
        }
        catch (XMPPException e) {
            throw new SendFileTransferException("Exception sending outgoing file transfer request", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFileTransferEvent(IFileTransferEvent event) {
        List list = this.transferListeners;
        synchronized (list) {
            Iterator i = this.transferListeners.iterator();
            while (i.hasNext()) {
                IFileTransferListener l = (IFileTransferListener)i.next();
                l.handleTransferEvent(event);
            }
        }
    }

    public Namespace getOutgoingFileTransferNamespace() {
        return this.container.getConnectNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(IIncomingFileTransferRequestListener listener) {
        if (listener == null) {
            return false;
        }
        List list = this.incomingListeners;
        synchronized (list) {
            Iterator i = this.incomingListeners.iterator();
            while (i.hasNext()) {
                XMPPFileTransferRequestListener ftl = (XMPPFileTransferRequestListener)i.next();
                if (!ftl.hasListener(listener)) continue;
                this.manager.removeFileTransferListener((FileTransferListener)ftl);
                i.remove();
            }
        }
        return true;
    }

    public void sendOutgoingRequest(IFileID targetReceiver, File localFileToSend, IFileTransferListener transferListener, Map options) throws SendFileTransferException {
        this.sendOutgoingRequest(targetReceiver, (IFileTransferInfo)new FileTransferInfo(localFileToSend), transferListener, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(XMPPConnection connection) {
        if (connection != null) {
            List list = this.incomingListeners;
            synchronized (list) {
                this.manager = new FileTransferManager(connection);
                Iterator i = this.incomingListeners.iterator();
                while (i.hasNext()) {
                    XMPPFileTransferRequestListener ftl = (XMPPFileTransferRequestListener)i.next();
                    this.manager.addFileTransferListener((FileTransferListener)ftl);
                }
            }
        }
        if (this.manager != null) {
            List list = this.incomingListeners;
            synchronized (list) {
                Iterator i = this.incomingListeners.iterator();
                while (i.hasNext()) {
                    XMPPFileTransferRequestListener ftl = (XMPPFileTransferRequestListener)i.next();
                    this.manager.removeFileTransferListener((FileTransferListener)ftl);
                }
                this.manager = null;
            }
        }
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
    }

    public void setProxy(Proxy proxy) {
    }

    public Namespace getOutgoingNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.provider.filetransfer.xmpp");
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

